/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.util.ByteArrayReader;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class ReferenceMapDecoder {
    /*
     * Unable to fully structure code
     */
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkOffsetsFromPointer(PointerBase baseAddress, byte[] referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor) {
        if (!ReferenceMapDecoder.$assertionsDisabled && referenceMapIndex == -1L) {
            throw new AssertionError();
        }
        if (!ReferenceMapDecoder.$assertionsDisabled && referenceMapEncoding == null) {
            throw new AssertionError();
        }
        uncompressedSize = WordFactory.unsigned((int)FrameAccess.uncompressedReferenceSize());
        compressedSize = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getReferenceSize());
        objRef = (Pointer)baseAddress;
        idx = referenceMapIndex;
        block0: while (true) {
            gap = 0L;
            shift = 0;
            do {
                b = ByteArrayReader.getU1(referenceMapEncoding, idx);
                gap |= (b & 127L) << shift;
                shift += 7;
                ++idx;
            } while ((b & 128L) != 0L);
            if ((b & 64L) != 0L && shift < 64) {
                gap |= -1L << shift;
            }
            count = 0L;
            shift = 0;
            do {
                b = ByteArrayReader.getU1(referenceMapEncoding, idx);
                count |= (b & 127L) << shift;
                shift += 7;
                ++idx;
            } while ((b & 128L) != 0L);
            if ((b & 64L) != 0L && shift < 64) {
                count |= -1L << shift;
            }
            if (gap == 0L && count == 0L) break;
            derived = false;
            if (gap < 0L) {
                gap = -(gap + 1L);
                derived = true;
            }
            objRef = objRef.add(WordFactory.unsigned((long)gap));
            compressed = count < 0L;
            refSize = compressed != false ? compressedSize : uncompressedSize;
            v0 = count = count < 0L ? -count : count;
            if (derived) {
                basePtr = baseAddress.isNull() != false ? objRef : (Pointer)objRef.readWord(0);
                visitResult = visitor.visitObjectReferenceInline(objRef, 0, compressed);
                if (!visitResult) {
                    return false;
                }
                for (d = 0L; d < count; ++d) {
                    refOffset = 0L;
                    shift = 0;
                    do {
                        b = ByteArrayReader.getU1(referenceMapEncoding, idx);
                        refOffset |= (b & 127L) << shift;
                        shift += 7;
                        ++idx;
                    } while ((b & 128L) != 0L);
                    if ((b & 64L) != 0L && shift < 64) {
                        refOffset |= -1L << shift;
                    }
                    if (derivedVisitResult = visitor.visitObjectReferenceInline(derivedRef = refOffset >= 0L ? objRef.add(WordFactory.unsigned((long)refOffset).multiply(refSize)) : objRef.subtract(WordFactory.unsigned((long)(-refOffset)).multiply(refSize)), innerOffset = NumUtil.safeToInt((long)(derivedPtr = baseAddress.isNull() != false ? derivedRef : (Pointer)derivedRef.readWord(0)).subtract((UnsignedWord)basePtr).rawValue()), compressed)) continue;
                    return false;
                }
                objRef = objRef.add(refSize);
                continue;
            }
            c = 0L;
            while (true) {
                if (c < count) ** break;
                continue block0;
                visitResult = visitor.visitObjectReferenceInline(objRef, 0, compressed);
                if (!visitResult) {
                    return false;
                }
                objRef = objRef.add(refSize);
                ++c;
            }
            break;
        }
        return true;
    }
}

