/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.FileTypeDetectorFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.Objects;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class FileTypeDetectorSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void addFirst(FileTypeDetector detector) {
        ((FileTypeDetectorFeature)ImageSingletons.lookup(FileTypeDetectorFeature.class)).installedDetectors.add(0, Objects.requireNonNull(detector));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void addLast(FileTypeDetector detector) {
        ((FileTypeDetectorFeature)ImageSingletons.lookup(FileTypeDetectorFeature.class)).installedDetectors.add(Objects.requireNonNull(detector));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setDefault(FileTypeDetector detector) {
        ((FileTypeDetectorFeature)ImageSingletons.lookup(FileTypeDetectorFeature.class)).defaultFileTypeDetector = Objects.requireNonNull(detector);
    }

    public static class AlwaysNullFileTypeDetector
    extends FileTypeDetector {
        @Override
        public String probeContentType(Path path) throws IOException {
            return null;
        }
    }

    public static class Options {
        @Option(help={"Make all supported FileTypeDetector available at run time."})
        public static final HostedOptionKey<Boolean> AddAllFileTypeDetectors = new HostedOptionKey<Boolean>(true);
    }
}

