/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.word.PointerBase;

public interface PlatformNativeLibrarySupport {
    public static final List<String> defaultBuiltInLibraries = Collections.unmodifiableList(Arrays.asList("java", "nio", "net", "zip"));
    public static final String[] builtInPkgNatives = new String[]{"Java_com_sun_demo_jvmti_hprof", "Java_com_sun_java_util_jar_pack", "Java_com_sun_net_ssl", "Java_com_sun_nio_file", "Java_com_sun_security_cert_internal_x509", "Java_java_io", "Java_java_lang", "Java_java_math", "Java_java_net", "Java_java_nio", "Java_java_security", "Java_java_text", "Java_java_time", "Java_java_util", "Java_javax_net", "Java_javax_script", "Java_javax_security", "Java_jdk_internal_org", "Java_jdk_internal_util", "Java_jdk_net", "Java_sun_invoke", "Java_sun_launcher", "Java_sun_misc", "Java_sun_net", "Java_sun_nio", "Java_sun_reflect", "Java_sun_security", "Java_sun_text", "Java_sun_util", "Java_com_oracle_svm_core_jdk"};

    public static PlatformNativeLibrarySupport singleton() {
        return (PlatformNativeLibrarySupport)ImageSingletons.lookup(PlatformNativeLibrarySupport.class);
    }

    public NativeLibrary createLibrary(String var1, boolean var2);

    public PointerBase findBuiltinSymbol(String var1);

    default public boolean isBuiltinLibrary(String name) {
        return defaultBuiltInLibraries.contains(name);
    }

    default public boolean isBuiltinPkgNative(String name) {
        if ((Platform.includedIn(Platform.LINUX_JNI.class) || Platform.includedIn(Platform.DARWIN_JNI.class) || Platform.includedIn(Platform.WINDOWS.class)) && name.startsWith("Java_")) {
            for (String str : builtInPkgNatives) {
                if (!name.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean initializeBuiltinLibraries();

    public static interface NativeLibrary {
        public String getCanonicalIdentifier();

        public boolean isBuiltin();

        public void load() throws UnsatisfiedLinkError;

        public PointerBase findSymbol(String var1);
    }
}

