/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class SystemPropertiesSupport {
    private static final String[] HOSTED_PROPERTIES = new String[]{"java.version", "org.graalvm.nativeimage.kind", "line.separator", "path.separator", "file.separator", "os.arch", "os.name", "file.encoding", "sun.jnu.encoding", "java.class.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version"};
    private final Map<String, Supplier<String>> lazyRuntimeValues;
    private final Properties properties = new Properties();
    private volatile boolean fullyInitialized;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SystemPropertiesSupport() {
        for (String key : HOSTED_PROPERTIES) {
            this.properties.put(key, System.getProperty(key));
        }
        this.properties.put("java.vm.name", "Substrate VM");
        this.properties.put("java.vm.vendor", "Oracle Corporation");
        this.properties.put("java.vm.version", "Substrate VM " + System.getProperty("java.vm.version"));
        this.properties.put("java.vendor", "Oracle Corporation");
        this.properties.put("java.vendor.url", "https://www.graalvm.org/");
        this.properties.put("java.class.path", "");
        this.properties.put("java.endorsed.dirs", "");
        this.properties.put("java.ext.dirs", "");
        this.properties.put("java.library.path", "");
        this.properties.put("org.graalvm.nativeimage.imagecode", "runtime");
        this.lazyRuntimeValues = new HashMap<String, Supplier<String>>();
        this.lazyRuntimeValues.put("user.name", this::userNameValue);
        this.lazyRuntimeValues.put("user.home", this::userHomeValue);
        this.lazyRuntimeValues.put("user.dir", this::userDirValue);
        this.lazyRuntimeValues.put("java.io.tmpdir", this::tmpdirValue);
        this.lazyRuntimeValues.put("os.version", this::osVersionValue);
    }

    public Properties getProperties() {
        if (!this.fullyInitialized) {
            for (String key : this.lazyRuntimeValues.keySet()) {
                this.initializeLazyValue(key);
            }
            this.fullyInitialized = true;
        }
        return this.properties;
    }

    protected String getProperty(String key) {
        this.initializeLazyValue(key);
        return this.properties.getProperty(key);
    }

    public String setProperty(String key, String value) {
        this.initializeLazyValue(key);
        return (String)this.properties.setProperty(key, value);
    }

    public String clearProperty(String key) {
        this.initializeLazyValue(key);
        return (String)this.properties.remove(key);
    }

    private void initializeLazyValue(String key) {
        if (!this.fullyInitialized && this.lazyRuntimeValues.containsKey(key) && this.properties.get(key) == null) {
            this.properties.putIfAbsent(key, this.lazyRuntimeValues.get(key).get());
        }
    }

    protected abstract String userNameValue();

    protected abstract String userHomeValue();

    protected abstract String userDirValue();

    protected abstract String tmpdirValue();

    protected abstract String osVersionValue();
}

