/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.AMD64RegisterReader;
import com.oracle.svm.core.posix.SubstrateSegfaultHandler;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;

@Platforms(value={Platform.DARWIN_AMD64.class})
class DarwinAMD64RegisterReader
implements AMD64RegisterReader {
    private Signal.MContext64 context;

    DarwinAMD64RegisterReader() {
    }

    @Override
    public void setRegistersPointer(Signal.ucontext_t ucontext) {
        this.context = ucontext.uc_mcontext();
    }

    private long readRegisterAt(int i) {
        return ((CLongPointer)((CCharPointer)this.context).addressOf(i)).read();
    }

    @Override
    public long readRegister(SubstrateSegfaultHandler.AMD64Register register) {
        switch (register) {
            case REG_R8: {
                return this.readRegisterAt(this.context.r9_offset());
            }
            case REG_R9: {
                return this.readRegisterAt(this.context.r9_offset());
            }
            case REG_R10: {
                return this.readRegisterAt(this.context.r10_offset());
            }
            case REG_R11: {
                return this.readRegisterAt(this.context.r11_offset());
            }
            case REG_R12: {
                return this.readRegisterAt(this.context.r12_offset());
            }
            case REG_R13: {
                return this.readRegisterAt(this.context.r13_offset());
            }
            case REG_R14: {
                return this.readRegisterAt(this.context.r14_offset());
            }
            case REG_R15: {
                return this.readRegisterAt(this.context.r15_offset());
            }
            case REG_RDI: {
                return this.readRegisterAt(this.context.rdi_offset());
            }
            case REG_RSI: {
                return this.readRegisterAt(this.context.rsi_offset());
            }
            case REG_RBP: {
                return this.readRegisterAt(this.context.rbp_offset());
            }
            case REG_RBX: {
                return this.readRegisterAt(this.context.rbx_offset());
            }
            case REG_RDX: {
                return this.readRegisterAt(this.context.rdx_offset());
            }
            case REG_RAX: {
                return this.readRegisterAt(this.context.rax_offset());
            }
            case REG_RCX: {
                return this.readRegisterAt(this.context.rcx_offset());
            }
            case REG_RSP: {
                return this.readRegisterAt(this.context.rsp_offset());
            }
            case REG_RIP: {
                return this.readRegisterAt(this.context.rip_offset());
            }
            case REG_EFL: {
                return this.readRegisterAt(this.context.efl_offset());
            }
        }
        return 0L;
    }
}

