/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.AMD64RegisterReader;
import com.oracle.svm.core.posix.SubstrateSegfaultHandler;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX_AMD64.class})
class LinuxAMD64RegisterReader
implements AMD64RegisterReader {
    private Signal.GregsPointer gregs;

    LinuxAMD64RegisterReader() {
    }

    @Override
    public void setRegistersPointer(Signal.ucontext_t ucontext) {
        this.gregs = ucontext.uc_mcontext_gregs();
    }

    @Override
    public long readRegister(SubstrateSegfaultHandler.AMD64Register register) {
        switch (register) {
            case REG_R8: {
                return this.readRegister(Signal.GregEnum.REG_R8);
            }
            case REG_R9: {
                return this.readRegister(Signal.GregEnum.REG_R9);
            }
            case REG_R10: {
                return this.readRegister(Signal.GregEnum.REG_R10);
            }
            case REG_R11: {
                return this.readRegister(Signal.GregEnum.REG_R11);
            }
            case REG_R12: {
                return this.readRegister(Signal.GregEnum.REG_R12);
            }
            case REG_R13: {
                return this.readRegister(Signal.GregEnum.REG_R13);
            }
            case REG_R14: {
                return this.readRegister(Signal.GregEnum.REG_R14);
            }
            case REG_R15: {
                return this.readRegister(Signal.GregEnum.REG_R15);
            }
            case REG_RDI: {
                return this.readRegister(Signal.GregEnum.REG_RDI);
            }
            case REG_RSI: {
                return this.readRegister(Signal.GregEnum.REG_RSI);
            }
            case REG_RBP: {
                return this.readRegister(Signal.GregEnum.REG_RBP);
            }
            case REG_RBX: {
                return this.readRegister(Signal.GregEnum.REG_RBX);
            }
            case REG_RDX: {
                return this.readRegister(Signal.GregEnum.REG_RDX);
            }
            case REG_RAX: {
                return this.readRegister(Signal.GregEnum.REG_RAX);
            }
            case REG_RCX: {
                return this.readRegister(Signal.GregEnum.REG_RCX);
            }
            case REG_RSP: {
                return this.readRegister(Signal.GregEnum.REG_RSP);
            }
            case REG_RIP: {
                return this.readRegister(Signal.GregEnum.REG_RIP);
            }
            case REG_EFL: {
                return this.readRegister(Signal.GregEnum.REG_EFL);
            }
        }
        return 0L;
    }

    private long readRegister(Signal.GregEnum regR8) {
        return this.gregs.read(regR8.getCValue());
    }
}

