/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.RuntimeClassInitialization;
import org.graalvm.nativeimage.c.function.CLibrary;

@Platforms(value={Platform.LINUX_JNI.class, Platform.DARWIN_JNI.class})
@AutomaticFeature
@CLibrary(value="java")
class PosixJavaIOSubstituteFeature
implements Feature {
    PosixJavaIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.io.RandomAccessFile")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.ZipFile")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.Inflater")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.Deflater")});
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(String.class);
            JNIRuntimeAccess.register(access.findClassByName("java.lang.String").getDeclaredConstructor(byte[].class, String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.String").getDeclaredMethod("getBytes", String.class));
            JNIRuntimeAccess.register(File.class);
            JNIRuntimeAccess.register(File.class.getDeclaredField("path"));
            JNIRuntimeAccess.register(FileOutputStream.class);
            JNIRuntimeAccess.register(FileOutputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileInputStream.class);
            JNIRuntimeAccess.register(FileInputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class);
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(RandomAccessFile.class);
            JNIRuntimeAccess.register(RandomAccessFile.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(IOException.class);
            JNIRuntimeAccess.register(IOException.class.getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.io.UnixFileSystem"));
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("PosixJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

