/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class PosixLogHandler
implements LogHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(CCharPointer bytes, UnsignedWord length) {
        int savedErrno = Errno.errno();
        try {
            if (!PosixUtils.writeBytes(PosixLogHandler.getOutputFile(), bytes, length)) {
                this.fatalError();
            }
        }
        finally {
            Errno.set_errno(savedErrno);
        }
    }

    public void flush() {
        int savedErrno = Errno.errno();
        try {
            PosixUtils.flush(PosixLogHandler.getOutputFile());
        }
        finally {
            Errno.set_errno(savedErrno);
        }
    }

    public void fatalError() {
        LibC.abort();
    }

    private static FileDescriptor getOutputFile() {
        return FileDescriptor.err;
    }
}

