/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.posix.PosixJavaIOSubstitutions;
import com.oracle.svm.core.posix.PosixJavaLangSubstitutions;
import com.oracle.svm.core.posix.PosixJavaNetSubstitutions;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dlfcn;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class PosixNativeLibrarySupport
implements PlatformNativeLibrarySupport {
    PosixNativeLibrarySupport() {
    }

    static void initialize() {
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)new PosixNativeLibrarySupport());
    }

    @Override
    public boolean initializeBuiltinLibraries() {
        if (Platform.includedIn(Platform.LINUX_JNI.class) || Platform.includedIn(Platform.DARWIN_JNI.class)) {
            if (!PosixJavaIOSubstitutions.initIDs()) {
                return false;
            }
            if (!PosixJavaLangSubstitutions.initIDs()) {
                return false;
            }
            if (!PosixJavaNetSubstitutions.initIDs()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public PosixNativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new PosixNativeLibrary(canonical, builtIn);
    }

    @Override
    public PointerBase findBuiltinSymbol(String name) {
        try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
            Object t = Dlfcn.dlsym(Dlfcn.RTLD_DEFAULT(), symbol.get());
            return t;
        }
    }

    class PosixNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private PointerBase dlhandle = WordFactory.nullPointer();

        PosixNativeLibrary(String canonicalIdentifier, boolean builtin) {
            if (Platform.includedIn(Platform.LINUX_JNI.class) || Platform.includedIn(Platform.DARWIN_JNI.class)) {
                Jvm.initialize();
            }
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
        }

        @Override
        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        @Override
        public boolean isBuiltin() {
            return this.builtin;
        }

        @Override
        public void load() {
            if (!this.builtin) {
                assert (this.dlhandle.isNull());
                String path = this.canonicalIdentifier;
                this.dlhandle = PosixUtils.dlopen(path, Dlfcn.RTLD_LAZY());
                if (this.dlhandle.isNull()) {
                    String error = CTypeConversion.toJavaString((CCharPointer)Dlfcn.dlerror());
                    throw new UnsatisfiedLinkError(path + ": " + error);
                }
            }
        }

        @Override
        public PointerBase findSymbol(String name) {
            if (this.builtin) {
                return PosixNativeLibrarySupport.this.findBuiltinSymbol(name);
            }
            assert (this.dlhandle.isNonNull());
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                Object t = Dlfcn.dlsym(this.dlhandle, symbol.get());
                return t;
            }
        }
    }
}

