/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.AMD64RegisterReader;
import com.oracle.svm.core.posix.DarwinAMD64RegisterReader;
import com.oracle.svm.core.posix.LinuxAMD64RegisterReader;
import com.oracle.svm.core.posix.SubstrateSegfaultHandler;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX_AMD64.class, Platform.DARWIN_AMD64.class})
@AutomaticFeature
public class SegfaultHandlerFeature
implements Feature {
    private static AMD64RegisterReader initializeRegisterReader() {
        if (OS.getCurrent() == OS.LINUX) {
            return new LinuxAMD64RegisterReader();
        }
        if (OS.getCurrent() == OS.DARWIN) {
            return new DarwinAMD64RegisterReader();
        }
        throw VMError.shouldNotReachHere("Unsupported OS.");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ImageSingletons.add(AMD64RegisterReader.class, (Object)SegfaultHandlerFeature.initializeRegisterReader());
        RuntimeSupport.getRuntimeSupport().addStartupHook(SubstrateSegfaultHandler::install);
    }
}

