/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.posix.AMD64RegisterReader;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

class SubstrateSegfaultHandler {
    private static volatile boolean dispatchInProgress = false;
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(SubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    SubstrateSegfaultHandler() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints", calleeMustBe=false)
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (dispatchInProgress) {
            Log.log().newline().string("[ [ SubstrateSegfaultHandler already handling signal ").signed(signalNumber).string(" ] ]").newline();
            return;
        }
        dispatchInProgress = true;
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        AMD64RegisterReader regs = (AMD64RegisterReader)ImageSingletons.lookup(AMD64RegisterReader.class);
        regs.setRegistersPointer(uContext);
        Log log = Log.log();
        log.autoflush(true);
        log.string("[ [ SubstrateSegfaultHandler caught signal ").signed(signalNumber).string(" ] ]").newline();
        log.newline().string("General Purpose Register Set Values: ").newline();
        log.indent(true);
        log.string("RAX ").zhex(regs.readRegister(AMD64Register.REG_RAX)).newline();
        log.string("RBX ").zhex(regs.readRegister(AMD64Register.REG_RBX)).newline();
        log.string("RCX ").zhex(regs.readRegister(AMD64Register.REG_RCX)).newline();
        log.string("RDX ").zhex(regs.readRegister(AMD64Register.REG_RDX)).newline();
        log.string("RBP ").zhex(regs.readRegister(AMD64Register.REG_RBP)).newline();
        log.string("RSI ").zhex(regs.readRegister(AMD64Register.REG_RSI)).newline();
        log.string("RDI ").zhex(regs.readRegister(AMD64Register.REG_RDI)).newline();
        log.string("RSP ").zhex(regs.readRegister(AMD64Register.REG_RSP)).newline();
        log.string("R8  ").zhex(regs.readRegister(AMD64Register.REG_R8)).newline();
        log.string("R9  ").zhex(regs.readRegister(AMD64Register.REG_R9)).newline();
        log.string("R10 ").zhex(regs.readRegister(AMD64Register.REG_R10)).newline();
        log.string("R11 ").zhex(regs.readRegister(AMD64Register.REG_R11)).newline();
        log.string("R12 ").zhex(regs.readRegister(AMD64Register.REG_R12)).newline();
        log.string("R13 ").zhex(regs.readRegister(AMD64Register.REG_R13)).newline();
        log.string("R14 ").zhex(regs.readRegister(AMD64Register.REG_R14)).newline();
        log.string("R15 ").zhex(regs.readRegister(AMD64Register.REG_R15)).newline();
        log.string("EFL ").zhex(regs.readRegister(AMD64Register.REG_EFL)).newline();
        log.string("RIP ").zhex(regs.readRegister(AMD64Register.REG_RIP)).newline();
        log.indent(false);
        SubstrateUtil.printDiagnostics(log, (Pointer)WordFactory.pointer((long)regs.readRegister(AMD64Register.REG_RSP)), (CodePointer)WordFactory.pointer((long)regs.readRegister(AMD64Register.REG_RIP)));
        log.string("Use runtime option -R:-InstallSegfaultHandler if you don't want to use SubstrateSegfaultHandler.").newline();
        log.newline().string("Bye bye ...").newline().newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    static void install() {
        Boolean optionValue = Options.InstallSegfaultHandler.getValue();
        if (optionValue == Boolean.TRUE || optionValue == null && ImageInfo.isExecutable()) {
            int structSigActionSize = SizeOf.get(Signal.sigaction.class);
            Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
            LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
            structSigAction.sa_flags(Signal.SA_SIGINFO());
            structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
            Signal.sigaction(Signal.SignalEnum.SIGSEGV, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
        }
    }

    public static class Options {
        @Option(help={"Install segfault handler that prints register contents and full Java stacktrace. Default: enabled for an executable, disabled for a shared library."})
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null);
    }

    public static enum AMD64Register {
        REG_R8,
        REG_R9,
        REG_R10,
        REG_R11,
        REG_R12,
        REG_R13,
        REG_R14,
        REG_R15,
        REG_RDI,
        REG_RSI,
        REG_RBP,
        REG_RBX,
        REG_RDX,
        REG_RAX,
        REG_RCX,
        REG_RSP,
        REG_RIP,
        REG_EFL;

    }
}

