/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Socket;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class Util_sun_net_sdp_SdpSupport {
    Util_sun_net_sdp_SdpSupport() {
    }

    @Platforms(value={Platform.LINUX.class})
    static int AF_INET_SDP() {
        return 27;
    }

    static int create() throws IOException {
        int s;
        if (IsDefined.__linux__()) {
            if (JavaNetNetUtil.ipv6_available()) {
                throw new IOException("IPv6 not supported");
            }
            s = Socket.socket(Util_sun_net_sdp_SdpSupport.AF_INET_SDP(), Socket.SOCK_STREAM(), 0);
        } else {
            s = -1;
            Errno.set_errno(Errno.EPROTONOSUPPORT());
        }
        if (s < 0) {
            throw PosixUtils.newIOExceptionWithLastError("socket");
        }
        return s;
    }
}

