/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.posix.PosixJavaNetClose;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.SysParam;
import com.oracle.svm.core.posix.headers.SysSelect;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.DARWIN.class})
public final class DarwinJavaNetCloseImpl
extends PosixJavaNetClose {
    protected DarwinJavaNetCloseImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int closefd(int fd1, int fd2) {
        int rv;
        PosixJavaNetClose.FdEntry fdEntry = DarwinJavaNetCloseImpl.getFdEntry(fd2);
        if (fdEntry == null) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        PosixJavaNetClose.FdEntry fdEntry2 = fdEntry;
        synchronized (fdEntry2) {
            fdEntry.getThreadList().forEach(threadEntry -> {
                threadEntry.setIntr(true);
                threadEntry.getThread().interrupt();
            });
            while ((rv = fd1 < 0 ? Unistd.close(fd2) : Unistd.dup2(fd1, fd2)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }
        return rv;
    }

    @Override
    public int NET_Accept(int s, Socket.sockaddr addr, CIntPointer addrlen) {
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(addrlen.read());
        int error = Socket.accept(s, addr, len_Pointer);
        if (error != -1) {
            addrlen.write(len_Pointer.read());
        }
        return this.BLOCKING_IO_RETURN_INT(s, () -> error);
    }

    @Override
    public int NET_Timeout0(int s, long timeoutArg, long currentTime) {
        int rv;
        Time.timeval t;
        long timeout = timeoutArg;
        long prevtime = currentTime;
        Time.timeval tp = t = (Time.timeval)StackValue.get(Time.timeval.class);
        SysSelect.fd_set fds = (SysSelect.fd_set)StackValue.get(SysSelect.fd_set.class);
        SysSelect.fd_set fdsp = (SysSelect.fd_set)WordFactory.nullPointer();
        boolean allocated = false;
        PosixJavaNetClose.ThreadEntry self = new PosixJavaNetClose.ThreadEntry();
        PosixJavaNetClose.FdEntry fdEntry = DarwinJavaNetCloseImpl.getFdEntry(s);
        if (fdEntry == null) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        if (timeout > 0L) {
            t.set_tv_sec(timeout / 1000L);
            t.set_tv_usec(timeout % 1000L * 1000L);
        } else if (timeout < 0L) {
            tp = (Time.timeval)WordFactory.nullPointer();
        } else {
            t.set_tv_sec(0L);
            t.set_tv_usec(0L);
        }
        if (s < SysSelect.FD_SETSIZE()) {
            fdsp = fds;
            SysSelect.FD_ZERO(fdsp);
        } else {
            int length = SysParam.howmany(s + 1, SysSelect.NFDBITS()) * SizeOf.get(CIntPointer.class);
            fdsp = (SysSelect.fd_set)LibC.calloc(WordFactory.unsigned((int)1), WordFactory.unsigned((int)length));
            if (fdsp.isNull()) {
                return -1;
            }
            allocated = true;
        }
        SysSelect.FD_SET(s, fdsp);
        while (true) {
            DarwinJavaNetCloseImpl.startOp(fdEntry, self);
            rv = SysSelect.select(s + 1, fdsp, (SysSelect.fd_set)WordFactory.nullPointer(), (SysSelect.fd_set)WordFactory.nullPointer(), tp);
            DarwinJavaNetCloseImpl.endOp(fdEntry, self);
            if (rv >= 0 || Errno.errno() != Errno.EINTR()) break;
            if (timeout <= 0L) continue;
            Time.timeval now = (Time.timeval)StackValue.get(Time.timeval.class);
            Time.gettimeofday(now, (Time.timezone)WordFactory.nullPointer());
            long newtime = now.tv_sec() * 1000L + now.tv_usec() / 1000L;
            if ((timeout -= newtime - prevtime) <= 0L) {
                if (allocated) {
                    LibC.free(fdsp);
                }
                return 0;
            }
            prevtime = newtime;
            t.set_tv_sec(timeout / 1000L);
            t.set_tv_usec(timeout % 1000L * 1000L);
        }
        if (allocated) {
            LibC.free(fdsp);
        }
        return rv;
    }
}

