/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.posix.PosixJavaNetClose;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class})
public class LinuxJavaNetCloseImpl
extends PosixJavaNetClose {
    protected LinuxJavaNetCloseImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int closefd(int fd1, int fd2) {
        int rv;
        PosixJavaNetClose.FdEntry fdEntry = LinuxJavaNetCloseImpl.getFdEntry(fd2);
        if (fdEntry == null) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        PosixJavaNetClose.FdEntry fdEntry2 = fdEntry;
        synchronized (fdEntry2) {
            while ((rv = fd1 < 0 ? Unistd.close(fd2) : Unistd.dup2(fd1, fd2)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            fdEntry.getThreadList().forEach(threadEntry -> {
                threadEntry.setIntr(true);
                threadEntry.getThread().interrupt();
            });
        }
        return rv;
    }

    @Override
    public int NET_Accept(int s, Socket.sockaddr addr, CIntPointer addrlen) {
        CIntPointer socklen = (CIntPointer)StackValue.get(CIntPointer.class);
        socklen.write(addrlen.read());
        int result = this.BLOCKING_IO_RETURN_INT(s, () -> Socket.accept(s, addr, socklen));
        addrlen.write(socklen.read());
        return result;
    }

    @Override
    public int NET_Timeout0(int s, long timeoutArg, long currentTime) {
        int rv;
        long timeout = timeoutArg;
        long prevtime = currentTime;
        Time.timeval t = (Time.timeval)StackValue.get(Time.timeval.class);
        PosixJavaNetClose.FdEntry fdEntry = LinuxJavaNetCloseImpl.getFdEntry(s);
        if (fdEntry == null) {
            Errno.set_errno(Errno.EBADF());
            return -1;
        }
        while (true) {
            Poll.pollfd pfd = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
            PosixJavaNetClose.ThreadEntry self = new PosixJavaNetClose.ThreadEntry();
            pfd.set_fd(s);
            pfd.set_events(Poll.POLLIN() | Poll.POLLERR());
            LinuxJavaNetCloseImpl.startOp(fdEntry, self);
            rv = Poll.poll(pfd, 1, (int)timeout);
            LinuxJavaNetCloseImpl.endOp(fdEntry, self);
            if (rv >= 0 || Errno.errno() != Errno.EINTR()) break;
            if (timeout <= 0L) continue;
            Time.gettimeofday(t, (Time.timezone)WordFactory.nullPointer());
            long newtime = t.tv_sec() * 1000L + t.tv_usec() / 1000L;
            if ((timeout -= newtime - prevtime) <= 0L) {
                return 0;
            }
            prevtime = newtime;
        }
        return rv;
    }
}

