/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.FeebleReferenceList;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.StackTraceBuilder;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_ThreadGroup;
import com.oracle.svm.core.thread.ThreadListOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreadCounterOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;

public abstract class JavaThreads {
    protected static final FastThreadLocalObject<Thread> currentThread = FastThreadLocalFactory.createObject(Thread.class);
    protected final AtomicLong totalThreads = new AtomicLong();
    protected final AtomicInteger peakThreads = new AtomicInteger();
    protected final AtomicInteger liveThreads = new AtomicInteger();
    protected final AtomicInteger daemonThreads = new AtomicInteger();
    protected final AtomicInteger nonDaemonThreads = new AtomicInteger();
    final ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
    final Thread singleThread = new Thread("SVM");
    final AtomicLong threadSeqNumber = new AtomicLong();
    final AtomicInteger threadInitNumber = new AtomicInteger();

    @Fold
    public static JavaThreads singleton() {
        return (JavaThreads)ImageSingletons.lookup(JavaThreads.class);
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Thread fromTarget(Target_java_lang_Thread thread) {
        return (Thread)Thread.class.cast(thread);
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    private static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    public static int getThreadStatus(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).threadStatus;
    }

    public static void setThreadStatus(Thread thread, int threadStatus) {
        JavaThreads.toTarget((Thread)thread).threadStatus = threadStatus;
    }

    protected static UninterruptibleUtils.AtomicReference<ParkEvent> getUnsafeParkEvent(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).unsafeParkEvent;
    }

    protected static UninterruptibleUtils.AtomicReference<ParkEvent> getSleepParkEvent(Thread thread) {
        return JavaThreads.toTarget((Thread)thread).sleepParkEvent;
    }

    public Thread fromVMThread(IsolateThread vmThread) {
        return currentThread.get(vmThread);
    }

    @Uninterruptible(reason="Called from uninterruptible codet st.", calleeMustBe=false)
    public static Thread getCurrentThread() {
        return currentThread.get();
    }

    public Thread createIfNotExisting(IsolateThread vmThread) {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return this.singleThread;
        }
        Thread result = currentThread.get(vmThread);
        if (result == null) {
            result = JavaThreads.createThread(vmThread);
        }
        return result;
    }

    public long getTotalThreads() {
        return this.totalThreads.get();
    }

    public int getPeakThreads() {
        return this.peakThreads.get();
    }

    public int getLiveThreads() {
        return this.liveThreads.get();
    }

    public int getDaemonThreads() {
        return this.daemonThreads.get();
    }

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    static Target_java_lang_ThreadGroup toTarget(ThreadGroup threadGroup) {
        return (Target_java_lang_ThreadGroup)Target_java_lang_ThreadGroup.class.cast(threadGroup);
    }

    public void joinAllNonDaemons() {
        int expected = 0;
        if (currentThread.get() != null && !currentThread.get().isDaemon()) {
            expected = 1;
        }
        try (VMMutex ignored = VMThreads.THREAD_MUTEX.lock();){
            while (this.nonDaemonThreads.get() > expected) {
                VMThreads.THREAD_LIST_CONDITION.block();
            }
        }
    }

    @NeverInline(value="Truffle compilation must not inline this method")
    private static Thread createThread(IsolateThread isolateThread) {
        boolean isDaemon = true;
        Thread thread = JavaThreads.fromTarget(new Target_java_lang_Thread(null, null, isDaemon));
        if (!JavaThreads.assignJavaThread(isolateThread, thread, true)) {
            return currentThread.get(isolateThread);
        }
        return thread;
    }

    public void signalNonDaemonThreadStart() {
        this.nonDaemonThreads.incrementAndGet();
    }

    public boolean assignJavaThread(String name, ThreadGroup group2, boolean asDaemon) {
        Thread thread = JavaThreads.fromTarget(new Target_java_lang_Thread(name, group2, asDaemon));
        return JavaThreads.assignJavaThread(CurrentIsolate.getCurrentThread(), thread, true);
    }

    public boolean assignJavaThread(Thread thread, boolean manuallyStarted) {
        return JavaThreads.assignJavaThread(CurrentIsolate.getCurrentThread(), thread, manuallyStarted);
    }

    private static boolean assignJavaThread(IsolateThread isolateThread, Thread thread, boolean manuallyStarted) {
        if (!currentThread.compareAndSet(isolateThread, null, thread)) {
            return false;
        }
        if (manuallyStarted) {
            JavaThreads.setThreadStatus(thread, 5);
            ThreadGroup group2 = thread.getThreadGroup();
            JavaThreads.toTarget(group2).addUnstarted();
            JavaThreads.toTarget(group2).add(thread);
        }
        if (!thread.isDaemon() && manuallyStarted) {
            assert (isolateThread.equal((ComparableWord)CurrentIsolate.getCurrentThread())) : "Non-daemon threads must call this method themselves, or they can detach incompletely in a race";
            JavaThreads.singleton().nonDaemonThreads.incrementAndGet();
        }
        return true;
    }

    public boolean tearDownVM() {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        return JavaThreads.tearDownIsolateThreads();
    }

    private static void detachParkEvent(UninterruptibleUtils.AtomicReference<ParkEvent> ref) {
        ParkEvent event = ref.get();
        if (event != null) {
            ref.set(null);
            ParkEvent.release(event);
        }
    }

    public static void detachThread(IsolateThread vmThread) {
        VMThreads.THREAD_MUTEX.assertIsLocked("Should hold the VMThreads mutex.");
        Heap.getHeap().disableAllocation(vmThread);
        Thread thread = currentThread.get(vmThread);
        if (thread == null) {
            return;
        }
        JavaThreads.detachParkEvent(JavaThreads.getUnsafeParkEvent(thread));
        JavaThreads.detachParkEvent(JavaThreads.getSleepParkEvent(thread));
        if (!thread.isDaemon()) {
            JavaThreads.singleton().nonDaemonThreads.decrementAndGet();
        }
    }

    private static boolean tearDownIsolateThreads() {
        Log trace = Log.noopLog().string("[JavaThreads.tearDownIsolateThreads:").newline().flush();
        VMThreads.setTearingDown();
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        ThreadListOperation operation = new ThreadListOperation(threadList);
        operation.enqueue();
        for (Thread thread : threadList) {
            if (thread == Thread.currentThread() || thread == null) continue;
            trace.string("  interrupting: ").string(thread.getName()).newline().flush();
            thread.interrupt();
        }
        boolean result = JavaThreads.waitForTearDown();
        trace.string("  returns: ").bool(result).string("]").newline().flush();
        return result;
    }

    private static boolean waitForTearDown() {
        long startNanos;
        Log trace = Log.noopLog().string("[JavaThreads.waitForTearDown:").newline();
        long warningNanos = SubstrateOptions.getTearDownWarningNanos();
        String warningMessage = "JavaThreads.waitForTearDown is taking too long.";
        long failureNanos = SubstrateOptions.getTearDownFailureNanos();
        String failureMessage = "JavaThreads.waitForTearDown took too long.";
        long loopNanos = startNanos = System.nanoTime();
        AtomicBoolean printLaggards = new AtomicBoolean(false);
        Log counterLog = warningNanos == 0L ? trace : Log.log();
        VMThreadCounterOperation operation = new VMThreadCounterOperation(counterLog, printLaggards);
        while (true) {
            long previousLoopNanos = loopNanos;
            operation.enqueue();
            if (operation.getCount() == 1) {
                trace.string("  returns true]").newline();
                return true;
            }
            loopNanos = TimeUtils.doNotLoopTooLong(startNanos, loopNanos, warningNanos, "JavaThreads.waitForTearDown is taking too long.");
            boolean fatallyTooLong = TimeUtils.maybeFatallyTooLong(startNanos, failureNanos, "JavaThreads.waitForTearDown took too long.");
            if (fatallyTooLong) {
                trace.string("Took too long to tear down the VM.").newline();
                return false;
            }
            printLaggards.set(previousLoopNanos != loopNanos);
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN"}, justification="notifyAll is necessary for Java semantics, no shared state needs to be modified beforehand")
    protected static void exit(Thread thread) {
        JavaThreads.toTarget(thread).exit();
        JavaThreads.setThreadStatus(thread, 2);
        Thread thread2 = thread;
        synchronized (thread2) {
            thread.notifyAll();
        }
    }

    protected static void prepareStartData(Thread thread, ThreadStartData startData) {
        startData.setIsolate(CurrentIsolate.getIsolate());
        startData.setThreadHandle(ObjectHandles.getGlobal().create((Object)thread));
        if (!thread.isDaemon()) {
            JavaThreads.singleton().signalNonDaemonThreadStart();
        }
    }

    protected abstract void doStartThread(Thread var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"Ru"}, justification="We really want to call Thread.run and not Thread.start because we are in the low-level thread start routine")
    protected static void threadStartRoutine(ObjectHandle threadHandle) {
        Thread thread = (Thread)ObjectHandles.getGlobal().get(threadHandle);
        boolean status = JavaThreads.singleton().assignJavaThread(thread, false);
        VMError.guarantee(status, "currentThread already initialized");
        ObjectHandles.getGlobal().destroy(threadHandle);
        JavaThreads.singleton().noteThreadStart(thread);
        try {
            thread.run();
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(thread, ex);
        }
        finally {
            JavaThreads.exit(thread);
            JavaThreads.singleton().noteThreadFinish(thread);
        }
    }

    protected void noteThreadStart(Thread thread) {
        this.totalThreads.incrementAndGet();
        int lThreads = this.liveThreads.incrementAndGet();
        this.peakThreads.set(Integer.max(this.peakThreads.get(), lThreads));
        if (thread.isDaemon()) {
            this.daemonThreads.incrementAndGet();
        } else {
            this.nonDaemonThreads.incrementAndGet();
        }
    }

    protected void noteThreadFinish(Thread thread) {
        this.liveThreads.decrementAndGet();
        if (thread.isDaemon()) {
            this.daemonThreads.decrementAndGet();
        } else {
            this.nonDaemonThreads.decrementAndGet();
        }
    }

    protected abstract void setNativeName(Thread var1, String var2);

    protected abstract void yield();

    protected static void interruptVMCondVars() {
        VMOperation.enqueueBlockingNoSafepoint("Util_java_lang_Thread.notifyVMMutexConditionsOnThreadInterrupt()", JavaThreads::interruptUnderVMMutex);
    }

    private static void interruptUnderVMMutex() {
        VMThreads.THREAD_MUTEX.guaranteeIsLocked("Should hold VMThreads lock when interrupting.");
        FeebleReferenceList.signalWaiters();
    }

    static StackTraceElement[] getStackTrace(Thread thread) {
        StackTraceElement[][] result = new StackTraceElement[1][0];
        VMOperation.enqueueBlockingSafepoint("getStackTrace", () -> {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                if (JavaThreads.singleton().fromVMThread(cur) == thread) {
                    result[0] = JavaThreads.getStackTrace(cur);
                    break;
                }
                cur = VMThreads.nextThread(cur);
            }
        });
        return result[0];
    }

    static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        HashMap<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>();
        VMOperation.enqueueBlockingSafepoint("getAllStackTraces", () -> {
            IsolateThread cur = VMThreads.firstThread();
            while (cur.isNonNull()) {
                result.put(JavaThreads.singleton().createIfNotExisting(cur), JavaThreads.getStackTrace(cur));
                cur = VMThreads.nextThread(cur);
            }
        });
        return result;
    }

    private static StackTraceElement[] getStackTrace(IsolateThread thread) {
        if (thread == CurrentIsolate.getCurrentThread()) {
            StackTraceBuilder stackTraceBuilder = new StackTraceBuilder(false);
            JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress(), stackTraceBuilder);
            return stackTraceBuilder.getTrace();
        }
        StackTraceBuilder stackTraceBuilder = new StackTraceBuilder(false);
        JavaStackWalker.walkThread(thread, stackTraceBuilder);
        return stackTraceBuilder.getTrace();
    }

    public static void dispatchUncaughtException(Thread thread, Throwable throwable) {
        Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
        if (handler == null) {
            handler = Thread.getDefaultUncaughtExceptionHandler();
        }
        if (handler != null) {
            try {
                handler.uncaughtException(thread, throwable);
            }
            catch (Throwable throwable2) {}
        } else {
            System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
            throwable.printStackTrace();
        }
    }

    @AutomaticFeature
    private static class SequenceInitializingFeature
    implements Feature {
        private final CopyOnWriteArraySet<Thread> collectedThreads = new CopyOnWriteArraySet();
        private final MethodHandle threadSeqNumberMH = SequenceInitializingFeature.createFieldMH(Thread.class, "threadSeqNumber");
        private final MethodHandle threadInitNumberMH = SequenceInitializingFeature.createFieldMH(Thread.class, "threadInitNumber");

        private SequenceInitializingFeature() {
        }

        public void duringSetup(Feature.DuringSetupAccess access) {
            access.registerObjectReplacer(this::collectThreads);
        }

        private Object collectThreads(Object original) {
            if (original instanceof Thread) {
                this.collectedThreads.add((Thread)original);
            }
            return original;
        }

        public void beforeCompilation(Feature.BeforeCompilationAccess access) {
            if (!this.collectedThreads.isEmpty()) {
                try {
                    JavaThreads.singleton().threadSeqNumber.set(this.threadSeqNumberMH.invokeExact());
                    JavaThreads.singleton().threadInitNumber.set(this.threadInitNumberMH.invokeExact());
                }
                catch (Throwable t) {
                    throw VMError.shouldNotReachHere(t);
                }
            }
        }

        private static MethodHandle createFieldMH(Class<?> declaringClass, String fieldName) {
            try {
                Field field = declaringClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return MethodHandles.lookup().unreflectGetter(field);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere(t);
            }
        }
    }

    @RawStructure
    protected static interface ThreadStartData
    extends PointerBase {
        @RawField
        public ObjectHandle getThreadHandle();

        @RawField
        public void setThreadHandle(ObjectHandle var1);

        @RawField
        public Isolate getIsolate();

        @RawField
        public void setIsolate(Isolate var1);
    }
}

