/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.amd64.AMD64CPUFeatureAccess;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.meta.InstalledCodeBuilder;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.meta.SubstrateInstalledCodeImpl;
import com.oracle.svm.graal.meta.SubstrateMethod;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.InstalledCode;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class SubstrateGraalUtils {
    private static final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);
    private static boolean architectureInitialized;

    public static InstalledCode compileAndInstall(OptionValues options, SubstrateMethod method) {
        return SubstrateGraalUtils.compileAndInstall(options, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method);
    }

    public static InstalledCode compileAndInstall(OptionValues options, RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SubstrateMethod method) {
        return SubstrateGraalUtils.compileAndInstall(options, runtimeConfig, suites, lirSuites, method, false);
    }

    public static InstalledCode compileAndInstall(OptionValues options, SubstrateMethod method, boolean testTrampolineJumps) {
        return SubstrateGraalUtils.compileAndInstall(options, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method, testTrampolineJumps);
    }

    public static InstalledCode compileAndInstall(OptionValues options, RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SubstrateMethod method, boolean testTrampolineJumps) {
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(runtimeConfig.lookupBackend(method));
        DebugContext debug = DebugContext.create((OptionValues)options, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalSupport.getRuntimeConfig().getSnippetReflection()));
        SubstrateInstalledCodeImpl installedCode = new SubstrateInstalledCodeImpl(method);
        SubstrateGraalUtils.doCompileAndInstall(debug, runtimeConfig, suites, lirSuites, method, installedCode, testTrampolineJumps);
        return installedCode;
    }

    private static void doCompileAndInstall(DebugContext debug, RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SubstrateMethod method, SubstrateInstalledCodeImpl installedCode, boolean testTrampolineJumps) {
        CompilationResult compilationResult = SubstrateGraalUtils.doCompile(debug, runtimeConfig, suites, lirSuites, method);
        SubstrateGraalUtils.installMethod(method, compilationResult, installedCode, testTrampolineJumps);
    }

    private static void installMethod(SubstrateMethod method, CompilationResult result, SubstrateInstalledCodeImpl installedCode, boolean testTrampolineJumps) {
        InstalledCodeBuilder installedCodeBuilder = new InstalledCodeBuilder(method, result, installedCode, null, testTrampolineJumps);
        installedCodeBuilder.install();
        Log.log().string("Installed code for " + method.format("%H.%n(%p)") + ": " + result.getTargetCodeSize() + " bytes").newline();
    }

    public static CompilationResult compile(DebugContext debug, SubstrateMethod method) {
        return SubstrateGraalUtils.compile(debug, GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method);
    }

    public static CompilationResult compile(DebugContext debug, RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SubstrateMethod method) {
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(runtimeConfig.lookupBackend(method));
        return SubstrateGraalUtils.doCompile(debug, runtimeConfig, suites, lirSuites, method);
    }

    private static CompilationResult doCompile(DebugContext initialDebug, final RuntimeConfiguration runtimeConfig, final Suites suites, final LIRSuites lirSuites, final SubstrateMethod method) {
        final String methodString = method.format("%H.%n(%p)");
        final SubstrateCompilationIdentifier compilationId = new SubstrateCompilationIdentifier();
        return (CompilationResult)new CompilationWrapper<CompilationResult>(GraalSupport.get().getDebugOutputDirectory(), compilationProblemsPerAction){

            <E extends Throwable> RuntimeException silenceThrowable(Class<E> type, Throwable ex) throws E {
                throw ex;
            }

            protected CompilationResult handleException(Throwable t) {
                throw this.silenceThrowable(RuntimeException.class, t);
            }

            protected CompilationResult performCompilation(DebugContext debug) {
                StructuredGraph graph = GraalSupport.decodeGraph(debug, null, compilationId, method);
                return SubstrateGraalUtils.compileGraph(runtimeConfig, suites, lirSuites, method, graph);
            }

            public String toString() {
                return methodString;
            }

            protected DebugContext createRetryDebugContext(OptionValues options, PrintStream logStream) {
                return GraalSupport.get().openDebugContext(options, compilationId, method, logStream);
            }
        }.run(initialDebug);
    }

    public static void updateGraalArchitectureWithHostCPUFeatures(Backend graalBackend) {
        if (SubstrateUtil.HOSTED) {
            throw VMError.shouldNotReachHere("Architecture should be updated only at runtime.");
        }
        if (!architectureInitialized) {
            architectureInitialized = true;
            AMD64CPUFeatureAccess.verifyHostSupportsArchitecture(graalBackend.getCodeCache().getTarget().arch);
            AMD64 architecture = (AMD64)graalBackend.getCodeCache().getTarget().arch;
            EnumSet<AMD64.CPUFeature> features = AMD64CPUFeatureAccess.determineHostCPUFeatures();
            architecture.getFeatures().addAll(features);
        }
    }

    public static CompilationResult compileGraph(SharedMethod method, StructuredGraph graph) {
        return SubstrateGraalUtils.compileGraph(GraalSupport.getRuntimeConfig(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), method, graph);
    }

    /*
     * Exception decompiling
     */
    private static CompilationResult compileGraph(RuntimeConfiguration runtimeConfig, Suites suites, LIRSuites lirSuites, SharedMethod method, StructuredGraph graph) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class Options {
        @Option(help={"Force-dump graphs before compilation"})
        public static final RuntimeOptionKey<Boolean> ForceDumpGraphsBeforeCompilation = new RuntimeOptionKey<Boolean>(false);
    }
}

