/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ClassInitializationFeature;
import com.oracle.svm.hosted.ClassInitializationSupport;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public class ClassInitializationSupportImpl
implements ClassInitializationSupport {
    private final Map<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private UnsupportedFeatures unsupportedFeatures;
    private MetaAccessProvider metaAccess;

    public ClassInitializationSupportImpl(MetaAccessProvider metaAccess) {
        this.metaAccess = metaAccess;
    }

    void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    @Override
    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(ClassInitializationSupportImpl.toAnalysisType(type).getJavaClass()) != InitKind.EAGER;
    }

    @Override
    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != InitKind.EAGER;
    }

    @Override
    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ClassInitializationSupportImpl.toAnalysisType(type).getJavaClass());
    }

    @Override
    public void forceInitializeHosted(ResolvedJavaType type) {
        this.forceInitializeHosted(ClassInitializationSupportImpl.toAnalysisType(type).getJavaClass());
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz) {
        InitKind initKind = this.computeInitKindAndMaybeInitializeClass(clazz);
        if (initKind == InitKind.DELAY) {
            throw UserError.abort("Cannot delay running the class initializer because class must be initialized for internal purposes: " + clazz.getTypeName());
        }
    }

    private static AnalysisType toAnalysisType(ResolvedJavaType type) {
        return type instanceof HostedType ? ((HostedType)type).getWrapped() : (AnalysisType)type;
    }

    @Override
    public void checkDelayedInitialization() {
        for (Map.Entry<Class<?>, InitKind> entry : this.classInitKinds.entrySet()) {
            if (entry.getValue() != InitKind.DELAY || UnsafeAccess.UNSAFE.shouldBeInitialized(entry.getKey())) continue;
            throw UserError.abort("Class that is marked for delaying initialization to run time got initialized during image building: " + entry.getKey().getTypeName());
        }
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoizeEager) {
        InitKind result = this.classInitKinds.get(clazz);
        if (result != null) {
            return result;
        }
        result = InitKind.EAGER;
        if (clazz.getSuperclass() != null) {
            result = result.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoizeEager));
        }
        if ((result = result.max(this.processInterfaces(clazz, memoizeEager))) != InitKind.EAGER || memoizeEager) {
            if (result != InitKind.DELAY) {
                result = result.max(this.ensureClassInitialized(clazz));
            }
            InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value";
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = InitKind.EAGER;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface)) ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    private InitKind ensureClassInitialized(Class<?> clazz) {
        try {
            UnsafeAccess.UNSAFE.ensureClassInitialized(clazz);
            return InitKind.EAGER;
        }
        catch (Throwable ex) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time because either option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + " or option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " is used for image building. Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.DelayClassInitialization, clazz.getTypeName()) + " to explicitly request delayed initialization of this class.");
            } else {
                String msg = "Class initialization failed: " + clazz.getTypeName();
                if (this.unsupportedFeatures != null) {
                    this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, ex);
                } else {
                    throw UserError.abort(msg, ex);
                }
            }
            return InitKind.DELAY;
        }
    }

    public void delayClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            ClassInitializationSupportImpl.checkEagerInitialization(clazz);
            if (!UnsafeAccess.UNSAFE.shouldBeInitialized(clazz)) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            InitKind previousKind = this.classInitKinds.put(clazz, InitKind.DELAY);
            if (previousKind == InitKind.EAGER) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            if (previousKind != InitKind.RERUN) continue;
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: " + clazz.getTypeName());
        }
    }

    public void rerunClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            ClassInitializationSupportImpl.checkEagerInitialization(clazz);
            try {
                UnsafeAccess.UNSAFE.ensureClassInitialized(clazz);
            }
            catch (Throwable ex) {
                throw UserError.abort("Class initialization failed: " + clazz.getTypeName(), ex);
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RERUN);
            if (previousKind == InitKind.EAGER) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
            }
            if (previousKind != InitKind.DELAY) continue;
            throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
        }
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized eagerly because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization: " + clazz.getTypeName());
        }
    }

    static enum InitKind {
        EAGER,
        RERUN,
        DELAY;


        InitKind max(InitKind other) {
            return this.ordinal() > other.ordinal() ? this : other;
        }
    }
}

