/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.InfoTreeBuilder;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public class CSourceCodeWriter {
    private static final String INDENT4 = "    ";
    public static final String C_SOURCE_FILE_EXTENSION = ".c";
    public static final String CXX_SOURCE_FILE_EXTENSION = ".cpp";
    private final List<String> lines;
    private final StringBuilder currentLine;
    private int indentLevel = 0;
    protected final Path tempDirectory;

    public CSourceCodeWriter(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        this.lines = new ArrayList<String>();
        this.currentLine = new StringBuilder(100);
    }

    public int currentLineNumber() {
        return this.lines.size() + 1;
    }

    public String getLine(int lineNumber) {
        int index = lineNumber - 1;
        if (index >= 0 && index < this.lines.size()) {
            return this.lines.get(index);
        }
        return "";
    }

    public void includeFiles(List<String> headerFiles) {
        for (String headerFile : headerFiles) {
            Path headerFilePath;
            String headerFileName = null;
            if (headerFile.startsWith("<") && headerFile.endsWith(">")) {
                headerFileName = headerFile.substring(1, headerFile.length() - 1);
                headerFilePath = Paths.get(headerFileName, new String[0]);
                this.appendln("#include <" + headerFilePath.toString() + ">");
                continue;
            }
            if (headerFile.startsWith("\"") && headerFile.endsWith("\"")) {
                headerFileName = headerFile.substring(1, headerFile.length() - 1);
                headerFilePath = Paths.get(headerFileName, new String[0]);
                this.appendln("#include \"" + headerFilePath.toString() + "\"");
                continue;
            }
            throw UserError.abort("header file name must be surrounded by <...> or \"...\": " + headerFile);
        }
    }

    public CSourceCodeWriter printf(String firstArg, String secondArg) {
        this.append("printf(\"" + firstArg + "\\n\", " + secondArg + ")");
        return this;
    }

    public CSourceCodeWriter printf(String firstArg, String secondArg, String thirdArg) {
        this.append("printf(\"" + firstArg + "\\n\", " + secondArg + ", " + thirdArg + ")");
        return this;
    }

    public CSourceCodeWriter indents() {
        assert (this.currentLine.length() == 0) : "indenting in the middle of a line";
        for (int i = 0; i < this.indentLevel; ++i) {
            this.append(INDENT4);
        }
        return this;
    }

    public void indent() {
        ++this.indentLevel;
    }

    public void outdent() {
        --this.indentLevel;
    }

    public void semicolon() {
        this.appendln(";");
    }

    public void appendln(String str) {
        this.append(str);
        this.appendln();
    }

    public void appendln() {
        assert (this.currentLine.indexOf("\n") == -1) : "line must not contain newline character";
        this.lines.add(this.currentLine.toString());
        this.currentLine.delete(0, this.currentLine.length());
    }

    public CSourceCodeWriter append(String str) {
        assert (!str.contains("\n")) : "line must not contain newline character";
        this.currentLine.append(str);
        return this;
    }

    public Path writeFile(String fileName) {
        return this.writeFile(fileName, true);
    }

    public Path writeFile(String fileName, boolean ensureCorrectExtension) {
        String srcFileExtension;
        assert (this.currentLine.length() == 0) : "last line not finished";
        String fixedFileName = fileName;
        String string = srcFileExtension = Platform.includedIn(Platform.WINDOWS.class) ? CXX_SOURCE_FILE_EXTENSION : C_SOURCE_FILE_EXTENSION;
        if (!fileName.endsWith(srcFileExtension) && ensureCorrectExtension) {
            fixedFileName = fileName.concat(srcFileExtension);
        }
        Path outputFile = this.tempDirectory.resolve(fixedFileName);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, Charset.forName("UTF-8"), new OpenOption[0]);){
            for (String line : this.lines) {
                writer.write(line);
                writer.write("\n");
            }
        }
        catch (ClosedByInterruptException ex) {
            throw new InterruptImageBuilding();
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        return outputFile;
    }

    public static String toCTypeName(ResolvedJavaMethod method, ResolvedJavaType type, boolean isConst, boolean isUnsigned, MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
        if (type.getJavaKind().isNumericInteger()) {
            return CSourceCodeWriter.toCIntegerType(type, isUnsigned);
        }
        UserError.guarantee(!isUnsigned, "Only integer types can be unsigned. " + type.getJavaKind().getJavaName() + " is not an integer type in " + method.format("%H.%n(%p)"), new Object[0]);
        if (type.getJavaKind() == JavaKind.Object) {
            return CSourceCodeWriter.cTypeForObject(type, isConst, metaAccess, nativeLibs);
        }
        UserError.guarantee(!isConst, "Only pointer types can be const. " + type.getJavaKind().getJavaName() + " in method " + method.format("%H.%n(%p)") + " is not an pointer type.", new Object[0]);
        switch (type.getJavaKind()) {
            case Double: {
                return "double";
            }
            case Float: {
                return "float";
            }
            case Void: {
                return "void";
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static String cTypeForObject(ResolvedJavaType type, boolean isConst, MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
        String prefix = isConst ? "const " : "";
        ElementInfo elementInfo = nativeLibs.findElementInfo((AnnotatedElement)type);
        if (elementInfo instanceof PointerToInfo) {
            PointerToInfo pointerToInfo = (PointerToInfo)elementInfo;
            return pointerToInfo.getTypedefName() != null ? pointerToInfo.getTypedefName() : prefix + pointerToInfo.getName() + "*";
        }
        if (elementInfo instanceof StructInfo) {
            StructInfo structInfo = (StructInfo)elementInfo;
            return structInfo.getTypedefName() != null ? structInfo.getTypedefName() : prefix + structInfo.getName() + "*";
        }
        if (elementInfo instanceof EnumInfo) {
            return elementInfo.getName();
        }
        if (metaAccess.lookupJavaType(UnsignedWord.class).isAssignableFrom(type)) {
            return "size_t";
        }
        if (metaAccess.lookupJavaType(SignedWord.class).isAssignableFrom(type)) {
            return "ssize_t";
        }
        if (CSourceCodeWriter.isFunctionPointer(metaAccess, type)) {
            return InfoTreeBuilder.getTypedefName(type) != null ? InfoTreeBuilder.getTypedefName(type) : prefix + "void *";
        }
        return prefix + "void *";
    }

    private static String toCIntegerType(ResolvedJavaType type, boolean isUnsigned) {
        boolean c11Compatible = NativeImageOptions.getCStandard().compatibleWith(NativeImageOptions.CStandards.C11);
        String prefix = "";
        if (isUnsigned) {
            prefix = c11Compatible ? "u" : "unsigned ";
        }
        switch (type.getJavaKind()) {
            case Boolean: {
                if (NativeImageOptions.getCStandard().compatibleWith(NativeImageOptions.CStandards.C99)) {
                    return "bool";
                }
                return "int";
            }
            case Byte: {
                return prefix + (c11Compatible ? "int8_t" : "char");
            }
            case Char: {
                return prefix + (c11Compatible ? "int16_t" : "short");
            }
            case Short: {
                return prefix + (c11Compatible ? "int16_t" : "short");
            }
            case Int: {
                return prefix + (c11Compatible ? "int32_t" : "int");
            }
            case Long: {
                return prefix + (c11Compatible ? "int64_t" : "long long int");
            }
        }
        throw VMError.shouldNotReachHere("All types integer types should be covered. Got " + type.getJavaKind());
    }

    private static boolean isFunctionPointer(MetaAccessProvider metaAccess, ResolvedJavaType type) {
        boolean functionPointer = metaAccess.lookupJavaType(CFunctionPointer.class).isAssignableFrom(type);
        return functionPointer && Arrays.stream(type.getDeclaredMethods()).anyMatch(v -> v.getDeclaredAnnotation(InvokeCFunctionPointer.class) != null);
    }

    public void appendMacroDefinition(String preDefine) {
        this.appendln("#define " + preDefine);
    }
}

