/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.code.CCallStubMethod;
import java.util.Set;
import java.util.TreeSet;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
public class CFunctionFeature
implements GraalFeature {
    private Set<String> warnCFunctionsWithTransition;

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (this.warnCFunctionsWithTransition != null) {
            System.out.println("WARNING: @CFunction not marked as NO_TRANSITION reachable during runtime compilation. Calls cannot be inlined.");
            for (String s : this.warnCFunctionsWithTransition) {
                System.out.println("    " + s);
            }
        }
    }

    void warnRuntimeCompilationReachableCFunctionWithTransition(CCallStubMethod method) {
        if (Options.WarnCFunctionsWithTransition.getValue().booleanValue()) {
            if (this.warnCFunctionsWithTransition == null) {
                this.warnCFunctionsWithTransition = new TreeSet<String>();
            }
            this.warnCFunctionsWithTransition.add(method.format("%H.%n(%p)"));
        }
    }

    public static class Options {
        @Option(help={"Print warning message when @CFunction that needs transition is called from runtime compiled code"})
        public static final HostedOptionKey<Boolean> WarnCFunctionsWithTransition = new HostedOptionKey<Boolean>(false);
    }
}

