/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.json.JSONParserException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;

public abstract class ConfigurationParser {
    protected final ImageClassLoader classLoader;

    ConfigurationParser(ImageClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void parseAndRegisterConfigurations(String featureName, HostedOptionKey<String[]> configFilesOption, HostedOptionKey<String[]> configResourcesOption) {
        Throwable throwable;
        InputStreamReader reader;
        for (String path : OptionUtils.flatten(",", configFilesOption.getValue())) {
            File file = new File(path).getAbsoluteFile();
            if (!file.exists()) {
                throw UserError.abort("The " + featureName + " configuration file \"" + file + "\" does not exist.");
            }
            try {
                reader = new FileReader(file);
                throwable = null;
                try {
                    this.parseAndRegister(reader, featureName, file, configFilesOption);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                throw UserError.abort("Could not open " + file + ": " + e.getMessage());
            }
        }
        for (String resource : OptionUtils.flatten(",", configResourcesOption.getValue())) {
            URL url = this.classLoader.findResourceByName(resource);
            if (url == null) {
                throw UserError.abort("Could not find " + featureName + " configuration resource \"" + resource + "\".");
            }
            try {
                reader = new InputStreamReader(url.openStream());
                throwable = null;
                try {
                    this.parseAndRegister(reader, featureName, url, configResourcesOption);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                throw UserError.abort("Could not open " + url + ": " + e.getMessage());
            }
        }
    }

    protected abstract void parseAndRegister(Reader var1, String var2, Object var3, HostedOptionKey<String[]> var4);

    static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JSONParserException(errorMessage);
    }

    static Map<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof Map) {
            return (Map)data;
        }
        throw new JSONParserException(errorMessage);
    }

    static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\".");
    }

    static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\" for element '" + propertyName + "'");
    }

    static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JSONParserException("Invalid boolean value '" + value + "' for element '" + propertyName + "'");
    }
}

