/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.results.StaticAnalysisResultsBuilder;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.ExcludeFromReferenceMap;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.hub.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedPrimitiveType;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.meta.MethodPointer;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class UniverseBuilder {
    private final AnalysisUniverse aUniverse;
    private final AnalysisMetaAccess aMetaAccess;
    private final HostedUniverse hUniverse;
    private final HostedMetaAccess hMetaAccess;
    private StaticAnalysisResultsBuilder staticAnalysisResultsBuilder;
    private final UnsupportedFeatures unsupportedFeatures;
    private static final int[] EMPTY = new int[0];
    private static final Set<Class<?>> IMMUTABLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, DynamicHub.class, CEntryPointLiteral.class, BoxedRelocatedPointer.class, ClassInitializationInfo.ClassInitializerFunctionPointerHolder.class));

    public UniverseBuilder(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess, HostedUniverse hUniverse, HostedMetaAccess hMetaAccess, StaticAnalysisResultsBuilder staticAnalysisResultsBuilder, UnsupportedFeatures unsupportedFeatures) {
        this.aUniverse = aUniverse;
        this.aMetaAccess = aMetaAccess;
        this.hUniverse = hUniverse;
        this.hMetaAccess = hMetaAccess;
        this.staticAnalysisResultsBuilder = staticAnalysisResultsBuilder;
        this.unsupportedFeatures = unsupportedFeatures;
    }

    public void build(DebugContext debug) {
        for (AnalysisField aField : this.aUniverse.getFields()) {
            if (!(aField.wrapped instanceof ComputedValueField)) continue;
            ((ComputedValueField)aField.wrapped).processAnalysis(this.aMetaAccess);
        }
        this.aUniverse.seal();
        try (Indent indent = debug.logAndIndent("build universe");){
            for (AnalysisType aType : this.aUniverse.getTypes()) {
                this.makeType(aType);
            }
            for (AnalysisField aField : this.aUniverse.getFields()) {
                this.makeField(aField);
            }
            for (AnalysisMethod aMethod : this.aUniverse.getMethods()) {
                this.makeMethod(aMethod);
            }
            BigBang bb = this.staticAnalysisResultsBuilder.getBigBang();
            ForkJoinTask<?> profilingInformationBuildTask = ForkJoinTask.adapt(this::buildProfilingInformation).fork();
            this.buildSubTypes();
            this.buildOrderedTypes();
            this.buildTypeCheckIDs();
            this.collectDeclaredMethods();
            this.collectMonitorFieldInfo(bb);
            this.collectHashCodeFieldInfo(bb);
            this.layoutInstanceFields();
            this.layoutStaticFields();
            this.collectMethodImplementations();
            this.buildVTables();
            this.buildHubs();
            this.processFieldLocations();
            this.hUniverse.orderedMethods = new ArrayList<HostedMethod>(this.hUniverse.methods.values());
            Collections.sort(this.hUniverse.orderedMethods);
            this.hUniverse.orderedFields = new ArrayList<HostedField>(this.hUniverse.fields.values());
            Collections.sort(this.hUniverse.orderedFields);
            profilingInformationBuildTask.join();
        }
    }

    private HostedType makeType(AnalysisType aType) {
        if (aType == null) {
            return null;
        }
        HostedType hType = this.hUniverse.types.get(aType);
        if (hType != null) {
            return hType;
        }
        String typeName = aType.getName();
        assert (SubstrateUtil.isBuildingLibgraal() || !typeName.contains("/hotspot/") || typeName.contains("/jtt/hotspot/")) : "HotSpot object in image " + typeName;
        assert (!typeName.contains("/analysis/meta/")) : "Analysis meta object in image " + typeName;
        assert (!typeName.contains("/hosted/meta/")) : "Hosted meta object in image " + typeName;
        AnalysisType[] aInterfaces = aType.getInterfaces();
        HostedInterface[] sInterfaces = new HostedInterface[aInterfaces.length];
        for (int i = 0; i < aInterfaces.length; ++i) {
            sInterfaces[i] = (HostedInterface)this.makeType(aInterfaces[i]);
        }
        JavaKind kind = aType.getJavaKind();
        JavaKind storageKind = aType.getStorageKind();
        if (aType.getJavaKind() != JavaKind.Object) {
            assert (!(aType.isInterface() || aType.isInstanceClass() || aType.isArray()));
            hType = new HostedPrimitiveType(this.hUniverse, aType, kind, storageKind);
            this.hUniverse.kindToType.put(hType.getJavaKind(), hType);
        } else if (aType.isInterface()) {
            assert (!aType.isInstanceClass() && !aType.isArray());
            hType = new HostedInterface(this.hUniverse, aType, kind, storageKind, sInterfaces);
        } else if (aType.isInstanceClass()) {
            assert (!aType.isInterface() && !aType.isArray());
            HostedInstanceClass superClass = (HostedInstanceClass)this.makeType(aType.getSuperclass());
            boolean isCloneable = this.aMetaAccess.lookupJavaType(Cloneable.class).isAssignableFrom((ResolvedJavaType)aType);
            hType = new HostedInstanceClass(this.hUniverse, aType, kind, storageKind, superClass, sInterfaces, isCloneable);
            if (superClass == null) {
                this.hUniverse.kindToType.put(JavaKind.Object, hType);
            }
        } else if (aType.isArray()) {
            assert (!aType.isInterface() && !aType.isInstanceClass());
            HostedClass superType = (HostedClass)this.makeType(aType.getSuperclass());
            HostedType componentType = this.makeType(aType.getComponentType());
            hType = new HostedArrayClass(this.hUniverse, aType, kind, storageKind, superType, sInterfaces, componentType);
            int dimension = hType.getArrayDimension();
            if (hType.getBaseType().getSuperclass() != null) {
                this.makeType(hType.getBaseType().getSuperclass().getArrayClass(dimension - 1).getWrapped().getArrayClass());
            }
            if (hType.getBaseType().isInterface()) {
                this.makeType(this.hUniverse.getObjectClass().getArrayClass(dimension - 1).getWrapped().getArrayClass());
            }
            for (HostedInterface interf : hType.getBaseType().getInterfaces()) {
                this.makeType(interf.getArrayClass(dimension - 1).getWrapped().getArrayClass());
            }
        } else {
            throw VMError.shouldNotReachHere();
        }
        this.hUniverse.types.put(aType, hType);
        if (aType.getEnclosingType() != null) {
            hType.setEnclosingType(this.makeType(aType.getEnclosingType()));
        }
        return hType;
    }

    private void makeMethod(AnalysisMethod aMethod) {
        HostedType holder = this.makeType(aMethod.getDeclaringClass());
        Signature signature = this.makeSignature((Signature)aMethod.getSignature(), holder);
        ConstantPool constantPool = this.makeConstantPool(aMethod.getConstantPool(), holder);
        ExceptionHandler[] aHandlers = aMethod.getExceptionHandlers();
        ExceptionHandler[] sHandlers = new ExceptionHandler[aHandlers.length];
        for (int i = 0; i < aHandlers.length; ++i) {
            ExceptionHandler h = aHandlers[i];
            Object catchType = h.getCatchType();
            if (h.getCatchType() instanceof AnalysisType) {
                catchType = this.makeType((AnalysisType)catchType);
            } else assert (catchType == null || catchType instanceof UnresolvedJavaType);
            sHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        HostedMethod sMethod = new HostedMethod(this.hUniverse, aMethod, holder, signature, constantPool, sHandlers);
        assert (!this.hUniverse.methods.containsKey(aMethod));
        this.hUniverse.methods.put(aMethod, sMethod);
        if (aMethod.getAnnotation(CFunction.class) != null) {
            if (!aMethod.isNative()) {
                this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, "Method annotated with @" + CFunction.class.getSimpleName() + " must be declared native");
            }
        } else if (aMethod.isNative() && !aMethod.isIntrinsicMethod() && aMethod.isImplementationInvoked() && !NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            this.unsupportedFeatures.addMessage(aMethod.format("%H.%n(%p)"), aMethod, AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)aMethod, DeletedMethod.NATIVE_MESSAGE, true));
        }
    }

    private Signature makeSignature(Signature aSignature, WrappedJavaType defaultAccessingClass) {
        WrappedSignature hSignature = this.hUniverse.signatures.get(aSignature);
        if (hSignature == null) {
            hSignature = new WrappedSignature((Universe)this.hUniverse, aSignature, defaultAccessingClass);
            this.hUniverse.signatures.put(aSignature, hSignature);
            for (int i = 0; i < aSignature.getParameterCount(false); ++i) {
                this.makeType((AnalysisType)aSignature.getParameterType(i, null));
            }
            this.makeType((AnalysisType)aSignature.getReturnType(null));
        }
        return hSignature;
    }

    private ConstantPool makeConstantPool(ConstantPool aConstantPool, WrappedJavaType defaultAccessingClass) {
        WrappedConstantPool hConstantPool = this.hUniverse.constantPools.get(aConstantPool);
        if (hConstantPool == null) {
            hConstantPool = new WrappedConstantPool((Universe)this.hUniverse, aConstantPool, defaultAccessingClass);
            this.hUniverse.constantPools.put(aConstantPool, hConstantPool);
        }
        return hConstantPool;
    }

    private void makeField(AnalysisField aField) {
        HostedType holder = this.makeType(aField.getDeclaringClass());
        HostedType type = this.makeType(aField.getType());
        HostedField hField = new HostedField(this.hUniverse, this.hMetaAccess, aField, holder, type, this.staticAnalysisResultsBuilder.makeTypeProfile(aField));
        assert (!this.hUniverse.fields.containsKey(aField));
        this.hUniverse.fields.put(aField, hField);
    }

    private void buildProfilingInformation() {
        this.hUniverse.methods.entrySet().parallelStream().forEach(entry -> {
            ((HostedMethod)entry.getValue()).staticAnalysisResults = this.staticAnalysisResultsBuilder.makeResults((AnalysisMethod)entry.getKey());
        });
        this.staticAnalysisResultsBuilder = null;
    }

    private void buildSubTypes() {
        HashMap allSubTypes = new HashMap();
        for (HostedType type : this.hUniverse.types.values()) {
            allSubTypes.put(type, new HashSet());
        }
        for (HostedType type : this.hUniverse.types.values()) {
            if (type.getSuperclass() != null) {
                ((Set)allSubTypes.get(type.getSuperclass())).add(type);
            }
            if (type.isInterface() && type.getInterfaces().length == 0) {
                ((Set)allSubTypes.get(this.hUniverse.getObjectClass())).add(type);
            }
            for (HostedInterface interf : type.getInterfaces()) {
                ((Set)allSubTypes.get(interf)).add(type);
            }
        }
        for (HostedType type : this.hUniverse.types.values()) {
            Set subTypesSet = (Set)allSubTypes.get(type);
            Object[] subTypes = subTypesSet.toArray(new HostedType[subTypesSet.size()]);
            Arrays.sort(subTypes);
            type.subTypes = subTypes;
        }
    }

    private void buildOrderedTypes() {
        boolean typeFound;
        ArrayList<HostedType> orderedTypes = new ArrayList<HostedType>();
        int arrayDepth = 0;
        do {
            typeFound = false;
            for (Map.Entry<JavaKind, HostedType> entry : this.hUniverse.kindToType.entrySet()) {
                if (entry.getKey() == JavaKind.Object) continue;
                typeFound |= this.orderTypes(entry.getValue(), arrayDepth, orderedTypes);
            }
            if (this.hUniverse.kindToType.containsKey(JavaKind.Object)) {
                typeFound |= this.orderTypes(this.hUniverse.kindToType.get(JavaKind.Object), arrayDepth, orderedTypes);
            }
            ++arrayDepth;
        } while (typeFound);
        assert (UniverseBuilder.assertSame(orderedTypes, this.hUniverse.types.values()));
        this.hUniverse.orderedTypes = orderedTypes;
    }

    private boolean orderTypes(HostedType baseType, int arrayDepth, List<HostedType> allTypes) {
        HostedType type = baseType.getArrayClass(arrayDepth);
        if (type == null) {
            return false;
        }
        if (type.typeID != -1) {
            return true;
        }
        type.typeID = allTypes.size();
        allTypes.add(type);
        for (HostedType sub : baseType.subTypes) {
            if (sub.isArray()) continue;
            this.orderTypes(sub, arrayDepth, allTypes);
        }
        return true;
    }

    private void buildTypeCheckIDs() {
        BitSet[] assignableTypeIDs = new BitSet[this.hUniverse.orderedTypes.size()];
        BitSet[] concreteTypeIDs = new BitSet[this.hUniverse.orderedTypes.size()];
        for (int i = this.hUniverse.orderedTypes.size() - 1; i >= 0; --i) {
            HostedType type = this.hUniverse.orderedTypes.get(i);
            this.buildTypeCheckIDs(type, assignableTypeIDs, concreteTypeIDs);
        }
    }

    private void buildTypeCheckIDs(HostedType type, BitSet[] assignableTypeIDs, BitSet[] concreteTypeIDs) {
        if (assignableTypeIDs[type.typeID] != null) {
            return;
        }
        BitSet assignable = new BitSet();
        BitSet concrete = new BitSet();
        HostedType strengthenStampType = null;
        for (HostedType subBase : type.getBaseType().subTypes) {
            HostedType sub = subBase.getArrayClass(type.getArrayDimension());
            if (sub == null || sub.equals(type)) continue;
            this.buildTypeCheckIDs(sub, assignableTypeIDs, concreteTypeIDs);
            assignable.or(assignableTypeIDs[sub.getTypeID()]);
            concrete.or(concreteTypeIDs[sub.getTypeID()]);
            if (strengthenStampType == null) {
                strengthenStampType = sub.strengthenStampType;
                continue;
            }
            if (sub.strengthenStampType == null) continue;
            strengthenStampType = type;
        }
        if (type.isInstantiated()) {
            strengthenStampType = type;
        }
        type.strengthenStampType = strengthenStampType;
        assignable.set(type.typeID);
        if (type.getWrapped().isInstantiated()) {
            assert (type.isInstanceClass() && !Modifier.isAbstract(type.getModifiers()) || type.isArray());
            concrete.set(type.typeID);
        }
        int[] assignableFromMatches = EMPTY;
        int assignableStart = assignable.nextSetBit(0);
        while (assignableStart != -1) {
            int assignableEnd = assignable.nextClearBit(assignableStart);
            assignableFromMatches = Arrays.copyOf(assignableFromMatches, assignableFromMatches.length + 2);
            assignableFromMatches[assignableFromMatches.length - 2] = assignableStart;
            assignableFromMatches[assignableFromMatches.length - 1] = assignableEnd - assignableStart;
            assignableStart = assignable.nextSetBit(assignableEnd);
        }
        type.assignableFromMatches = assignableFromMatches;
        int rangeStart = concrete.nextSetBit(0);
        if (rangeStart >= 0) {
            int rangeEnd = concrete.nextClearBit(rangeStart);
            int assignableEnd = assignable.nextClearBit(rangeStart);
            if (assignableEnd > concrete.nextSetBit(rangeEnd)) {
                rangeEnd = assignableEnd;
            }
            int rangeLength = rangeEnd - rangeStart;
            if (concrete.nextSetBit(rangeEnd) < 0) {
                if (rangeLength == 1 && !type.isWordType()) {
                    type.uniqueConcreteImplementation = this.hUniverse.orderedTypes.get(rangeStart);
                }
                type.setInstanceOfRange(rangeStart, rangeLength);
            } else {
                int interfaceBit = this.hUniverse.numInterfaceBits++;
                UniverseBuilder.setInstanceOfBits(type, interfaceBit);
                type.setInstanceOfRange(interfaceBit, -1);
            }
        }
        assignableTypeIDs[type.typeID] = assignable;
        concreteTypeIDs[type.typeID] = concrete;
    }

    private static void setInstanceOfBits(HostedType type, int bit) {
        if (type.instanceOfBits == null) {
            type.instanceOfBits = new BitSet(bit + 1);
        }
        if (!type.instanceOfBits.get(bit)) {
            type.instanceOfBits.set(bit);
            for (HostedType subBase : type.getBaseType().subTypes) {
                HostedType sub = subBase.getArrayClass(type.getArrayDimension());
                if (sub == null || sub.equals(type)) continue;
                UniverseBuilder.setInstanceOfBits(sub, bit);
            }
        }
    }

    private void collectMonitorFieldInfo(BigBang bb) {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        HashSet immutableTypes = new HashSet();
        for (Class<?> immutableType : IMMUTABLE_TYPES) {
            Optional aType = this.aMetaAccess.optionalLookupJavaType(immutableType);
            if (!aType.isPresent()) continue;
            immutableTypes.add(aType.get());
        }
        TypeState allSynchronizedTypeState = bb.getAllSynchronizedTypeState();
        for (Optional aType : allSynchronizedTypeState.types()) {
            if (aType.isArray() || immutableTypes.contains(aType)) continue;
            HostedInstanceClass hostedInstanceClass = (HostedInstanceClass)this.hUniverse.lookup((JavaType)aType);
            hostedInstanceClass.setNeedMonitorField();
        }
    }

    public static boolean isKnownImmutableType(Class<?> clazz) {
        return IMMUTABLE_TYPES.contains(clazz);
    }

    private void collectHashCodeFieldInfo(BigBang bb) {
        AnalysisMethod method;
        try {
            method = this.aMetaAccess.lookupJavaMethod((Executable)System.class.getMethod("identityHashCode", Object.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw VMError.shouldNotReachHere();
        }
        if (method == null) {
            return;
        }
        DebugContext debug = bb.getDebug();
        try (Indent ignore = debug.logAndIndent("check types for which identityHashCode is invoked");){
            TypeState thisParamState = method.getTypeFlow().getParameterTypeState(bb, 0);
            assert (thisParamState != null);
            Iterable typesNeedHashCode = thisParamState.types();
            if (typesNeedHashCode == null || thisParamState.isUnknown()) {
                debug.log("all types need a hashCode field");
                for (HostedType hType : this.hUniverse.getTypes()) {
                    if (!hType.isInstanceClass()) continue;
                    ((HostedInstanceClass)hType).setNeedHashCodeField();
                }
                this.hUniverse.getObjectClass().setNeedHashCodeField();
            } else {
                for (AnalysisType type : typesNeedHashCode) {
                    debug.log("type %s is argument to identityHashCode", (Object)type);
                    if (!type.isInstanceClass()) continue;
                    HostedInstanceClass hType = (HostedInstanceClass)this.hUniverse.lookup((JavaType)type);
                    hType.setNeedHashCodeField();
                }
            }
        }
    }

    private void layoutInstanceFields() {
        this.layoutInstanceFields(this.hUniverse.getObjectClass(), ConfigurationValues.getObjectLayout().getFirstFieldOffset());
    }

    private void layoutInstanceFields(HostedInstanceClass clazz, int superSize) {
        ArrayList<HostedField> rawFields = new ArrayList<HostedField>();
        ArrayList<HostedField> orderedFields = new ArrayList<HostedField>();
        HostedConfiguration.instance().findAllFieldsForLayout(this.hUniverse, this.hMetaAccess, this.hUniverse.fields, rawFields, orderedFields, clazz);
        int startSize = superSize;
        if (clazz.getAnnotation(DeoptimizedFrame.ReserveDeoptScratchSpace.class) != null) {
            assert (startSize <= DeoptimizedFrame.getScratchSpaceOffset());
            startSize = DeoptimizedFrame.getScratchSpaceOffset() + ConfigurationValues.getObjectLayout().getDeoptScratchSpace();
        }
        if (HybridLayout.isHybrid(clazz)) {
            assert (startSize == ConfigurationValues.getObjectLayout().getArrayLengthOffset());
            int fieldSize = ConfigurationValues.getObjectLayout().sizeInBytes(JavaKind.Int);
            startSize += fieldSize;
            assert (clazz.equals(this.hMetaAccess.lookupJavaType((Class)DynamicHub.class))) : "currently only DynamicHub may be a hybrid class";
            startSize += (this.hUniverse.numInterfaceBits + 8 - 1) / 8;
        }
        Collections.sort(rawFields);
        int nextOffset = startSize;
        while (rawFields.size() > 0) {
            boolean progress = false;
            for (int i = 0; i < rawFields.size(); ++i) {
                HostedField field = rawFields.get(i);
                int fieldSize = ConfigurationValues.getObjectLayout().sizeInBytes(field.getStorageKind());
                if (nextOffset % fieldSize != 0) continue;
                field.setLocation(nextOffset);
                nextOffset += fieldSize;
                rawFields.remove(i);
                orderedFields.add(field);
                progress = true;
                break;
            }
            if (progress) continue;
            ++nextOffset;
        }
        int endOfFieldsOffset = nextOffset;
        if (clazz.needMonitorField()) {
            int referenceFieldAlignmentAndSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            nextOffset = NumUtil.roundUp((int)nextOffset, (int)referenceFieldAlignmentAndSize);
            clazz.setMonitorFieldOffset(nextOffset);
            nextOffset += referenceFieldAlignmentAndSize;
        }
        if (clazz.needHashCodeField()) {
            int intFieldSize = ConfigurationValues.getObjectLayout().sizeInBytes(JavaKind.Int);
            nextOffset = NumUtil.roundUp((int)nextOffset, (int)intFieldSize);
            clazz.setHashCodeFieldOffset(nextOffset);
            nextOffset += intFieldSize;
        }
        clazz.instanceFields = orderedFields.toArray(new HostedField[orderedFields.size()]);
        clazz.instanceSize = ConfigurationValues.getObjectLayout().alignUp(nextOffset);
        for (HostedType subClass : clazz.subTypes) {
            if (!subClass.isInstanceClass()) continue;
            this.layoutInstanceFields((HostedInstanceClass)subClass, endOfFieldsOffset);
        }
    }

    private void layoutStaticFields() {
        ArrayList<HostedField> fields = new ArrayList<HostedField>();
        for (HostedField field : this.hUniverse.fields.values()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        Collections.sort(fields);
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextPrimitiveField = 0;
        int nextObjectField = 0;
        List[] fieldsOfTypes = new ArrayList[this.hUniverse.orderedTypes.size()];
        for (HostedField hostedField : fields) {
            int typeId;
            if (hostedField.wrapped.isWritten() || MaterializedConstantFields.singleton().contains(hostedField.wrapped)) {
                if (hostedField.getStorageKind() == JavaKind.Object) {
                    hostedField.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Object, nextObjectField)));
                    ++nextObjectField;
                } else {
                    int fieldSize = layout.sizeInBytes(hostedField.getStorageKind());
                    while (layout.getArrayElementOffset(JavaKind.Byte, nextPrimitiveField) % (long)fieldSize != 0L) {
                        ++nextPrimitiveField;
                    }
                    hostedField.setLocation(NumUtil.safeToInt((long)layout.getArrayElementOffset(JavaKind.Byte, nextPrimitiveField)));
                    nextPrimitiveField += fieldSize;
                }
            }
            if (fieldsOfTypes[typeId = hostedField.getDeclaringClass().getTypeID()] == null) {
                fieldsOfTypes[typeId] = new ArrayList();
            }
            fieldsOfTypes[typeId].add(hostedField);
        }
        HostedField[] noFields = new HostedField[]{};
        for (HostedType type : this.hUniverse.orderedTypes) {
            List fieldsOfType = fieldsOfTypes[type.getTypeID()];
            if (fieldsOfType != null) {
                type.staticFields = fieldsOfType.toArray(new HostedField[fieldsOfType.size()]);
                continue;
            }
            type.staticFields = noFields;
        }
        Object[] objectArray = new Object[nextObjectField];
        byte[] staticPrimitiveFields = new byte[nextPrimitiveField];
        StaticFieldsSupport.setData(objectArray, staticPrimitiveFields);
    }

    private void collectDeclaredMethods() {
        ArrayList list;
        ArrayList[] methodsOfType = new ArrayList[this.hUniverse.orderedTypes.size()];
        for (HostedMethod method : this.hUniverse.methods.values()) {
            int typeId = method.getDeclaringClass().getTypeID();
            list = methodsOfType[typeId];
            if (list == null) {
                methodsOfType[typeId] = list = new ArrayList();
            }
            list.add(method);
        }
        HostedMethod[] noMethods = new HostedMethod[]{};
        for (HostedType type : this.hUniverse.orderedTypes) {
            list = methodsOfType[type.getTypeID()];
            if (list != null) {
                Collections.sort(list);
                type.allDeclaredMethods = list.toArray(new HostedMethod[list.size()]);
                continue;
            }
            type.allDeclaredMethods = noMethods;
        }
    }

    private void collectMethodImplementations() {
        for (HostedMethod method : this.hUniverse.methods.values()) {
            method.implementations = this.hUniverse.lookup((JavaMethod[])method.wrapped.getImplementations());
            Arrays.sort(method.implementations);
        }
    }

    private void buildVTables() {
        HashMap<HostedType, ArrayList<HostedMethod>> vtablesMap = new HashMap<HostedType, ArrayList<HostedMethod>>();
        HashMap<HostedType, BitSet> usedSlotsMap = new HashMap<HostedType, BitSet>();
        HashMap<HostedMethod, Set<Integer>> vtablesSlots = new HashMap<HostedMethod, Set<Integer>>();
        for (HostedType type : this.hUniverse.orderedTypes) {
            vtablesMap.put(type, new ArrayList());
            BitSet initialBitSet = new BitSet();
            usedSlotsMap.put(type, initialBitSet);
        }
        this.assignImplementations((HostedType)this.hUniverse.getObjectClass(), vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<Pair> interfaces = new ArrayList<Pair>();
        for (HostedType type : this.hUniverse.orderedTypes) {
            if (!type.isInterface()) continue;
            int importance = UniverseBuilder.collectSubtypes(type, new HashSet<HostedType>()).size();
            interfaces.add(Pair.create((Object)type, (Object)importance));
        }
        interfaces.sort((pair1, pair2) -> (Integer)pair2.getRight() - (Integer)pair1.getRight());
        for (Pair pair : interfaces) {
            this.assignImplementations((HostedType)pair.getLeft(), vtablesMap, usedSlotsMap, vtablesSlots);
        }
        this.buildVTable(this.hUniverse.getObjectClass(), vtablesMap, usedSlotsMap, vtablesSlots);
        for (HostedType type : this.hUniverse.orderedTypes) {
            if (type.vtable != null) continue;
            assert (type.isInterface() || type.isPrimitive());
            type.vtable = new HostedMethod[0];
        }
        if (SubstrateUtil.assertionsEnabled()) {
            for (HostedType type : this.hUniverse.orderedTypes) {
                for (HostedMethod m : type.vtable) {
                    assert (m == null || m.equals(this.hUniverse.lookup((JavaMethod)type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)m.wrapped, (ResolvedJavaType)type.wrapped))));
                }
            }
        }
    }

    private static Set<HostedType> collectSubtypes(HostedType type, Set<HostedType> allSubtypes) {
        if (allSubtypes.add(type)) {
            for (HostedType subtype : type.subTypes) {
                UniverseBuilder.collectSubtypes(subtype, allSubtypes);
            }
        }
        return allSubtypes;
    }

    private void buildVTable(HostedClass clazz, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        this.assignImplementations((HostedType)clazz, vtablesMap, usedSlotsMap, vtablesSlots);
        ArrayList<HostedMethod> vtable = vtablesMap.get(clazz);
        HostedMethod[] vtableArray = vtable.toArray(new HostedMethod[vtable.size()]);
        assert (vtableArray.length == 0 || vtableArray[vtableArray.length - 1] != null) : "Unnecessary entry at end of vtable";
        clazz.vtable = vtableArray;
        for (HostedType subClass : clazz.subTypes) {
            if (subClass.isInterface()) continue;
            this.buildVTable((HostedClass)subClass, vtablesMap, usedSlotsMap, vtablesSlots);
        }
    }

    private void assignImplementations(HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        for (HostedMethod method : type.getAllDeclaredMethods()) {
            int slot;
            if (!method.wrapped.isInvoked() && !method.wrapped.isImplementationInvoked() || method.implementations.length <= 1) continue;
            method.vtableIndex = slot = this.findSlot(method, vtablesMap, usedSlotsMap, vtablesSlots);
            this.assignImplementations(method.getDeclaringClass(), method, slot, vtablesMap);
        }
    }

    private void assignImplementations(HostedType type, HostedMethod method, int slot, Map<HostedType, ArrayList<HostedMethod>> vtablesMap) {
        if (type.wrapped.isInstantiated()) {
            assert (type.isInstanceClass() && !type.isAbstract() || type.isArray());
            HostedMethod resolvedMethod = this.resolveMethod(type, method);
            if (resolvedMethod != null) {
                ArrayList<HostedMethod> vtable = vtablesMap.get(type);
                if (slot < vtable.size() && vtable.get(slot) != null) {
                    assert (vtable.get(slot).equals(resolvedMethod));
                } else {
                    UniverseBuilder.resize(vtable, slot + 1);
                    assert (vtable.get(slot) == null);
                    vtable.set(slot, resolvedMethod);
                }
            }
        }
        for (HostedType subtype : type.subTypes) {
            this.assignImplementations(subtype, method, slot, vtablesMap);
        }
    }

    private HostedMethod resolveMethod(HostedType type, HostedMethod method) {
        AnalysisMethod resolved = type.wrapped.resolveConcreteMethod((ResolvedJavaMethod)method.wrapped, (ResolvedJavaType)type.wrapped);
        if (resolved == null || !resolved.isImplementationInvoked()) {
            return null;
        }
        assert (!resolved.isAbstract());
        return this.hUniverse.lookup((JavaMethod)resolved);
    }

    private static void resize(ArrayList<?> list, int minSize) {
        list.ensureCapacity(minSize);
        while (list.size() < minSize) {
            list.add(null);
        }
    }

    private int findSlot(HostedMethod method, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap, Map<HostedMethod, Set<Integer>> vtablesSlots) {
        Set<Integer> resultSlots = vtablesSlots.get(method.implementations[0]);
        for (HostedMethod impl : method.implementations) {
            Set<Integer> implSlots = vtablesSlots.get(impl);
            if (implSlots == null) {
                resultSlots = null;
                break;
            }
            resultSlots.retainAll(implSlots);
        }
        if (resultSlots != null && !resultSlots.isEmpty()) {
            int resultSlot = Integer.MAX_VALUE;
            for (int slot : resultSlots) {
                resultSlot = Math.min(resultSlot, slot);
            }
            return resultSlot;
        }
        BitSet usedSlots = new BitSet();
        this.collectUsedSlots(method.getDeclaringClass(), usedSlots, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.collectUsedSlots(impl.getDeclaringClass(), usedSlots, usedSlotsMap);
        }
        int resultSlot = usedSlots.nextClearBit(0);
        this.markSlotAsUsed(resultSlot, method.getDeclaringClass(), vtablesMap, usedSlotsMap);
        for (HostedMethod impl : method.implementations) {
            this.markSlotAsUsed(resultSlot, impl.getDeclaringClass(), vtablesMap, usedSlotsMap);
            vtablesSlots.computeIfAbsent(impl, k -> new HashSet()).add(resultSlot);
        }
        return resultSlot;
    }

    private void collectUsedSlots(HostedType type, BitSet usedSlots, Map<HostedType, BitSet> usedSlotsMap) {
        usedSlots.or(usedSlotsMap.get(type));
        for (HostedType sub : type.subTypes) {
            this.collectUsedSlots(sub, usedSlots, usedSlotsMap);
        }
    }

    private void markSlotAsUsed(int resultSlot, HostedType type, Map<HostedType, ArrayList<HostedMethod>> vtablesMap, Map<HostedType, BitSet> usedSlotsMap) {
        assert (resultSlot >= vtablesMap.get(type).size() || vtablesMap.get(type).get(resultSlot) == null);
        usedSlotsMap.get(type).set(resultSlot);
        for (HostedType sub : type.subTypes) {
            this.markSlotAsUsed(resultSlot, sub, vtablesMap, usedSlotsMap);
        }
    }

    private void buildHubs() {
        ReferenceMapEncoder referenceMapEncoder = new ReferenceMapEncoder();
        HashMap<HostedType, ReferenceMapEncoder.Input> referenceMaps = new HashMap<HostedType, ReferenceMapEncoder.Input>();
        for (HostedType type : this.hUniverse.orderedTypes) {
            ReferenceMapEncoder.Input referenceMap = UniverseBuilder.createReferenceMap(type);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            referenceMaps.put(type, referenceMap);
            referenceMapEncoder.add(referenceMap);
        }
        ((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).setData(referenceMapEncoder.encodeAll(null));
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        for (HostedType type : this.hUniverse.orderedTypes) {
            int layoutHelper;
            int monitorOffset = 0;
            int hashCodeOffset = 0;
            if (type.isInstanceClass()) {
                HostedInstanceClass instanceClass = (HostedInstanceClass)type;
                if (instanceClass.isAbstract()) {
                    layoutHelper = LayoutEncoding.forAbstract();
                } else if (HybridLayout.isHybrid(type)) {
                    HybridLayout hybridLayout = new HybridLayout(instanceClass, ol);
                    JavaKind storageKind = hybridLayout.getArrayElementStorageKind();
                    boolean isObject = storageKind == JavaKind.Object;
                    layoutHelper = LayoutEncoding.forArray(isObject, hybridLayout.getArrayBaseOffset(), ol.getArrayIndexShift(storageKind), ol.getAlignment());
                } else {
                    layoutHelper = LayoutEncoding.forInstance(ConfigurationValues.getObjectLayout().alignUp(instanceClass.getInstanceSize()));
                }
                monitorOffset = instanceClass.getMonitorFieldOffset();
                hashCodeOffset = instanceClass.getHashCodeFieldOffset();
            } else if (type.isArray()) {
                JavaKind storageKind = type.getComponentType().getStorageKind();
                boolean isObject = storageKind == JavaKind.Object;
                layoutHelper = LayoutEncoding.forArray(isObject, ol.getArrayBaseOffset(storageKind), ol.getArrayIndexShift(storageKind), ol.getAlignment());
                hashCodeOffset = ol.getArrayHashCodeOffset();
            } else if (type.isInterface()) {
                layoutHelper = LayoutEncoding.forInterface();
            } else if (type.isPrimitive()) {
                layoutHelper = LayoutEncoding.forPrimitive();
            } else {
                throw VMError.shouldNotReachHere();
            }
            CFunctionPointer[] vtable = new CFunctionPointer[type.vtable.length];
            for (int idx = 0; idx < type.vtable.length; ++idx) {
                vtable[idx] = MethodPointer.factory(type.vtable[idx]);
            }
            ReferenceMapEncoder.Input referenceMap = (ReferenceMapEncoder.Input)referenceMaps.get(type);
            assert (referenceMap != null);
            assert (((SubstrateReferenceMap)referenceMap).hasNoDerivedOffsets());
            long referenceMapIndex = referenceMapEncoder.lookupEncoding(referenceMap);
            DynamicHub hub = type.getHub();
            hub.setData(layoutHelper, type.getTypeID(), monitorOffset, hashCodeOffset, type.getAssignableFromMatches(), type.instanceOfBits, vtable, referenceMapIndex, type.isInstantiated());
        }
    }

    private static ReferenceMapEncoder.Input createReferenceMap(HostedType type) {
        HostedInstanceClass instanceClass;
        int monitorOffset;
        HostedField[] fields = type.getInstanceFields(true);
        SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
        for (HostedField field : fields) {
            if (field.getType().getStorageKind() != JavaKind.Object || !field.hasLocation() || field.getAnnotation(ExcludeFromReferenceMap.class) != null) continue;
            referenceMap.markReferenceAtOffset(field.getLocation(), true);
        }
        if (type.isInstanceClass() && (monitorOffset = (instanceClass = (HostedInstanceClass)type).getMonitorFieldOffset()) != 0) {
            referenceMap.markReferenceAtOffset(monitorOffset, true);
        }
        return referenceMap;
    }

    private void processFieldLocations() {
        for (HostedField hField : this.hUniverse.fields.values()) {
            AnalysisField aField = hField.wrapped;
            if (aField.wrapped instanceof ComputedValueField) {
                ((ComputedValueField)aField.wrapped).processSubstrate(this.hMetaAccess);
            }
            if (hField.hasLocation() || !Modifier.isStatic(hField.getModifiers()) || aField.isWritten()) continue;
            hField.setUnmaterializedStaticConstant();
        }
    }

    private static boolean assertSame(Collection<HostedType> c1, Collection<HostedType> c2) {
        ArrayList<HostedType> list1 = new ArrayList<HostedType>(c1);
        ArrayList<HostedType> list2 = new ArrayList<HostedType>(c2);
        Collections.sort(list1);
        Collections.sort(list2);
        for (int i = 0; i < Math.min(list1.size(), list2.size()); ++i) {
            assert (list1.get(i) == list2.get(i));
        }
        assert (list1.size() == list2.size());
        return true;
    }
}

