/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.thread.AddressOfVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.CompareAndSetVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.VMThreadLocalSTHolderNode;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.memory.HeapAccess;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;

@AutomaticFeature
public class VMThreadSTFeature
implements GraalFeature {
    private final VMThreadLocalCollector threadLocalCollector = new VMThreadLocalCollector();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue() == false;
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        ImageSingletons.add(VMThreadLocalSTSupport.class, (Object)new VMThreadLocalSTSupport());
        config.registerObjectReplacer((Function)this.threadLocalCollector);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        Class[] typesWithGetAddress;
        for (Class<? extends FastThreadLocal> threadLocalClass : VMThreadLocalInfo.THREAD_LOCAL_CLASSES) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, threadLocalClass);
            Class<?> valueClass = VMThreadLocalInfo.getValueClass(threadLocalClass);
            this.registerAccessors(r, valueClass, false);
            this.registerAccessors(r, valueClass, true);
            r.register3("compareAndSet", InvocationPlugin.Receiver.class, valueClass, valueClass, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
                    return VMThreadSTFeature.this.handleCompareAndSet(b, targetMethod, receiver, expect, update);
                }
            });
            r.register4("compareAndSet", InvocationPlugin.Receiver.class, IsolateThread.class, valueClass, valueClass, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
                    return VMThreadSTFeature.this.handleCompareAndSet(b, targetMethod, receiver, expect, update);
                }
            });
        }
        for (Class type : typesWithGetAddress = new Class[]{FastThreadLocalBytes.class, FastThreadLocalWord.class}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, (Type)type);
            r.register1("getAddress", InvocationPlugin.Receiver.class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    return VMThreadSTFeature.this.handleGetAddress(b, targetMethod, receiver);
                }
            });
            r.register2("getAddress", InvocationPlugin.Receiver.class, IsolateThread.class, new InvocationPlugin(){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                    return VMThreadSTFeature.this.handleGetAddress(b, targetMethod, receiver);
                }
            });
        }
    }

    private void registerAccessors(InvocationPlugins.Registration r, Class<?> valueClass, boolean isVolatile) {
        String suffix = isVolatile ? "Volatile" : "";
        r.register1("get" + suffix, InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return VMThreadSTFeature.this.handleGet(b, targetMethod, receiver);
            }
        });
        r.register2("get" + suffix, InvocationPlugin.Receiver.class, IsolateThread.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                return VMThreadSTFeature.this.handleGet(b, targetMethod, receiver);
            }
        });
        r.register2("set" + suffix, InvocationPlugin.Receiver.class, valueClass, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
                return VMThreadSTFeature.this.handleSet(b, receiver, valueNode);
            }
        });
        r.register3("set" + suffix, InvocationPlugin.Receiver.class, IsolateThread.class, valueClass, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode) {
                return VMThreadSTFeature.this.handleSet(b, receiver, valueNode);
            }
        });
    }

    private boolean handleGet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
        VMThreadLocalInfo info = this.threadLocalCollector.findInfo(b, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((ValueNode)new VMThreadLocalSTHolderNode(info));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new LoadVMThreadLocalNode(b.getMetaAccess(), info, (ValueNode)holder, HeapAccess.BarrierType.PRECISE));
        return true;
    }

    private boolean handleSet(GraphBuilderContext b, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
        VMThreadLocalInfo info = this.threadLocalCollector.findInfo(b, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((ValueNode)new VMThreadLocalSTHolderNode(info));
        b.add((ValueNode)new StoreVMThreadLocalNode(info, (ValueNode)holder, valueNode, HeapAccess.BarrierType.PRECISE));
        return true;
    }

    private boolean handleCompareAndSet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((ValueNode)new VMThreadLocalSTHolderNode(threadLocalInfo));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new CompareAndSetVMThreadLocalNode(threadLocalInfo, (ValueNode)holder, expect, update));
        return true;
    }

    private boolean handleGetAddress(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        VMThreadLocalSTHolderNode holder = (VMThreadLocalSTHolderNode)b.add((ValueNode)new VMThreadLocalSTHolderNode(threadLocalInfo));
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new AddressOfVMThreadLocalNode(threadLocalInfo, (ValueNode)holder));
        return true;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (VMThreadLocalInfos.setInfos(this.threadLocalCollector.threadLocals.values())) {
            access.requireAnalysisIteration();
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        List<VMThreadLocalInfo> sortedThreadLocalInfos = this.threadLocalCollector.sortThreadLocals((Feature.CompilationAccess)config);
        ObjectLayout layout = ConfigurationValues.getObjectLayout();
        int nextObject = 0;
        int nextPrimitive = 0;
        for (VMThreadLocalInfo info : sortedThreadLocalInfos) {
            if (info.isObject) {
                info.offset = layout.getArrayElementOffset(JavaKind.Object, nextObject);
                ++nextObject;
                continue;
            }
            assert (nextPrimitive % Math.min(8, info.sizeInBytes) == 0) : "alignment mismatch: " + info.sizeInBytes + ", " + nextPrimitive;
            info.offset = layout.getArrayElementOffset(JavaKind.Byte, nextPrimitive);
            nextPrimitive += info.sizeInBytes;
        }
        VMThreadLocalSTSupport support = (VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class);
        support.objectThreadLocals = new Object[nextObject];
        support.primitiveThreadLocals = new byte[nextPrimitive];
        VMThreadLocalInfos.setInfos(sortedThreadLocalInfos);
    }
}

