/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.truffle.HostedTruffleConstantFieldProvider;
import com.oracle.svm.truffle.NodeClassFeature;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstratePartialEvaluator;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.Profile;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.SharedTruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.RuntimeReflection;

public final class TruffleFeature
implements GraalFeature {
    private boolean firstAnalysisRun;
    protected Support support;
    private final Set<ResolvedJavaMethod> blacklistMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<GraalFeature.CallTreeNode> blacklistViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);
    private final Set<ResolvedJavaMethod> warnMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<GraalFeature.CallTreeNode> warnViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);
    private final Set<GraalFeature.CallTreeNode> neverPartOfCompilationViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blacklistViolationComparator);

    public static TruffleFeature getSingleton() {
        return (TruffleFeature)ImageSingletons.lookup(TruffleFeature.class);
    }

    public static void setSupport(Support support) {
        TruffleFeature.getSingleton().support = support;
    }

    public static Support getSupport() {
        return TruffleFeature.getSingleton().support;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(com.oracle.svm.graal.hosted.GraalFeature.class, NodeClassFeature.class);
    }

    private static void initializeTruffleReflectively(ClassLoader imageClassLoader) {
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "initializeNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.HomeFinder", "initializeNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public static void removeTruffleLanguage(String mimeType) {
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "removeLanguageFromNativeImage", Collections.singletonList(String.class), mimeType);
    }

    private static Collection<Class<?>> getLanguageClasses() {
        return (Collection)TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "getLanguageClasses", Collections.emptyList(), new Object[0]);
    }

    private static <T> T invokeStaticMethod(String className, String methodName, Collection<Class<?>> parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = parameterTypes.size() > 0 ? clazz.getDeclaredMethod(methodName, parameterTypes.toArray(new Class[parameterTypes.size()])) : clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(null, args);
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        TruffleRuntime runtime;
        if (this.support == null) {
            this.support = new Support();
        }
        UserError.guarantee((runtime = Truffle.getRuntime()) != null, "TruffleRuntime not available via Truffle.getRuntime()", new Object[0]);
        UserError.guarantee(runtime instanceof SubstrateTruffleRuntime || runtime instanceof DefaultTruffleRuntime, "Unsupported TruffleRuntime " + runtime.getClass().getName() + " (only SubstrateTruffleRuntime or DefaultTruffleRuntime allowed)", new Object[0]);
        if (TruffleFeature.useTruffleCompiler()) {
            SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)runtime;
            truffleRuntime.resetHosted();
        }
        TruffleFeature.initializeTruffleReflectively(Thread.currentThread().getContextClassLoader());
    }

    public void cleanup() {
        TruffleRuntime runtime = Truffle.getRuntime();
        if (runtime instanceof SubstrateTruffleRuntime) {
            ((SubstrateTruffleRuntime)runtime).resetNativeImageState();
        } else if (!(runtime instanceof DefaultTruffleRuntime)) {
            throw VMError.shouldNotReachHere("Only SubstrateTruffleRuntime and DefaultTruffleRuntime supported");
        }
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "resetPreInitializedEngine", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.interop.Message", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleFeature.invokeStaticMethod("com.oracle.truffle.api.impl.HomeFinder", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public static boolean useTruffleCompiler() {
        return Truffle.getRuntime() instanceof SubstrateTruffleRuntime;
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(invocationPlugins, Profile.class);
        r.register0("isProfilingEnabled", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)Truffle.getRuntime().isProfilingEnabled()));
                return true;
            }
        });
    }

    private void registerNeverPartOfCompilation(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CompilerAsserts.class);
        r.setAllowOverwrite(true);
        r.register0("neverPartOfCompilation", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, null);
            }
        });
        r.register1("neverPartOfCompilation", String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, message);
            }
        });
    }

    private boolean handleNeverPartOfCompilation(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode messageNode) {
        String message = "CompilerAsserts.neverPartOfCompilation()";
        if (messageNode != null && messageNode.isConstant()) {
            message = messageNode.asConstant().toValueString();
        }
        NeverPartOfCompilationNode neverPartOfCompilation = (NeverPartOfCompilationNode)b.add((ValueNode)new NeverPartOfCompilationNode(message));
        if (Options.TruffleCheckNeverPartOfCompilation.getValue().booleanValue() && !neverPartOfCompilation.stateAfter().getMethod().getDeclaringClass().equals(targetMethod.getDeclaringClass())) {
            GraalFeature.CallTreeNode callerNode = ((GraalFeature.RuntimeBytecodeParser)b).getCallTreeNode();
            GraalFeature.CallTreeNode calleeNode = new GraalFeature.CallTreeNode(targetMethod, targetMethod, callerNode, callerNode.getLevel() + 1, com.oracle.svm.graal.hosted.GraalFeature.buildSourceReference(neverPartOfCompilation.stateAfter()));
            this.neverPartOfCompilationViolations.add(calleeNode);
        }
        return true;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        TruffleFeature.getLanguageClasses().forEach(xva$0 -> RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{xva$0}));
        config.registerHierarchyForReflectiveInstantiation(TruffleInstrument.class);
        config.registerHierarchyForReflectiveInstantiation(InstrumentableFactory.class);
        if (TruffleFeature.useTruffleCompiler()) {
            SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
            com.oracle.svm.graal.hosted.GraalFeature graalFeature = (com.oracle.svm.graal.hosted.GraalFeature)ImageSingletons.lookup(com.oracle.svm.graal.hosted.GraalFeature.class);
            SnippetReflectionProvider snippetReflection = graalFeature.getHostedProviders().getSnippetReflection();
            SubstrateTruffleCompiler truffleCompiler = truffleRuntime.initTruffleCompiler();
            truffleRuntime.lookupCallMethods((MetaAccessProvider)config.getMetaAccess());
            PartialEvaluator partialEvaluator = truffleCompiler.getPartialEvaluator();
            TruffleFeature.registerKnownTruffleFields(config, partialEvaluator.getKnownTruffleTypes());
            this.support.registerInterpreterEntryMethodsAsCompiled(partialEvaluator, access);
            TruffleFeature.registerTruffleOptions(config);
            GraphBuilderConfiguration graphBuilderConfig = partialEvaluator.getConfigForParsing();
            if (Options.TruffleInlineDuringParsing.getValue().booleanValue()) {
                graphBuilderConfig.getPlugins().appendInlineInvokePlugin((InlineInvokePlugin)new TruffleParsingInlineInvokePlugin(graalFeature.getHostedProviders().getReplacements(), graphBuilderConfig.getPlugins().getInvocationPlugins(), partialEvaluator, method -> this.includeCallee((ResolvedJavaMethod)method, null, null)));
            }
            this.registerNeverPartOfCompilation(graphBuilderConfig.getPlugins().getInvocationPlugins());
            graphBuilderConfig.getPlugins().getInvocationPlugins().closeRegistration();
            HostedProviders newHostedProviders = new HostedProviders(partialEvaluator.getProviders().getMetaAccess(), partialEvaluator.getProviders().getCodeCache(), partialEvaluator.getProviders().getConstantReflection(), (ConstantFieldProvider)new HostedTruffleConstantFieldProvider(partialEvaluator.getProviders().getConstantFieldProvider()), partialEvaluator.getProviders().getForeignCalls(), partialEvaluator.getProviders().getLowerer(), partialEvaluator.getProviders().getReplacements(), partialEvaluator.getProviders().getStampProvider(), snippetReflection, graalFeature.getHostedProviders().getWordTypes());
            newHostedProviders.setGraphBuilderPlugins(graphBuilderConfig.getPlugins());
            graalFeature.initializeRuntimeCompilationConfiguration(newHostedProviders, graphBuilderConfig, this::includeCallee, this::deoptimizeOnException);
            for (ResolvedJavaMethod method2 : partialEvaluator.getCompilationRootMethods()) {
                graalFeature.prepareMethodForRuntimeCompilation(method2, config);
            }
            this.initializeMethodBlacklist((MetaAccessProvider)config.getMetaAccess());
            for (ResolvedJavaMethod method2 : truffleRuntime.getAnyFrameMethod()) {
                graalFeature.requireFrameInformationForMethod(method2);
                config.registerAsCompiled((AnalysisMethod)method2);
            }
        }
        this.firstAnalysisRun = true;
    }

    private static void registerTruffleOptions(FeatureImpl.BeforeAnalysisAccessImpl config) {
        for (Field field : SharedTruffleCompilerOptions.class.getDeclaredFields()) {
            if (!OptionKey.class.isAssignableFrom(field.getType())) continue;
            config.registerAsAccessed(field);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.firstAnalysisRun) {
            this.firstAnalysisRun = false;
            TruffleFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "preInitializeEngine", Collections.emptyList(), new Object[0]);
            access.requireAnalysisIteration();
        }
    }

    private static void registerKnownTruffleFields(FeatureImpl.BeforeAnalysisAccessImpl config, KnownTruffleTypes knownTruffleFields) {
        for (Class<?> klass = knownTruffleFields.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                try {
                    Object value = field.get(knownTruffleFields);
                    if (value == null || !(value instanceof ResolvedJavaField)) continue;
                    config.registerAsAccessed((AnalysisField)value);
                }
                catch (IllegalAccessException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
            }
        }
    }

    private boolean includeCallee(GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        return this.includeCallee((ResolvedJavaMethod)calleeNode.getImplementationMethod(), calleeNode, implementationMethods);
    }

    private boolean includeCallee(ResolvedJavaMethod implementationMethod, GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        if (implementationMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
            return false;
        }
        if (implementationMethod.getAnnotation(NeverInline.class) != null) {
            return false;
        }
        if (implementationMethod.getAnnotation(TruffleCallBoundary.class) != null) {
            return false;
        }
        if (calleeNode != null && implementationMethods.size() > 4 && this.isBlacklisted((ResolvedJavaMethod)calleeNode.getTargetMethod())) {
            this.blacklistViolations.add(new GraalFeature.CallTreeNode((ResolvedJavaMethod)calleeNode.getTargetMethod(), (ResolvedJavaMethod)calleeNode.getTargetMethod(), calleeNode.getParent(), calleeNode.getLevel(), calleeNode.getSourceReference()));
            return false;
        }
        if (this.isBlacklisted(implementationMethod)) {
            if (calleeNode != null) {
                this.blacklistViolations.add(calleeNode);
            }
            return false;
        }
        if (this.warnMethods.contains(implementationMethod) && calleeNode != null) {
            this.warnViolations.add(calleeNode);
        }
        return true;
    }

    private boolean isBlacklisted(ResolvedJavaMethod method) {
        if (method.isSynchronized() && method.getName().equals("fillInStackTrace")) {
            return true;
        }
        return this.blacklistMethods.contains(method);
    }

    private boolean deoptimizeOnException(ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)method.getAnnotation(CompilerDirectives.TruffleBoundary.class);
        return truffleBoundary != null && !truffleBoundary.throwsControlFlowException() && truffleBoundary.transferToInterpreterOnException();
    }

    private void initializeMethodBlacklist(MetaAccessProvider metaAccess) {
        this.blacklistMethod(metaAccess, Object.class, "clone", new Class[0]);
        this.blacklistMethod(metaAccess, Object.class, "equals", Object.class);
        this.blacklistMethod(metaAccess, Object.class, "hashCode", new Class[0]);
        this.blacklistMethod(metaAccess, Object.class, "toString", new Class[0]);
        this.blacklistMethod(metaAccess, String.class, "valueOf", Object.class);
        this.blacklistMethod(metaAccess, String.class, "getBytes", new Class[0]);
        this.blacklistMethod(metaAccess, Throwable.class, "initCause", Throwable.class);
        this.blacklistMethod(metaAccess, System.class, "getProperty", String.class);
        this.blacklistAllMethods(metaAccess, AssertionError.class);
        this.blacklistAllMethods(metaAccess, BigInteger.class);
        this.blacklistAllMethods(metaAccess, BigDecimal.class);
        this.blacklistAllMethods(metaAccess, Comparable.class);
        this.blacklistAllMethods(metaAccess, Comparator.class);
        this.blacklistAllMethods(metaAccess, Collection.class);
        this.blacklistAllMethods(metaAccess, List.class);
        this.blacklistAllMethods(metaAccess, Set.class);
        this.blacklistAllMethods(metaAccess, Map.class);
        this.blacklistAllMethods(metaAccess, Map.Entry.class);
        this.blacklistAllMethods(metaAccess, TreeMap.class);
        this.blacklistAllMethods(metaAccess, HashMap.class);
        this.blacklistAllMethods(metaAccess, ConcurrentHashMap.class);
        this.blacklistAllMethods(metaAccess, WeakHashMap.class);
        this.blacklistAllMethods(metaAccess, IdentityHashMap.class);
        this.blacklistAllMethods(metaAccess, Iterable.class);
        this.blacklistAllMethods(metaAccess, Iterator.class);
        this.blacklistAllMethods(metaAccess, ListIterator.class);
        this.blacklistAllMethods(metaAccess, ReentrantLock.class);
        this.blacklistAllMethods(metaAccess, StringBuffer.class);
        this.blacklistAllMethods(metaAccess, Vector.class);
        this.blacklistAllMethods(metaAccess, Hashtable.class);
        this.warnAllMethods(metaAccess, JavaStackWalker.class);
        this.warnAllMethods(metaAccess, Deoptimizer.class);
        this.warnAllMethods(metaAccess, Heap.getHeap().getClass());
    }

    private void blacklistAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private void blacklistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            this.blacklistMethods.add(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void warnAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotations().length != 0 || ((Executable)method).getName().startsWith("get") || ((Executable)method).getName().startsWith("set")) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (executable.getAnnotations().length != 0) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private static int blacklistViolationComparator(GraalFeature.CallTreeNode n1, GraalFeature.CallTreeNode n2) {
        int result = n1.getTargetMethod().format("%H.%n(%p)").compareTo(n2.getTargetMethod().format("%H.%n(%p)"));
        if (result == 0) {
            result = n1.getSourceReference().compareTo(n2.getSourceReference());
        }
        return result;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        Optional<HostedType> optionalFrameType;
        Object cur;
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)config;
        if (GraalFeature.Options.PrintRuntimeCompileMethods.getValue().booleanValue() && this.blacklistViolations.size() > 0) {
            System.out.println();
            System.out.println("=== Found " + this.blacklistViolations.size() + " compilation blacklist violations ===");
            System.out.println();
            for (GraalFeature.CallTreeNode node : this.blacklistViolations) {
                System.out.println("Blacklisted method");
                System.out.println(node.getImplementationMethod().format("  %H.%n(%p)"));
                System.out.println("called from");
                for (cur = node; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
        }
        if (this.warnViolations.size() > 0) {
            Object printNode = null;
            int printLength = Integer.MAX_VALUE;
            cur = this.warnViolations.iterator();
            while (cur.hasNext()) {
                GraalFeature.CallTreeNode warnNode = cur.next();
                int warnLength = 0;
                for (GraalFeature.CallTreeNode cur2 = warnNode; cur2 != null; cur2 = cur2.getParent()) {
                    ++warnLength;
                }
                if (warnLength >= printLength) continue;
                printNode = warnNode;
                printLength = warnLength;
            }
            System.out.println("WARNING: suspicious method reachable for runtime compilation: " + ((GraalFeature.CallTreeNode)printNode).getImplementationMethod().format("%H.%n(%p)"));
            System.out.println("Check the complete tree of reachable methods using the option " + GraalFeature.Options.PrintRuntimeCompileMethods.getDescriptor().getFieldName());
            System.out.println("Suspicious method is called from");
            for (cur = printNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
            }
        }
        if (this.neverPartOfCompilationViolations.size() > 0) {
            System.out.println("ERROR: CompilerAsserts.neverPartOfCompilation reachable for runtime compilation from " + this.neverPartOfCompilationViolations.size() + " places:");
            for (GraalFeature.CallTreeNode neverPartOfCompilationNode : this.neverPartOfCompilationViolations) {
                System.out.println("called from");
                for (cur = neverPartOfCompilationNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
            throw VMError.shouldNotReachHere("CompilerAsserts.neverPartOfCompilation reachable for runtime compilation");
        }
        if (Options.TruffleCheckFrameImplementation.getValue().booleanValue() && TruffleFeature.useTruffleCompiler() && (optionalFrameType = access.getMetaAccess().optionalLookupJavaType(Frame.class)).isPresent()) {
            HostedType frameType = optionalFrameType.get();
            HashSet<HostedType> implementations = new HashSet<HostedType>();
            TruffleFeature.collectImplementations(frameType, implementations);
            if (implementations.size() > 1) {
                throw UserError.abort("More than one implementation of " + Frame.class.getTypeName() + " found. For performance reasons, Truffle languages must not provide new implementations, and instead only use the single implementation provided by the Truffle runtime. To disable this check, add " + SubstrateOptionsParser.commandArgument(Options.TruffleCheckFrameImplementation, "-") + " to the native-image command line. Found classes: " + implementations.stream().map(m -> m.toJavaName(true)).collect(Collectors.joining(", ")));
            }
            assert (implementations.size() == 0 || implementations.iterator().next() == frameType.getSingleImplementor());
        }
    }

    private static void collectImplementations(HostedType type, Set<HostedType> implementations) {
        for (HostedType subType : type.getSubTypes()) {
            if (!subType.isAbstract()) {
                implementations.add(subType);
            }
            TruffleFeature.collectImplementations(subType, implementations);
        }
    }

    static class TruffleParsingInlineInvokePlugin
    implements InlineInvokePlugin {
        private final Replacements replacements;
        private final InvocationPlugins invocationPlugins;
        private final PartialEvaluator partialEvaluator;
        private final Predicate<ResolvedJavaMethod> includeMethodPredicate;

        TruffleParsingInlineInvokePlugin(Replacements replacements, InvocationPlugins invocationPlugins, PartialEvaluator partialEvaluator, Predicate<ResolvedJavaMethod> includeMethodPredicate) {
            this.replacements = replacements;
            this.invocationPlugins = invocationPlugins;
            this.partialEvaluator = partialEvaluator;
            this.includeMethodPredicate = includeMethodPredicate;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (original.getAnnotation(NeverInline.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.invocationPlugins.lookupInvocation(original) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getAnnotation(ExplodeLoop.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.replacements.hasSubstitution(original, builder.bci())) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            for (ResolvedJavaMethod m : this.partialEvaluator.getNeverInlineMethods()) {
                if (!original.equals(m)) continue;
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            StructuredGraph graph = ((AnalysisMethod)original).getTypeFlow().getGraph();
            if (graph != null && original.getCode() != null && this.includeMethodPredicate.test(original) && InliningUtilities.isTrivialMethod(graph) && builder.getDepth() < (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton())) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    public static class Support {
        public SubstrateOptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
            return new SubstrateOptimizedCallTarget(sourceCallTarget, rootNode);
        }

        public SubstratePartialEvaluator createPartialEvaluator(Providers providers, GraphBuilderConfiguration configForRoot, SnippetReflectionProvider snippetReflection, Architecture architecture) {
            return new SubstratePartialEvaluator(providers, configForRoot, snippetReflection, architecture);
        }

        public void registerInterpreterEntryMethodsAsCompiled(PartialEvaluator partialEvaluator, Feature.BeforeAnalysisAccess access) {
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleFeature.class);
        }
    }

    public static class Options {
        @Option(help={"Print a warning message and stack trace when CompilerAsserts.neverPartOfCompilation is reachable"})
        public static final HostedOptionKey<Boolean> TruffleCheckNeverPartOfCompilation = new HostedOptionKey<Boolean>(false);
        @Option(help={"Enforce that the Truffle runtime provides the only implementation of Frame"})
        public static final HostedOptionKey<Boolean> TruffleCheckFrameImplementation = new HostedOptionKey<Boolean>(true);
        @Option(help={"Inline trivial methods in Truffle graphs during native image generation"})
        public static final HostedOptionKey<Boolean> TruffleInlineDuringParsing = new HostedOptionKey<Boolean>(true);
    }
}

