/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class Isolates {
    public static final String IMAGE_HEAP_BEGIN_SYMBOL_NAME = "__svm_heap_begin";
    public static final String IMAGE_HEAP_END_SYMBOL_NAME = "__svm_heap_end";
    public static final String IMAGE_HEAP_RELOCATABLE_BEGIN_SYMBOL_NAME = "__svm_heap_relocatable_begin";
    public static final String IMAGE_HEAP_RELOCATABLE_FIRST_RELOC_POINTER_NAME = "__svm_heap_relocatable_first_reloc_pointer";
    public static final String IMAGE_HEAP_RELOCATABLE_END_SYMBOL_NAME = "__svm_heap_relocatable_end";
    public static final String IMAGE_HEAP_WRITABLE_BEGIN_SYMBOL_NAME = "__svm_heap_writable_begin";
    public static final String IMAGE_HEAP_WRITABLE_END_SYMBOL_NAME = "__svm_heap_writable_end";
    public static final CGlobalData<Word> IMAGE_HEAP_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_END = CGlobalDataFactory.forSymbol("__svm_heap_end");
    public static final CGlobalData<Word> IMAGE_HEAP_RELOCATABLE_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_relocatable_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_RELOCATABLE_FIRST_RELOC_POINTER = CGlobalDataFactory.forSymbol("__svm_heap_relocatable_first_reloc_pointer");
    public static final CGlobalData<Word> IMAGE_HEAP_RELOCATABLE_END = CGlobalDataFactory.forSymbol("__svm_heap_relocatable_end");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_writable_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_END = CGlobalDataFactory.forSymbol("__svm_heap_writable_end");

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int checkSanity(Isolate isolate) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return isolate.isNull() ? 2 : 0;
        }
        return isolate.equal((ComparableWord)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL) ? 0 : 5;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int create(WordPointer isolatePointer, CEntryPointCreateIsolateParameters parameters) {
        int result = CommittedMemoryProvider.get().initialize(isolatePointer, parameters);
        if (result == 0 && Isolates.checkSanity((Isolate)isolatePointer.read()) != 0) {
            result = 1;
            isolatePointer.write((WordBase)WordFactory.nullPointer());
        }
        return result;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static PointerBase getHeapBase(Isolate isolate) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return IMAGE_HEAP_BEGIN.get();
        }
        return isolate;
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public static int tearDownCurrent() {
        return CommittedMemoryProvider.get().tearDown();
    }
}

