/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.util.TimeUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import sun.management.Util;

final class GarbageCollectorManagementFactory {
    private List<GarbageCollectorMXBean> gcBeanList;

    GarbageCollectorManagementFactory() {
        ArrayList<GarbageCollectorMXBean> newList = new ArrayList<GarbageCollectorMXBean>();
        newList.add(new IncrementalGarbageCollectorMXBean());
        newList.add(new CompleteGarbageCollectorMXBean());
        this.gcBeanList = newList;
    }

    List<GarbageCollectorMXBean> getGCBeanList() {
        return this.gcBeanList;
    }

    private static final class CompleteGarbageCollectorMXBean
    implements GarbageCollectorMXBean {
        private CompleteGarbageCollectorMXBean() {
        }

        @Override
        public long getCollectionCount() {
            return HeapImpl.getHeapImpl().getGCImpl().getAccounting().getCompleteCollectionCount();
        }

        @Override
        public long getCollectionTime() {
            long nanos = HeapImpl.getHeapImpl().getGCImpl().getAccounting().getCompleteCollectionTotalNanos();
            return TimeUtils.roundNanosToMillis(nanos);
        }

        @Override
        public String[] getMemoryPoolNames() {
            return new String[]{"young generation space", "old generation space"};
        }

        @Override
        public String getName() {
            return "complete scavenger";
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ObjectName getObjectName() {
            return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
        }
    }

    private static final class IncrementalGarbageCollectorMXBean
    implements GarbageCollectorMXBean {
        private IncrementalGarbageCollectorMXBean() {
        }

        @Override
        public long getCollectionCount() {
            return HeapImpl.getHeapImpl().getGCImpl().getAccounting().getIncrementalCollectionCount();
        }

        @Override
        public long getCollectionTime() {
            long nanos = HeapImpl.getHeapImpl().getGCImpl().getAccounting().getIncrementalCollectionTotalNanos();
            return TimeUtils.roundNanosToMillis(nanos);
        }

        @Override
        public String[] getMemoryPoolNames() {
            return new String[]{"young generation space"};
        }

        @Override
        public String getName() {
            return "young generation scavenger";
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ObjectName getObjectName() {
            return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
        }
    }
}

