/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.nodes.UnreachableNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckImpl;
import com.oracle.svm.core.graal.snippets.StackOverflowCheckNode;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

final class StackOverflowCheckSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_STACK_OVERFLOW_ERROR = SnippetRuntime.findForeignCall(StackOverflowCheckSnippets.class, "throwCachedStackOverflowError", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_STACK_OVERFLOW_ERROR = SnippetRuntime.findForeignCall(StackOverflowCheckSnippets.class, "throwNewStackOverflowError", true, new LocationIdentity[0]);
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{THROW_CACHED_STACK_OVERFLOW_ERROR, THROW_NEW_STACK_OVERFLOW_ERROR};
    private static final StackOverflowError CACHED_STACK_OVERFLOW_ERROR = new StackOverflowError("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;

    @Snippet
    private static void stackOverflowCheckSnippet(@Snippet.ConstantParameter boolean mustNotAllocate) {
        UnsignedWord stackBoundary = StackOverflowCheckImpl.stackBoundaryTL.get();
        if (KnownIntrinsics.readStackPointer().belowOrEqual(stackBoundary)) {
            if (mustNotAllocate) {
                StackOverflowCheckSnippets.callSlowPath(THROW_CACHED_STACK_OVERFLOW_ERROR);
            } else {
                StackOverflowCheckSnippets.callSlowPath(THROW_NEW_STACK_OVERFLOW_ERROR);
            }
            throw UnreachableNode.unreachable();
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPath(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Uninterruptible(reason="Must not have a stack overflow check: we are here because the stack overflow check failed.")
    @SubstrateForeignCallTarget
    private static void throwCachedStackOverflowError() {
        VMError.guarantee(StackOverflowCheckImpl.yellowZoneStateTL.get() != 0, "Stack boundary for the current thread not yet initialized. Only uninterruptible code with no stack overflow checks can run at this point.");
        throw CACHED_STACK_OVERFLOW_ERROR;
    }

    @Uninterruptible(reason="Must not have a stack overflow check: we are here because the stack overflow check failed.")
    @SubstrateForeignCallTarget
    private static void throwNewStackOverflowError() {
        StackOverflowError error;
        int state = StackOverflowCheckImpl.yellowZoneStateTL.get();
        VMError.guarantee(state != 0, "Stack boundary for the current thread not yet initialized. Only uninterruptible code with no stack overflow checks can run at this point.");
        if (state > 1 || Heap.getHeap().isAllocationDisallowed()) {
            error = CACHED_STACK_OVERFLOW_ERROR;
        } else {
            try {
                StackOverflowCheck.singleton().makeYellowZoneAvailable();
                error = StackOverflowCheckSnippets.newStackOverflowError();
            }
            finally {
                StackOverflowCheck.singleton().protectYellowZone();
            }
        }
        throw error;
    }

    @Uninterruptible(reason="Allow allocation now that yellow zone is available for new stack frames", calleeMustBe=false)
    @RestrictHeapAccess(reason="Allow allocation now that yellow zone is available for new stack frames", overridesCallers=true, access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static StackOverflowError newStackOverflowError() {
        return StackOverflowCheckSnippets.newStackOverflowError0();
    }

    private static StackOverflowError newStackOverflowError0() {
        return new StackOverflowError();
    }

    StackOverflowCheckSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate) {
        super(options, factories, providers, snippetReflection);
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        lowerings.put(StackOverflowCheckNode.class, new StackOverflowCheckLowering());
    }

    final class StackOverflowCheckLowering
    implements NodeLoweringProvider<StackOverflowCheckNode> {
        private final SnippetTemplate.SnippetInfo stackOverflowCheck;

        StackOverflowCheckLowering() {
            this.stackOverflowCheck = StackOverflowCheckSnippets.this.snippet(StackOverflowCheckSnippets.class, "stackOverflowCheckSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(StackOverflowCheckNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.stackOverflowCheck, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.addConst("mustNotAllocate", (Object)(StackOverflowCheckSnippets.this.mustNotAllocatePredicate != null && StackOverflowCheckSnippets.this.mustNotAllocatePredicate.test(node.graph().method()) ? 1 : 0));
            StackOverflowCheckSnippets.this.template((ValueNode)node, args).instantiate(StackOverflowCheckSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

