/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.Jvm;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=Runtime.class)
final class Target_java_lang_Runtime {
    Target_java_lang_Runtime() {
    }

    @Substitute
    public void loadLibrary(String libname) {
        this.loadLibrary0(null, libname);
    }

    @Substitute
    public void load(String filename) {
        this.load0(null, filename);
    }

    @Substitute
    public void runFinalization() {
    }

    @Substitute
    @Platforms(value={Platform.LINUX_JNI.class, Platform.DARWIN_JNI.class, Platform.WINDOWS.class})
    private int availableProcessors() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return Jvm.JVM_ActiveProcessorCount();
        }
        return 1;
    }

    @Alias
    synchronized native void loadLibrary0(Class<?> var1, String var2);

    @Alias
    synchronized native void load0(Class<?> var1, String var2);
}

