/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
@AutomaticFeature
class IgnoreSIGPIPEFeature
implements Feature {
    IgnoreSIGPIPEFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(new Runnable(){

            @Override
            public void run() {
                Signal.SignalDispatcher signalResult = Signal.signal(Signal.SignalEnum.SIGPIPE.getCValue(), Signal.SIG_IGN());
                VMError.guarantee(signalResult != Signal.SIG_ERR(), "IgnoreSIGPIPEFeature.run: Could not ignore SIGPIPE");
            }
        });
    }
}

