/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.headers.ZLib;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

final class Util_java_util_zip_Deflater_JDK11OrLater {
    Util_java_util_zip_Deflater_JDK11OrLater() {
    }

    static long doDeflate(long addr, CCharPointer input, int inputLen, CCharPointer output, int outputLen, int flush, int params) {
        ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
        int finished = 0;
        int setParams = params & 1;
        strm.set_next_in(input);
        strm.set_next_out(output);
        strm.set_avail_in(inputLen);
        strm.set_avail_out(outputLen);
        if (setParams != 0) {
            int level = params >> 3;
            int strategy = params >> 1 & 3;
            int res = ZLib.deflateParams(strm, level, strategy);
            if (res != ZLib.Z_OK() && res != ZLib.Z_BUF_ERROR()) {
                throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            if (res == ZLib.Z_OK()) {
                setParams = 0;
            }
        } else {
            int res = ZLib.deflate(strm, flush);
            if (res != ZLib.Z_OK() && res != ZLib.Z_STREAM_END() && res != ZLib.Z_BUF_ERROR()) {
                throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            if (res == ZLib.Z_STREAM_END()) {
                finished = 1;
            }
        }
        int inputUsed = inputLen - strm.avail_in();
        int outputUsed = outputLen - strm.avail_out();
        return (long)inputUsed | (long)outputUsed << 31 | (long)finished << 62 | (long)setParams << 63;
    }
}

