/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Time;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

@CContext(value=PosixDirectives.class)
@Platforms(value={Platform.DARWIN_AND_JNI.class, Platform.LINUX_AND_JNI.class})
@CLibrary(value="pthread")
public class Pthread {
    @CConstant
    public static native int PTHREAD_CREATE_DETACHED();

    @CConstant
    public static native UnsignedWord PTHREAD_STACK_MIN();

    @CConstant
    public static native int PTHREAD_MUTEX_NORMAL();

    @CConstant
    public static native int PTHREAD_MUTEX_RECURSIVE();

    @CConstant
    public static native int PTHREAD_MUTEX_ERRORCHECK();

    @CConstant
    public static native int PTHREAD_MUTEX_DEFAULT();

    @CConstant
    public static native int PTHREAD_PRIO_NONE();

    @CConstant
    public static native int PTHREAD_PRIO_INHERIT();

    @CConstant
    public static native int PTHREAD_PRIO_PROTECT();

    @CConstant
    public static native int PTHREAD_INHERIT_SCHED();

    @CConstant
    public static native int PTHREAD_EXPLICIT_SCHED();

    @CConstant
    public static native int PTHREAD_SCOPE_SYSTEM();

    @CConstant
    public static native int PTHREAD_SCOPE_PROCESS();

    @CConstant
    public static native int PTHREAD_PROCESS_PRIVATE();

    @CConstant
    public static native int PTHREAD_PROCESS_SHARED();

    @CConstant
    public static native int PTHREAD_CANCEL_ENABLE();

    @CConstant
    public static native int PTHREAD_CANCEL_DISABLE();

    @CConstant
    public static native int PTHREAD_CANCEL_DEFERRED();

    @CConstant
    public static native int PTHREAD_CANCEL_ASYNCHRONOUS();

    @CConstant
    public static native WordBase PTHREAD_CANCELED();

    @CFunction
    public static native int pthread_create(pthread_tPointer var0, pthread_attr_t var1, WordBase var2, WordBase var3);

    @CFunction
    public static native void pthread_exit(PointerBase var0);

    @CFunction
    public static native int pthread_join(pthread_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_tryjoin_np(pthread_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_timedjoin_np(pthread_t var0, WordPointer var1, Time.timespec var2);

    @CFunction
    public static native int pthread_detach(pthread_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static native pthread_t pthread_self();

    @CFunction
    public static native int pthread_equal(pthread_t var0, pthread_t var1);

    @CFunction
    public static native int pthread_attr_init(pthread_attr_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_destroy(pthread_attr_t var0);

    @CFunction
    public static native int pthread_attr_getdetachstate(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_setdetachstate(pthread_attr_t var0, int var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_getguardsize(pthread_attr_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_attr_setguardsize(pthread_attr_t var0, UnsignedWord var1);

    @CFunction
    public static native int pthread_attr_getschedparam(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_setschedparam(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_getschedpolicy(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_setschedpolicy(pthread_attr_t var0, int var1);

    @CFunction
    public static native int pthread_attr_getinheritsched(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_setinheritsched(pthread_attr_t var0, int var1);

    @CFunction
    public static native int pthread_attr_getscope(pthread_attr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_attr_setscope(pthread_attr_t var0, int var1);

    @CFunction
    public static native int pthread_attr_getstackaddr(pthread_attr_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_attr_setstackaddr(pthread_attr_t var0, PointerBase var1);

    @CFunction
    public static native int pthread_attr_getstacksize(pthread_attr_t var0, WordPointer var1);

    @CFunction
    public static native int pthread_attr_setstacksize(pthread_attr_t var0, UnsignedWord var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_attr_getstack(pthread_attr_t var0, WordPointer var1, WordPointer var2);

    @CFunction
    public static native int pthread_attr_setstack(pthread_attr_t var0, PointerBase var1, UnsignedWord var2);

    @CFunction
    public static native int pthread_attr_setaffinity_np(pthread_attr_t var0, UnsignedWord var1, PointerBase var2);

    @CFunction
    public static native int pthread_attr_getaffinity_np(pthread_attr_t var0, UnsignedWord var1, PointerBase var2);

    @CFunction
    public static native int pthread_getattr_default_np(pthread_attr_t var0);

    @CFunction
    public static native int pthread_setattr_default_np(pthread_attr_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_getattr_np(pthread_t var0, pthread_attr_t var1);

    @CFunction
    public static native int pthread_setschedparam(pthread_t var0, int var1, CIntPointer var2);

    @CFunction
    public static native int pthread_getschedparam(pthread_t var0, CIntPointer var1, CIntPointer var2);

    @CFunction
    public static native int pthread_setschedprio(pthread_t var0, int var1);

    @CFunction
    public static native int pthread_getconcurrency();

    @CFunction
    public static native int pthread_setconcurrency(int var0);

    @CFunction
    public static native int pthread_yield();

    @CFunction
    public static native int pthread_setaffinity_np(pthread_t var0, UnsignedWord var1, PointerBase var2);

    @CFunction
    public static native int pthread_getaffinity_np(pthread_t var0, UnsignedWord var1, PointerBase var2);

    @CFunction
    public static native int pthread_once(CIntPointer var0, PointerBase var1);

    @CFunction
    public static native int pthread_setcancelstate(int var0, CIntPointer var1);

    @CFunction
    public static native int pthread_setcanceltype(int var0, CIntPointer var1);

    @CFunction
    public static native int pthread_cancel(pthread_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native void pthread_testcancel();

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_init(pthread_mutex_t var0, pthread_mutexattr_t var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_destroy(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.TO_NATIVE)
    public static native int pthread_mutex_trylock(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.TO_NATIVE)
    public static native int pthread_mutex_lock(pthread_mutex_t var0);

    @CFunction(value="pthread_mutex_lock", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_lock_no_transition(pthread_mutex_t var0);

    @CFunction(transition=CFunction.Transition.TO_NATIVE)
    public static native int pthread_mutex_timedlock(pthread_mutex_t var0, Time.timespec var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_mutex_unlock(pthread_mutex_t var0);

    @CFunction
    public static native int pthread_mutex_getprioceiling(pthread_mutex_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutex_setprioceiling(pthread_mutex_t var0, int var1, CIntPointer var2);

    @CFunction
    public static native int pthread_mutex_consistent(pthread_mutex_t var0);

    @CFunction
    public static native int pthread_mutex_consistent_np(pthread_mutex_t var0);

    @CFunction
    public static native int pthread_mutexattr_init(pthread_mutexattr_t var0);

    @CFunction
    public static native int pthread_mutexattr_destroy(pthread_mutexattr_t var0);

    @CFunction
    public static native int pthread_mutexattr_getpshared(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_setpshared(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_mutexattr_gettype(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_settype(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_mutexattr_getprotocol(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_setprotocol(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_mutexattr_getprioceiling(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_setprioceiling(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_mutexattr_getrobust(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_getrobust_np(pthread_mutexattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_mutexattr_setrobust(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_mutexattr_setrobust_np(pthread_mutexattr_t var0, int var1);

    @CFunction
    public static native int pthread_rwlock_init(pthread_rwlock_t var0, pthread_rwlockattr_t var1);

    @CFunction
    public static native int pthread_rwlock_destroy(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlock_rdlock(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlock_tryrdlock(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlock_timedrdlock(pthread_rwlock_t var0, Time.timespec var1);

    @CFunction
    public static native int pthread_rwlock_wrlock(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlock_trywrlock(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlock_timedwrlock(pthread_rwlock_t var0, Time.timespec var1);

    @CFunction
    public static native int pthread_rwlock_unlock(pthread_rwlock_t var0);

    @CFunction
    public static native int pthread_rwlockattr_init(pthread_rwlockattr_t var0);

    @CFunction
    public static native int pthread_rwlockattr_destroy(pthread_rwlockattr_t var0);

    @CFunction
    public static native int pthread_rwlockattr_getpshared(pthread_rwlockattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_rwlockattr_setpshared(pthread_rwlockattr_t var0, int var1);

    @CFunction
    public static native int pthread_rwlockattr_getkind_np(pthread_rwlockattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_rwlockattr_setkind_np(pthread_rwlockattr_t var0, int var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_init(pthread_cond_t var0, pthread_condattr_t var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_destroy(pthread_cond_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_signal(pthread_cond_t var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_broadcast(pthread_cond_t var0);

    @CFunction
    public static native int pthread_cond_wait(pthread_cond_t var0, pthread_mutex_t var1);

    @CFunction(value="pthread_cond_wait", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_wait_no_transition(pthread_cond_t var0, pthread_mutex_t var1);

    @CFunction
    public static native int pthread_cond_timedwait(pthread_cond_t var0, pthread_mutex_t var1, Time.timespec var2);

    @CFunction(value="pthread_cond_timedwait", transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_cond_timedwait_no_transition(pthread_cond_t var0, pthread_mutex_t var1, Time.timespec var2);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_condattr_init(pthread_condattr_t var0);

    @CFunction
    public static native int pthread_condattr_destroy(pthread_condattr_t var0);

    @CFunction
    public static native int pthread_condattr_getpshared(pthread_condattr_t var0, CIntPointer var1);

    @CFunction
    public static native int pthread_condattr_setpshared(pthread_condattr_t var0, int var1);

    @CFunction
    public static native int pthread_condattr_getclock(pthread_condattr_t var0, CIntPointer var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_condattr_setclock(pthread_condattr_t var0, int var1);

    @CFunction
    public static native int pthread_spin_init(CIntPointer var0, int var1);

    @CFunction
    public static native int pthread_spin_destroy(CIntPointer var0);

    @CFunction
    public static native int pthread_spin_lock(CIntPointer var0);

    @CFunction
    public static native int pthread_spin_trylock(CIntPointer var0);

    @CFunction
    public static native int pthread_spin_unlock(CIntPointer var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_key_create(CIntPointer var0, PointerBase var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_key_delete(int var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native <T extends WordBase> T pthread_getspecific(int var0);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    public static native int pthread_setspecific(int var0, WordBase var1);

    @CFunction
    public static native int pthread_getcpuclockid(pthread_t var0, PointerBase var1);

    @CFunction
    public static native int pthread_atfork(PointerBase var0, PointerBase var1, PointerBase var2);

    @CFunction
    public static native int pthread_kill(pthread_t var0, Signal.SignalEnum var1);

    @CStruct
    public static interface pthread_rwlockattr_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_rwlock_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_condattr_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_cond_t
    extends PointerBase {
    }

    public static interface pthread_mutexattr_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_mutex_t
    extends PointerBase {
    }

    @CStruct
    public static interface pthread_attr_t
    extends PointerBase {
    }

    @CPointerTo(nameOfCType="pthread_t")
    public static interface pthread_tPointer
    extends PointerBase {
        public pthread_t read();
    }

    public static interface pthread_t
    extends ComparableWord {
    }
}

