/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.linux.LinuxEPoll;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.RuntimeClassInitialization;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class})
public final class LinuxNIOSubstitutions {
    private LinuxNIOSubstitutions() {
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.nio.ch.EPollPort")
    static final class Target_sun_nio_ch_EPollPort {
        Target_sun_nio_ch_EPollPort() {
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void socketpair(int[] sv) throws IOException {
            CIntPointer sp = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            if (Socket.socketpair(Socket.PF_UNIX(), Socket.SOCK_STREAM(), 0, sp) == -1) {
                throw new IOException("socketpair failed");
            }
            CIntPointer res = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            res.write(0, sp.read(0));
            res.write(1, sp.read(1));
            sv[0] = res.read(0);
            sv[1] = res.read(1);
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void interrupt(int fd) throws IOException {
            int res;
            CIntPointer buf = (CIntPointer)StackValue.get(CIntPointer.class);
            buf.write(0, 1);
            while ((res = (int)Unistd.write(fd, (PointerBase)buf, WordFactory.unsigned((int)1)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("write failed");
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void drain1(int fd) throws IOException {
            int res;
            CCharPointer buf = (CCharPointer)StackValue.get(CCharPointer.class);
            while ((res = (int)Unistd.read(fd, (PointerBase)buf, WordFactory.unsigned((int)1)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("drain1 failed");
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void close0(int fd) {
            int res;
            while ((res = Unistd.close(fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }
    }

    @AutomaticFeature
    static final class EPollArrayWrapperFeature
    implements Feature {
        EPollArrayWrapperFeature() {
        }

        public void duringSetup(Feature.DuringSetupAccess access) {
            if (JavaVersionUtil.Java8OrEarlier) {
                RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("sun.nio.ch.EPollArrayWrapper")});
            }
        }
    }

    static final class Util_sun_nio_ch_EPollArrayWrapper {
        Util_sun_nio_ch_EPollArrayWrapper() {
        }

        static int iepoll(int epfd, LinuxEPoll.epoll_event events, int numfds, long timeout) {
            int res;
            long remaining = timeout;
            Time.timeval t = (Time.timeval)StackValue.get(Time.timeval.class);
            Time.gettimeofday(t, (Time.timezone)WordFactory.nullPointer());
            long start = t.tv_sec() * 1000L + t.tv_usec() / 1000L;
            while ((res = LinuxEPoll.epoll_wait(epfd, events, numfds, (int)timeout)) < 0 && Errno.errno() == Errno.EINTR()) {
                if (remaining < 0L) continue;
                Time.gettimeofday(t, (Time.timezone)WordFactory.nullPointer());
                long now = t.tv_sec() * 1000L + t.tv_usec() / 1000L;
                long diff = now - start;
                if (diff < 0L || (remaining -= diff) <= 0L) {
                    return 0;
                }
                start = now;
            }
            return res;
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.nio.ch.EPollArrayWrapper", onlyWith={JDK8OrEarlier.class})
    static final class Target_sun_nio_ch_EPollArrayWrapper {
        Target_sun_nio_ch_EPollArrayWrapper() {
        }

        @Substitute
        static void init() {
        }

        @Substitute
        int epollCreate() throws IOException {
            int epfd = LinuxEPoll.epoll_create(256);
            if (epfd < 0) {
                throw new IOException("epoll_create failed");
            }
            return epfd;
        }

        @Substitute
        static int sizeofEPollEvent() {
            return SizeOf.get(LinuxEPoll.epoll_event.class);
        }

        @Substitute
        static int offsetofData() {
            return LinuxEPoll.epoll_event.offsetOfdata();
        }

        @Substitute
        void epollCtl(int epfd, int opcode, int fd, int events) throws IOException {
            int res;
            LinuxEPoll.epoll_event event = (LinuxEPoll.epoll_event)StackValue.get(LinuxEPoll.epoll_event.class);
            event.events(events);
            event.addressOfdata().fd(fd);
            while ((res = LinuxEPoll.epoll_ctl(epfd, opcode, fd, event)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0 && Errno.errno() != Errno.EBADF() && Errno.errno() != Errno.ENOENT() && Errno.errno() != Errno.EPERM()) {
                throw new IOException("epoll_ctl failed");
            }
        }

        @Substitute
        int epollWait(long address, int numfds, long timeout, int epfd) throws IOException {
            int res;
            LinuxEPoll.epoll_event events = (LinuxEPoll.epoll_event)WordFactory.pointer((long)address);
            if (timeout <= 0L) {
                while ((res = LinuxEPoll.epoll_wait(epfd, events, numfds, (int)timeout)) == -1 && Errno.errno() == Errno.EINTR()) {
                }
            } else {
                res = Util_sun_nio_ch_EPollArrayWrapper.iepoll(epfd, events, numfds, timeout);
            }
            if (res < 0) {
                throw new IOException("epoll_wait failed");
            }
            return res;
        }

        @Substitute
        static void interrupt(int fd) throws IOException {
            CIntPointer fakebuf = (CIntPointer)StackValue.get((int)1, CIntPointer.class);
            fakebuf.write(0, 1);
            if (Unistd.write(fd, (PointerBase)fakebuf, WordFactory.unsigned((int)1)).lessThan(0)) {
                throw new IOException("write to interrupt fd failed");
            }
        }
    }

    @Platforms(value={Platform.LINUX.class})
    @TargetClass(className="sun.nio.ch.EPoll")
    static final class Target_sun_nio_ch_EPoll {
        Target_sun_nio_ch_EPoll() {
        }

        @Substitute
        static int eventSize() {
            return SizeOf.get(LinuxEPoll.epoll_event.class);
        }

        @Substitute
        static int eventsOffset() {
            return LinuxEPoll.epoll_event.offsetOfevents();
        }

        @Substitute
        static int dataOffset() {
            return LinuxEPoll.epoll_event.offsetOfdata();
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int epollCreate() throws IOException {
            int epfd = LinuxEPoll.epoll_create(256);
            if (epfd < 0) {
                throw new IOException("epoll_create failed");
            }
            return epfd;
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int create() throws IOException {
            throw VMError.unsupportedFeature("LinuxNIOSubstitutions.Target_sun_nio_ch_EPoll.create");
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int epollCtl(int epfd, int opcode, int fd, int events) {
            int res;
            LinuxEPoll.epoll_event event = (LinuxEPoll.epoll_event)StackValue.get(LinuxEPoll.epoll_event.class);
            event.events(events);
            event.addressOfdata().fd(fd);
            while ((res = LinuxEPoll.epoll_ctl(epfd, opcode, fd, event)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            return res == 0 ? 0 : Errno.errno();
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int ctl(int epfd, int opcode, int fd, int events) {
            throw VMError.unsupportedFeature("LinuxNIOSubstitutions.Target_sun_nio_ch_EPoll.ctl");
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int epollWait(int epfd, long address, int numfds) throws IOException {
            int res;
            LinuxEPoll.epoll_event events = (LinuxEPoll.epoll_event)WordFactory.pointer((long)address);
            while ((res = LinuxEPoll.epoll_wait(epfd, events, numfds, -1)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("epoll_wait failed");
            }
            return res;
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int wait(int epfd, long address, int numfds, int timeout) throws IOException {
            throw VMError.unsupportedFeature("LinuxNIOSubstitutions.Target_sun_nio_ch_EPoll.wait");
        }
    }
}

