/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.Replaced;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.meta.SubstrateConstantFieldProvider;
import com.oracle.svm.graal.meta.SubstrateConstantReflectionProvider;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateSignature;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.c.function.RelocatedPointer;

public class GraalObjectReplacer
implements Function<Object, Object> {
    private final AnalysisUniverse aUniverse;
    private final AnalysisMetaAccess aMetaAccess;
    private final HashMap<AnalysisMethod, SubstrateMethod> methods = new HashMap();
    private final HashMap<AnalysisField, SubstrateField> fields = new HashMap();
    private final HashMap<FieldLocationIdentity, FieldLocationIdentity> fieldLocationIdentities = new HashMap();
    private final HashMap<AnalysisType, SubstrateType> types = new HashMap();
    private final HashMap<Signature, SubstrateSignature> signatures = new HashMap();
    private final SubstrateMetaAccess sMetaAccess;
    private final SubstrateConstantReflectionProvider sConstantReflectionProvider;
    private final SubstrateConstantFieldProvider sConstantFieldProvider;
    private SubstrateGraalRuntime sGraalRuntime;
    private final HostedStringDeduplication stringTable;

    public GraalObjectReplacer(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess) {
        this.aUniverse = aUniverse;
        this.aMetaAccess = aMetaAccess;
        this.sMetaAccess = new SubstrateMetaAccess();
        this.stringTable = HostedStringDeduplication.singleton();
        this.sConstantReflectionProvider = new SubstrateConstantReflectionProvider(this.sMetaAccess);
        this.sConstantFieldProvider = new SubstrateConstantFieldProvider((MetaAccessProvider)aMetaAccess);
    }

    public void setGraalRuntime(SubstrateGraalRuntime sGraalRuntime) {
        assert (this.sGraalRuntime == null);
        this.sGraalRuntime = sGraalRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(Object source) {
        if (source == null) {
            return null;
        }
        Object dest = source;
        if (source instanceof RelocatedPointer) {
            return dest;
        }
        if (source instanceof MetaAccessProvider) {
            dest = this.sMetaAccess;
        } else {
            if (source instanceof HotSpotJVMCIRuntime) {
                throw VMError.shouldNotReachHere("HotSpotJVMCIRuntime should not appear in the image: " + source);
            }
            if (source instanceof GraalRuntime) {
                dest = this.sGraalRuntime;
            } else if (source instanceof AnalysisConstantReflectionProvider) {
                dest = this.sConstantReflectionProvider;
            } else if (source instanceof AnalysisConstantFieldProvider) {
                dest = this.sConstantFieldProvider;
            } else if (source instanceof ForeignCallsProvider) {
                dest = GraalSupport.getRuntimeConfig().getProviders().getForeignCalls();
            } else if (source instanceof HostedSnippetReflectionProvider) {
                dest = GraalSupport.getRuntimeConfig().getSnippetReflection();
            } else if (GraalObjectReplacer.shouldBeReplaced(source)) {
                GraalObjectReplacer graalObjectReplacer = this;
                synchronized (graalObjectReplacer) {
                    if (source instanceof HotSpotResolvedJavaMethod) {
                        throw new UnsupportedFeatureException(source.toString());
                    }
                    if (source instanceof HotSpotResolvedJavaField) {
                        throw new UnsupportedFeatureException(source.toString());
                    }
                    if (source instanceof HotSpotResolvedJavaType) {
                        throw new UnsupportedFeatureException(source.toString());
                    }
                    if (source instanceof HotSpotSignature) {
                        throw new UnsupportedFeatureException(source.toString());
                    }
                    if (source instanceof ResolvedJavaMethod) {
                        dest = this.createMethod((ResolvedJavaMethod)source);
                    } else if (source instanceof ResolvedJavaField) {
                        dest = this.createField((ResolvedJavaField)source);
                    } else if (source instanceof ResolvedJavaType) {
                        dest = this.createType((JavaType)((ResolvedJavaType)source));
                    } else if (source instanceof Signature) {
                        dest = this.createSignature((Signature)source);
                    } else if (source instanceof FieldLocationIdentity && (dest = this.fieldLocationIdentities.get(source)) == null) {
                        SubstrateField destField = (SubstrateField)this.apply(((FieldLocationIdentity)source).getField());
                        dest = new SubstrateFieldLocationIdentity(destField);
                        this.fieldLocationIdentities.put((FieldLocationIdentity)source, (FieldLocationIdentity)dest);
                    }
                }
            }
        }
        assert (dest != null);
        String className = dest.getClass().getName();
        assert (SubstrateUtil.isBuildingLibgraal() || !className.contains(".hotspot.") || className.contains(".svm.jtt.hotspot.")) : "HotSpot object in image " + className;
        assert (!className.contains(".analysis.meta.")) : "Analysis meta object in image " + className;
        assert (!className.contains(".hosted.meta.")) : "Hosted meta object in image " + className;
        assert (!SubstrateUtil.isBuildingLibgraal() || !className.contains(".svm.hosted.snippets.")) : "Hosted snippet object in image " + className;
        return dest;
    }

    private static boolean shouldBeReplaced(Object object) {
        if (object instanceof Replaced) {
            return false;
        }
        if (object instanceof ResolvedJavaMethod) {
            return true;
        }
        if (object instanceof ResolvedJavaField) {
            return true;
        }
        if (object instanceof ResolvedJavaType) {
            return true;
        }
        if (object instanceof ThreadMXBean) {
            return true;
        }
        return object instanceof FieldLocationIdentity;
    }

    public SubstrateMethod createMethod(ResolvedJavaMethod original) {
        AnalysisMethod aMethod = original instanceof AnalysisMethod ? (AnalysisMethod)original : (original instanceof HostedMethod ? ((HostedMethod)original).wrapped : this.aUniverse.lookup((JavaMethod)original));
        SubstrateMethod sMethod = this.methods.get(aMethod);
        if (sMethod == null) {
            assert (!(original instanceof HostedMethod)) : "too late to create new method";
            sMethod = new SubstrateMethod((ResolvedJavaMethod)aMethod, this.stringTable);
            this.methods.put(aMethod, sMethod);
            sMethod.setLinks(this.createSignature((Signature)aMethod.getSignature()), this.createType((JavaType)aMethod.getDeclaringClass()));
            sMethod.setAnnotationsEncoding(Inflation.encodeAnnotations(this.aMetaAccess, aMethod.getAnnotations(), null));
        }
        return sMethod;
    }

    public SubstrateField createField(ResolvedJavaField original) {
        AnalysisField aField = original instanceof AnalysisField ? (AnalysisField)original : ((HostedField)original).wrapped;
        SubstrateField sField = this.fields.get(aField);
        if (sField == null) {
            assert (!(original instanceof HostedField)) : "too late to create new field";
            int modifiers = aField.getModifiers();
            if (ReadableJavaField.injectFinalForRuntimeCompilation(aField.wrapped)) {
                modifiers |= 0x10;
            }
            sField = new SubstrateField((MetaAccessProvider)this.aMetaAccess, (ResolvedJavaField)aField, modifiers, this.stringTable);
            this.fields.put(aField, sField);
            sField.setLinks(this.createType((JavaType)aField.getType()), this.createType((JavaType)aField.getDeclaringClass()));
            sField.setAnnotationsEncoding(Inflation.encodeAnnotations(this.aMetaAccess, aField.getAnnotations(), null));
        }
        return sField;
    }

    public SubstrateField getField(AnalysisField field) {
        return this.fields.get(field);
    }

    public boolean removeField(AnalysisField field) {
        return this.fields.remove(field) != null;
    }

    public boolean typeCreated(JavaType original) {
        return this.types.containsKey(GraalObjectReplacer.toAnalysisType(original));
    }

    public SubstrateType createType(JavaType original) {
        if (original == null) {
            return null;
        }
        AnalysisType aType = GraalObjectReplacer.toAnalysisType(original);
        SubstrateType sType = this.types.get(aType);
        if (sType == null) {
            assert (!(original instanceof HostedType)) : "too late to create new type";
            DynamicHub hub = ((SVMHost)this.aUniverse.hostVM()).dynamicHub((ResolvedJavaType)aType);
            sType = new SubstrateType(aType.getJavaKind(), hub);
            this.types.put(aType, sType);
            hub.setMetaType(sType);
            sType.setRawAllInstanceFields(this.createAllInstanceFields((ResolvedJavaType)aType));
            this.createType((JavaType)aType.getSuperclass());
            this.createType((JavaType)aType.getComponentType());
            for (AnalysisType aInterface : aType.getInterfaces()) {
                this.createType((JavaType)aInterface);
            }
        }
        return sType;
    }

    private static AnalysisType toAnalysisType(JavaType original) {
        if (original instanceof HostedType) {
            return ((HostedType)original).getWrapped();
        }
        if (original instanceof AnalysisType) {
            return (AnalysisType)original;
        }
        throw new InternalError("unexpected type " + original);
    }

    private SubstrateField[] createAllInstanceFields(ResolvedJavaType originalType) {
        ResolvedJavaField[] originalFields = originalType.getInstanceFields(true);
        SubstrateField[] sFields = new SubstrateField[originalFields.length];
        for (int idx = 0; idx < originalFields.length; ++idx) {
            sFields[idx] = this.createField(originalFields[idx]);
        }
        return sFields;
    }

    private SubstrateSignature createSignature(Signature original) {
        SubstrateSignature sSignature = this.signatures.get(original);
        if (sSignature == null) {
            sSignature = new SubstrateSignature();
            this.signatures.put(original, sSignature);
            SubstrateType[] parameterTypes = new SubstrateType[original.getParameterCount(false)];
            for (int index = 0; index < original.getParameterCount(false); ++index) {
                parameterTypes[index] = this.createType(original.getParameterType(index, null));
            }
            sSignature.setTypes(parameterTypes, this.createType(original.getReturnType(null)));
        }
        return sSignature;
    }

    public boolean updateDataDuringAnalysis(AnalysisMetaAccess metaAccess) {
        boolean result = false;
        ArrayList<AnalysisMethod> aMethods = new ArrayList<AnalysisMethod>();
        aMethods.addAll(this.methods.keySet());
        int index = 0;
        while (index < aMethods.size()) {
            AnalysisMethod aMethod = (AnalysisMethod)aMethods.get(index++);
            SubstrateMethod substrateMethod = this.methods.get(aMethod);
            SubstrateMethod[] implementations = new SubstrateMethod[aMethod.getImplementations().length];
            int idx = 0;
            for (AnalysisMethod impl : aMethod.getImplementations()) {
                SubstrateMethod sImpl = this.methods.get(impl);
                if (sImpl == null) {
                    sImpl = this.createMethod((ResolvedJavaMethod)impl);
                    aMethods.add(impl);
                    result = true;
                }
                implementations[idx++] = sImpl;
            }
            if (!substrateMethod.setImplementations(implementations)) continue;
            result = true;
        }
        for (Map.Entry<AnalysisMethod, SubstrateMethod> entry : this.methods.entrySet()) {
            if (!entry.getValue().setAnnotationsEncoding(Inflation.encodeAnnotations(metaAccess, entry.getKey().getAnnotations(), entry.getValue().getAnnotationsEncoding()))) continue;
            result = true;
        }
        for (Map.Entry<Object, Replaced> entry : this.fields.entrySet()) {
            if (!((SubstrateField)entry.getValue()).setAnnotationsEncoding(Inflation.encodeAnnotations(metaAccess, ((AnalysisField)entry.getKey()).getAnnotations(), ((SubstrateField)entry.getValue()).getAnnotationsEncoding()))) continue;
            result = true;
        }
        return result;
    }

    public void updateSubstrateDataAfterCompilation(HostedUniverse hUniverse) {
        for (Map.Entry<AnalysisType, SubstrateType> entry : this.types.entrySet()) {
            AnalysisType aType = entry.getKey();
            SubstrateType sType = entry.getValue();
            if (!hUniverse.contains((JavaType)aType)) continue;
            HostedType hType = hUniverse.lookup((JavaType)aType);
            DynamicHub uniqueImplementation = null;
            if (hType.getUniqueConcreteImplementation() != null) {
                uniqueImplementation = hType.getUniqueConcreteImplementation().getHub();
            }
            sType.setTypeCheckData(hType.getInstanceOfFromTypeID(), hType.getInstanceOfNumTypeIDs(), uniqueImplementation);
            if (sType.getInstanceFieldCount() <= 1) continue;
            sType.setRawAllInstanceFields(this.createAllInstanceFields(hType));
        }
        for (Map.Entry<Object, Replaced> entry : this.fields.entrySet()) {
            AnalysisField aField = (AnalysisField)entry.getKey();
            SubstrateField sField = (SubstrateField)entry.getValue();
            HostedField hField = hUniverse.lookup((JavaField)aField);
            sField.setSubstrateData(hField.getLocation(), hField.isAccessed(), hField.isWritten(), hField.getConstantValue());
        }
    }

    public void updateSubstrateDataAfterHeapLayout(HostedUniverse hUniverse) {
        for (Map.Entry<AnalysisMethod, SubstrateMethod> entry : this.methods.entrySet()) {
            AnalysisMethod aMethod = entry.getKey();
            SubstrateMethod sMethod = entry.getValue();
            HostedMethod hMethod = hUniverse.lookup((JavaMethod)aMethod);
            int vTableIndex = hMethod.hasVTableIndex() ? hMethod.getVTableIndex() : -1;
            sMethod.setSubstrateData(vTableIndex, hMethod.isCodeAddressOffsetValid() ? hMethod.getCodeAddressOffset() : 0, hMethod.getDeoptOffsetInImage());
        }
    }

    public void registerImmutableObjects(Feature.CompilationAccess access) {
        for (SubstrateMethod method : this.methods.values()) {
            access.registerAsImmutable((Object)method);
            access.registerAsImmutable(method.getRawImplementations());
            access.registerAsImmutable((Object)method.getEncodedLineNumberTable());
        }
        for (SubstrateField field : this.fields.values()) {
            access.registerAsImmutable((Object)field);
        }
        for (FieldLocationIdentity fieldLocationIdentity : this.fieldLocationIdentities.values()) {
            access.registerAsImmutable((Object)fieldLocationIdentity);
        }
        for (SubstrateType type : this.types.values()) {
            access.registerAsImmutable((Object)type);
            access.registerAsImmutable(type.getRawAllInstanceFields());
        }
        for (SubstrateSignature signature : this.signatures.values()) {
            access.registerAsImmutable((Object)signature);
            access.registerAsImmutable(signature.getRawParameterTypes());
        }
    }
}

