/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.image.AbstractBootImage;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
public class FallbackFeature
implements Feature {
    private static final int ForceFallback = 10;
    private static final int Automatic = 5;
    private static final int NoFallback = 0;

    static FallbackImageRequest reportFallback(String message) {
        throw new FallbackImageRequest(message);
    }

    static UserError.UserException reportAsFallback(RuntimeException original) {
        if (Options.FallbackThreshold.getValue() == 0) {
            throw UserError.abort(original.getMessage(), original);
        }
        throw FallbackFeature.reportFallback("Abort stand-alone image build. " + original.getMessage());
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        if (Options.FallbackThreshold.getValue() == 10) {
            String fallbackArgument = SubstrateOptionsParser.commandArgument(Options.FallbackThreshold, "" + Options.FallbackThreshold.getValue());
            FallbackFeature.reportFallback("Abort stand-alone image build due to native-image option " + fallbackArgument);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        if (Options.FallbackThreshold.getValue() == 0 || NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue() || !AbstractBootImage.NativeImageKind.EXECUTABLE.name().equals(NativeImageOptions.Kind.getValue())) {
            return;
        }
        FeatureImpl.AfterAnalysisAccessImpl access = (FeatureImpl.AfterAnalysisAccessImpl)a;
        if (access.getBigBang().getUnsupportedFeatures().exist()) {
            String optionString = SubstrateOptionsParser.commandArgument(PointstoOptions.ReportUnsupportedFeaturesDuringAnalysis, "+");
            FallbackFeature.reportFallback("Abort stand-alone image build due to unsupported features (use " + optionString + " for report)");
        }
    }

    public static final class FallbackImageRequest
    extends UserError.UserException {
        private FallbackImageRequest(String message) {
            super(message);
        }
    }

    public static class Options {
        @APIOption.List(value={@APIOption(name="force-fallback", fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name="no-fallback", fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
        @Option(help={"Define when fallback-image generation should be used."})
        public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    }
}

