/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.CallTreePrinter;
import com.oracle.graal.pointsto.reports.ObjectTreePrinter;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptTester;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.jdk.ArraycopySnippets;
import com.oracle.svm.core.graal.lir.VerifyCFunctionReferenceMapsLIRPhase;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateStampProvider;
import com.oracle.svm.core.graal.phases.CollectDeoptimizationSourcePositionsPhase;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.phases.MethodSafepointInsertionPhase;
import com.oracle.svm.core.graal.phases.OptimizeExceptionCallsPhase;
import com.oracle.svm.core.graal.phases.RemoveUnwindPhase;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.graal.snippets.ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.DeoptRuntimeSnippets;
import com.oracle.svm.core.graal.snippets.ExceptionSnippets;
import com.oracle.svm.core.graal.snippets.MonitorSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.NonSnippetLowerings;
import com.oracle.svm.core.graal.snippets.TypeSnippets;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValuePhase;
import com.oracle.svm.core.graal.word.SubstrateWordTypes;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.LocalizationFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.analysis.AllocationSiteSensitiveAnalysisPolicy;
import com.oracle.svm.hosted.analysis.ContextInsensitiveAnalysisPolicy;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.SVMAnalysisMetaAccess;
import com.oracle.svm.hosted.analysis.SVMAnalysisPolicy;
import com.oracle.svm.hosted.analysis.flow.SVMMethodTypeFlowBuilder;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.c.CAnnotationProcessorCache;
import com.oracle.svm.hosted.c.CConstantValueSupportImpl;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.SizeOfSupportImpl;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperSubstitutionProcessor;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.CFunctionSubstitutionProcessor;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.code.HostedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.NativeMethodSubstitutionProcessor;
import com.oracle.svm.hosted.code.RestrictHeapAccessCalleesImpl;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateGraphMakerFactory;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.UniverseBuilder;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.InjectedAccessorsPlugin;
import com.oracle.svm.hosted.phases.IntrinsifyMethodHandlesInvocationPlugin;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.phases.VerifyDeoptFrameStatesLIRPhase;
import com.oracle.svm.hosted.phases.VerifyNoGuardsPhase;
import com.oracle.svm.hosted.snippets.AssertSnippets;
import com.oracle.svm.hosted.snippets.DeoptHostedSnippets;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeclarativeSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedFieldsPlugin;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.phases.CommunityCompilerConfiguration;
import org.graalvm.compiler.core.phases.EconomyCompilerConfiguration;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodeIntrinsicPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeoptimizationGroupingPhase;
import org.graalvm.compiler.phases.common.ExpandLogicPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.aarch64.AArch64GraphBuilderPlugins;
import org.graalvm.compiler.replacements.amd64.AMD64GraphBuilderPlugins;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.RuntimeClassInitialization;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.impl.CConstantValueSupport;
import org.graalvm.nativeimage.impl.SizeOfSupport;
import org.graalvm.word.PointerBase;

public class NativeImageGenerator {
    private final FeatureHandler featureHandler;
    private final ImageClassLoader loader;
    private final HostedOptionProvider optionProvider;
    private ForkJoinPool imageBuildPool;
    private AnalysisUniverse aUniverse;
    private HostedUniverse hUniverse;
    private Inflation bigbang;
    private NativeLibraries nativeLibraries;
    private AbstractBootImage image;
    private AtomicBoolean buildStarted = new AtomicBoolean();
    private Path tempDirectory;
    private boolean deleteTempDirectory;

    public NativeImageGenerator(ImageClassLoader loader, HostedOptionProvider optionProvider) {
        this.loader = loader;
        this.featureHandler = new FeatureHandler();
        this.optionProvider = optionProvider;
        optionProvider.getHostedValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
        optionProvider.getRuntimeValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
    }

    public static Platform defaultPlatform(ClassLoader classLoader) {
        String platformClassName = System.getProperty("svm.platform");
        if (platformClassName != null) {
            Object result;
            Class<?> platformClass;
            try {
                platformClass = classLoader.loadClass(platformClassName);
            }
            catch (ClassNotFoundException ex) {
                throw UserError.abort("Could not find platform class " + platformClassName + " that was specified explicitly on the command line using the system property " + "svm.platform");
            }
            try {
                Constructor<?> constructor = platformClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                result = constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw UserError.abort("Could not instantiated platform class " + platformClassName + ". Ensure the class is not abstract and has a no-argument constructor.");
            }
            if (!(result instanceof Platform)) {
                throw UserError.abort("Platform class " + platformClassName + " does not implement " + Platform.class.getTypeName());
            }
            return (Platform)result;
        }
        Architecture hostedArchitecture = GraalAccess.getOriginalTarget().arch;
        OS currentOs = OS.getCurrent();
        if (hostedArchitecture instanceof AMD64) {
            if (currentOs == OS.LINUX) {
                return new Platform.LINUX_AMD64();
            }
            if (currentOs == OS.DARWIN) {
                return new Platform.DARWIN_AMD64();
            }
            if (currentOs == OS.WINDOWS) {
                return new Platform.WINDOWS_AMD64();
            }
            throw VMError.shouldNotReachHere("Unsupported architecture/operating system: " + hostedArchitecture.getName() + "/" + currentOs.className);
        }
        if (hostedArchitecture instanceof AArch64) {
            if (OS.getCurrent() == OS.LINUX) {
                return new Platform.LINUX_AArch64();
            }
            throw VMError.shouldNotReachHere("Unsupported architecture/operating system: " + hostedArchitecture.getName() + "/" + currentOs.className);
        }
        throw VMError.shouldNotReachHere("Unsupported architecture: " + hostedArchitecture.getClass().getSimpleName());
    }

    public static boolean includedIn(Platform platform, Class<? extends Platform> platformGroup) {
        return platformGroup.isInstance(platform);
    }

    public static boolean includedIn(Platform platform, Platforms platformsAnnotation) {
        if (platformsAnnotation == null) {
            return true;
        }
        for (Class platformGroup : platformsAnnotation.value()) {
            if (!NativeImageGenerator.includedIn(platform, platformGroup)) continue;
            return true;
        }
        return false;
    }

    public static SubstrateTargetDescription createTarget(Platform platform) {
        if (NativeImageGenerator.includedIn(platform, Platform.AMD64.class)) {
            Architecture architecture;
            if (NativeImageOptions.NativeArchitecture.getValue().booleanValue()) {
                architecture = GraalAccess.getOriginalTarget().arch;
            } else {
                EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
                features.add(AMD64.CPUFeature.SSE);
                features.add(AMD64.CPUFeature.SSE2);
                features.addAll(NativeImageGenerator.parseCSVtoEnum(AMD64.CPUFeature.class, NativeImageOptions.CPUFeatures.getValue()));
                architecture = new AMD64(features, SubstrateTargetDescription.allFlags());
            }
            assert (architecture instanceof AMD64) : "SVM supports only AMD64 architectures.";
            boolean inlineObjects = SubstrateOptions.SpawnIsolates.getValue();
            int deoptScratchSpace = 16;
            return new SubstrateTargetDescription(architecture, true, 16, 0, inlineObjects, deoptScratchSpace);
        }
        if (NativeImageGenerator.includedIn(platform, Platform.AArch64.class)) {
            Architecture architecture;
            if (NativeImageOptions.NativeArchitecture.getValue().booleanValue()) {
                architecture = GraalAccess.getOriginalTarget().arch;
            } else {
                EnumSet<AArch64.CPUFeature> features = EnumSet.noneOf(AArch64.CPUFeature.class);
                features.addAll(NativeImageGenerator.parseCSVtoEnum(AArch64.CPUFeature.class, NativeImageOptions.CPUFeatures.getValue()));
                architecture = new AArch64(features, EnumSet.noneOf(AArch64.Flag.class));
            }
            boolean inlineObjects = SubstrateOptions.SpawnIsolates.getValue();
            int deoptScratchSpace = 16;
            return new SubstrateTargetDescription(architecture, true, 16, 0, inlineObjects, deoptScratchSpace);
        }
        throw UserError.abort("Architecture specified by platform is not supported: " + platform.getClass().getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<Method, CEntryPointData> entryPoints, Method mainEntryPoint, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractBootImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor, EconomicSet<String> allOptionNames) {
        try {
            if (!this.buildStarted.compareAndSet(false, true)) {
                throw UserError.abort("An image build has already been performed with this generator.");
            }
            NativeImageGenerator.setSystemPropertiesForImage(k);
            int maxConcurrentThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads(new OptionValues(this.optionProvider.getHostedValues()));
            this.imageBuildPool = this.createForkJoinPool(maxConcurrentThreads);
            ((ForkJoinTask)this.imageBuildPool.submit(() -> {
                try {
                    ImageSingletons.add(HostedOptionValues.class, (Object)((Object)new HostedOptionValues(this.optionProvider.getHostedValues())));
                    ImageSingletons.add(RuntimeOptionValues.class, (Object)((Object)new RuntimeOptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)this.optionProvider.getRuntimeValues(), allOptionNames)));
                    this.doRun(entryPoints, mainEntryPoint, javaMainSupport, imageName, k, harnessSubstitutions, compilationExecutor, analysisExecutor);
                }
                finally {
                    try {
                        if (this.deleteTempDirectory) {
                            NativeImageGenerator.deleteAll(this.tempDirectory());
                        }
                        this.featureHandler.forEachFeature(Feature::cleanup);
                    }
                    catch (Throwable throwable) {}
                }
            })).get();
        }
        catch (InterruptedException | CancellationException e) {
            System.out.println("Interrupted!");
            throw new InterruptImageBuilding();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
        }
        finally {
            this.shutdownPoolSafe();
            NativeImageGenerator.clearSystemPropertiesForImage();
        }
    }

    private static void setSystemPropertiesForImage(AbstractBootImage.NativeImageKind imageKind) {
        System.setProperty("org.graalvm.nativeimage.imagecode", "buildtime");
        if (imageKind.executable) {
            System.setProperty("org.graalvm.nativeimage.kind", "executable");
        } else {
            System.setProperty("org.graalvm.nativeimage.kind", "shared");
        }
    }

    private static void clearSystemPropertiesForImage() {
        System.clearProperty("org.graalvm.nativeimage.imagecode");
        System.clearProperty("org.graalvm.nativeimage.kind");
    }

    private ForkJoinPool createForkJoinPool(int maxConcurrentThreads) {
        final ImageSingletonsSupportImpl.HostedManagement vmConfig = new ImageSingletonsSupportImpl.HostedManagement();
        ImageSingletonsSupportImpl.HostedManagement.installInThread(vmConfig);
        return new ForkJoinPool(maxConcurrentThreads, pool -> new ForkJoinWorkerThread(pool){

            @Override
            protected void onStart() {
                super.onStart();
                ImageSingletonsSupportImpl.HostedManagement.installInThread(vmConfig);
                assert (NativeImageGenerator.this.loader.getClassLoader().equals(this.getContextClassLoader()));
            }

            @Override
            protected void onTermination(Throwable exception) {
                ImageSingletonsSupportImpl.HostedManagement.clearInThread();
                super.onTermination(exception);
            }
        }, Thread.getDefaultUncaughtExceptionHandler(), false);
    }

    private void doRun(Map<Method, CEntryPointData> entryPoints, Method mainEntryPoint, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractBootImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor) {
        ArrayList<HostedMethod> hostedEntryPoints = new ArrayList<HostedMethod>();
        OptionValues options = HostedOptionValues.singleton();
        SnippetReflectionProvider originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
        try (DebugContext debug = DebugContext.create((OptionValues)options, (DebugHandlersFactory)new GraalDebugHandlersFactory(originalSnippetReflection));){
            Object config3;
            NativeImageCodeCache codeCache;
            NativeImageHeap heap;
            HostedMethod mainEntryPointHostedStub;
            Object m2;
            SharedRuntimeConfigurationBuilder runtime;
            HostedMetaAccess hMetaAccess;
            this.setupNativeImage(imageName, options, entryPoints, javaMainSupport, harnessSubstitutions, analysisExecutor, originalSnippetReflection, debug);
            boolean returnAfterAnalysis = this.runPointsToAnalysis(imageName, options, debug);
            if (returnAfterAnalysis) {
                return;
            }
            try (Timer.StopTimer t = new Timer(imageName, "universe").start();){
                this.hUniverse = new HostedUniverse(this.bigbang);
                hMetaAccess = new HostedMetaAccess(this.hUniverse, this.bigbang.getMetaAccess());
                new UniverseBuilder(this.aUniverse, this.bigbang.getMetaAccess(), this.hUniverse, hMetaAccess, HostedConfiguration.instance().createStaticAnalysisResultsBuilder(this.bigbang, this.hUniverse), this.bigbang.getUnsupportedFeatures()).build(debug);
                runtime = new HostedRuntimeConfigurationBuilder(options, this.bigbang.getHostVM(), this.hUniverse, hMetaAccess, this.bigbang.getProviders(), this.nativeLibraries).build();
                NativeImageGenerator.registerGraphBuilderPlugins(this.featureHandler, runtime.getRuntimeConfig(), (HostedProviders)runtime.getRuntimeConfig().getProviders(), this.bigbang.getMetaAccess(), this.aUniverse, hMetaAccess, this.hUniverse, this.nativeLibraries, this.loader, false, true, this.bigbang.getAnnotationSubstitutionProcessor(), new SubstrateClassInitializationPlugin((SVMHost)this.aUniverse.hostVM()), this.bigbang.getHostVM().getClassInitializationSupport());
                if (NativeImageOptions.PrintUniverse.getValue().booleanValue()) {
                    this.printTypes();
                }
                for (Object m2 : this.aUniverse.getMethods()) {
                    if (!m2.isEntryPoint()) continue;
                    HostedMethod found = this.hUniverse.lookup((JavaMethod)m2);
                    assert (found != null);
                    hostedEntryPoints.add(found);
                }
                if (mainEntryPoint != null) {
                    AnalysisMethod analysisStub = CEntryPointCallStubSupport.singleton().getStubForMethod(mainEntryPoint);
                    mainEntryPointHostedStub = (HostedMethod)hMetaAccess.getUniverse().lookup((JavaMethod)analysisStub);
                    assert (hostedEntryPoints.contains(mainEntryPointHostedStub));
                } else {
                    mainEntryPointHostedStub = null;
                }
                if (hostedEntryPoints.size() == 0) {
                    throw UserError.abort("Warning: no entry points found, i.e., no method annotated with @" + CEntryPoint.class.getSimpleName());
                }
                heap = new NativeImageHeap(this.aUniverse, this.hUniverse, hMetaAccess);
                FeatureImpl.BeforeCompilationAccessImpl config2 = new FeatureImpl.BeforeCompilationAccessImpl(this.featureHandler, this.loader, this.aUniverse, this.hUniverse, hMetaAccess, heap, debug, runtime);
                this.featureHandler.forEachFeature(feature -> feature.beforeCompilation((Feature.BeforeCompilationAccess)config2));
                runtime.updateLazyState(hMetaAccess);
                this.bigbang.getUnsupportedFeatures().report((BigBang)this.bigbang);
            }
            catch (UnsupportedFeatureException ufe) {
                throw FallbackFeature.reportAsFallback((RuntimeException)((Object)ufe));
            }
            this.recordMethodsWithStackValues();
            NativeImageGenerator.recordRestrictHeapAccessCallees(this.aUniverse.getMethods());
            this.bigbang.cleanupAfterAnalysis();
            Timer.StopTimer t = new Timer(imageName, "compile").start();
            m2 = null;
            try {
                CompileQueue compileQueue = HostedConfiguration.instance().createCompileQueue(debug, this.featureHandler, this.hUniverse, runtime, DeoptTester.enabled(), this.bigbang.getProviders().getSnippetReflection(), compilationExecutor);
                compileQueue.finish(debug);
                this.hUniverse.getMethods().forEach(HostedMethod::clear);
                codeCache = NativeImageCodeCacheFactory.get().newCodeCache(compileQueue, heap);
                codeCache.layoutConstants();
                codeCache.layoutMethods(debug, imageName);
                config3 = new FeatureImpl.AfterCompilationAccessImpl(this.featureHandler, this.loader, this.aUniverse, this.hUniverse, hMetaAccess, heap, debug);
                this.featureHandler.forEachFeature(arg_0 -> NativeImageGenerator.lambda$doRun$3((FeatureImpl.AfterCompilationAccessImpl)config3, arg_0));
            }
            catch (Throwable config3) {
                m2 = config3;
                throw config3;
            }
            finally {
                if (t != null) {
                    if (m2 != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable config3) {
                            ((Throwable)m2).addSuppressed(config3);
                        }
                    } else {
                        t.close();
                    }
                }
            }
            CodeCacheProvider codeCacheProvider = runtime.getRuntimeConfig().getBackendForNormalMethod().getProviders().getCodeCache();
            Indent indent = debug.logAndIndent("create native image");
            config3 = null;
            try {
                try (DebugContext.Scope buildScope = debug.scope((Object)"CreateBootImage", (Object)codeCacheProvider);
                     Timer.StopTimer t2 = new Timer(imageName, "image").start();){
                    heap.addInitialObjects();
                    codeCache.addConstantsToHeap();
                    heap.addTrailingObjects();
                    FeatureImpl.AfterHeapLayoutAccessImpl config4 = new FeatureImpl.AfterHeapLayoutAccessImpl(this.featureHandler, this.loader, hMetaAccess, debug);
                    this.featureHandler.forEachFeature(feature -> feature.afterHeapLayout((Feature.AfterHeapLayoutAccess)config4));
                    this.image = AbstractBootImage.create(k, this.hUniverse, hMetaAccess, this.nativeLibraries, heap, codeCache, hostedEntryPoints, mainEntryPointHostedStub, this.loader.getClassLoader());
                    this.image.build(debug);
                    if (NativeImageOptions.PrintUniverse.getValue().booleanValue()) {
                        codeCache.printCompilationResults();
                    }
                }
                catch (Throwable e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            catch (Throwable throwable) {
                config3 = throwable;
                throw throwable;
            }
            finally {
                if (indent != null) {
                    if (config3 != null) {
                        try {
                            indent.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)config3).addSuppressed(throwable);
                        }
                    } else {
                        indent.close();
                    }
                }
            }
            FeatureImpl.BeforeImageWriteAccessImpl beforeConfig = new FeatureImpl.BeforeImageWriteAccessImpl(this.featureHandler, this.loader, imageName, this.image, runtime.getRuntimeConfig(), this.aUniverse, this.hUniverse, this.optionProvider, hMetaAccess, debug);
            this.featureHandler.forEachFeature(feature -> feature.beforeImageWrite((Feature.BeforeImageWriteAccess)beforeConfig));
            try (Timer.StopTimer t3 = new Timer(imageName, "write").start();){
                Path tmpDir = this.tempDirectory();
                Path imagePath = this.image.write(debug, NativeImageGenerator.generatedFiles(HostedOptionValues.singleton()), tmpDir, imageName, beforeConfig).getOutputFile();
                FeatureImpl.AfterImageWriteAccessImpl afterConfig = new FeatureImpl.AfterImageWriteAccessImpl(this.featureHandler, this.loader, this.hUniverse, imagePath, tmpDir, this.image.getBootImageKind(), debug);
                this.featureHandler.forEachFeature(feature -> feature.afterImageWrite((Feature.AfterImageWriteAccess)afterConfig));
            }
        }
    }

    private boolean runPointsToAnalysis(String imageName, OptionValues options, DebugContext debug) {
        block82: {
            String reportName;
            block83: {
                try {
                    try (Indent ignored = debug.logAndIndent("run analysis");){
                        try (Indent ignored1 = debug.logAndIndent("process analysis initializers");){
                            FeatureImpl.BeforeAnalysisAccessImpl config = new FeatureImpl.BeforeAnalysisAccessImpl(this.featureHandler, this.loader, this.bigbang, this.nativeLibraries, debug);
                            this.featureHandler.forEachFeature(feature -> feature.beforeAnalysis((Feature.BeforeAnalysisAccess)config));
                        }
                        try {
                            var7_11 = null;
                            try (Timer.StopTimer t = new Timer(imageName, "analysis").start();){
                                Timer processFeaturesTimer = new Timer(imageName, "(features)", false);
                                FeatureImpl.DuringAnalysisAccessImpl config = new FeatureImpl.DuringAnalysisAccessImpl(this.featureHandler, this.loader, this.bigbang, this.nativeLibraries, debug);
                                int numIterations = 0;
                                while (true) {
                                    Indent indent2 = debug.logAndIndent("new analysis iteration");
                                    Throwable throwable = null;
                                    try {
                                        boolean analysisChanged = this.bigbang.finish();
                                        if (++numIterations > 1000) {
                                            throw UserError.abort("Static analysis did not reach a fix point after " + numIterations + " iterations because a Feature keeps requesting new analysis iterations. The analysis itself " + (analysisChanged ? "DID" : "DID NOT") + " find a change in type states in the last iteration.");
                                        }
                                        Timer.StopTimer t2 = processFeaturesTimer.start();
                                        Throwable throwable2 = null;
                                        try {
                                            int numTypes = this.aUniverse.getTypes().size();
                                            int numMethods = this.aUniverse.getMethods().size();
                                            int numFields = this.aUniverse.getFields().size();
                                            this.bigbang.getHostVM().notifyClassReachabilityListener(this.aUniverse, config);
                                            this.featureHandler.forEachFeature(feature -> feature.duringAnalysis((Feature.DuringAnalysisAccess)config));
                                            if (config.getAndResetRequireAnalysisIteration()) continue;
                                            if (numTypes != this.aUniverse.getTypes().size() || numMethods != this.aUniverse.getMethods().size() || numFields != this.aUniverse.getFields().size()) {
                                                throw UserError.abort("When a feature makes more types, methods, or fields reachable, it must require another analysis iteration via DuringAnalysisAccess.requireAnalysisIteration()");
                                            }
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        finally {
                                            if (t2 == null) continue;
                                            if (throwable2 != null) {
                                                try {
                                                    t2.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                                continue;
                                            }
                                            t2.close();
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        throwable = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        if (indent2 == null) continue;
                                        if (throwable != null) {
                                            try {
                                                indent2.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable.addSuppressed(throwable6);
                                            }
                                            continue;
                                        }
                                        indent2.close();
                                        continue;
                                    }
                                    break;
                                }
                                FeatureImpl.AfterAnalysisAccessImpl postConfig = new FeatureImpl.AfterAnalysisAccessImpl(this.featureHandler, this.loader, this.bigbang, debug);
                                this.featureHandler.forEachFeature(feature -> feature.afterAnalysis((Feature.AfterAnalysisAccess)postConfig));
                                this.checkUniverse();
                                this.bigbang.typeFlowTimer.print();
                                this.bigbang.checkObjectsTimer.print();
                                processFeaturesTimer.print();
                                this.bigbang.getUnsupportedFeatures().report((BigBang)this.bigbang);
                                this.bigbang.checkUserLimitations();
                            }
                            catch (Throwable throwable) {
                                var7_11 = throwable;
                                throw throwable;
                            }
                        }
                        catch (UnsupportedFeatureException ufe) {
                            throw FallbackFeature.reportAsFallback((RuntimeException)((Object)ufe));
                        }
                    }
                    FeatureImpl.OnAnalysisExitAccessImpl onExitConfig = new FeatureImpl.OnAnalysisExitAccessImpl(this.featureHandler, this.loader, this.bigbang, debug);
                    this.featureHandler.forEachFeature(feature -> {
                        try {
                            feature.onAnalysisExit(onExitConfig);
                        }
                        catch (Exception ex) {
                            System.err.println("Exception during " + feature.getClass().getName() + ".onAnalysisExit()");
                        }
                    });
                    if (this.bigbang == null) break block82;
                    if (!((Boolean)AnalysisReportsOptions.PrintAnalysisCallTree.getValue(options)).booleanValue()) break block83;
                    reportName = imageName.substring(imageName.lastIndexOf("/") + 1);
                }
                catch (InterruptedException ie) {
                    try {
                        throw new InterruptImageBuilding();
                    }
                    catch (Throwable throwable) {
                        FeatureImpl.OnAnalysisExitAccessImpl onExitConfig = new FeatureImpl.OnAnalysisExitAccessImpl(this.featureHandler, this.loader, this.bigbang, debug);
                        this.featureHandler.forEachFeature(feature -> {
                            try {
                                feature.onAnalysisExit(onExitConfig);
                            }
                            catch (Exception ex) {
                                System.err.println("Exception during " + feature.getClass().getName() + ".onAnalysisExit()");
                            }
                        });
                        if (this.bigbang != null) {
                            String reportName2;
                            if (((Boolean)AnalysisReportsOptions.PrintAnalysisCallTree.getValue(options)).booleanValue()) {
                                reportName2 = imageName.substring(imageName.lastIndexOf("/") + 1);
                                CallTreePrinter.print((BigBang)this.bigbang, (String)SubstrateOptions.Path.getValue(), (String)reportName2);
                            }
                            if (((Boolean)AnalysisReportsOptions.PrintImageObjectTree.getValue(options)).booleanValue()) {
                                reportName2 = imageName.substring(imageName.lastIndexOf("/") + 1);
                                ObjectTreePrinter.print((BigBang)this.bigbang, (String)SubstrateOptions.Path.getValue(), (String)reportName2);
                            }
                            if (((Boolean)PointstoOptions.ReportAnalysisStatistics.getValue(options)).booleanValue()) {
                                PointsToStats.report((BigBang)this.bigbang, (String)imageName.replace("images/", ""));
                            }
                            if (((Boolean)PointstoOptions.PrintSynchronizedAnalysis.getValue(options)).booleanValue()) {
                                TypeState allSynchronizedTypeState = this.bigbang.getAllSynchronizedTypeState();
                                String typesString = allSynchronizedTypeState.closeToAllInstantiated((BigBang)this.bigbang) ? "close to all instantiated" : StreamSupport.stream(allSynchronizedTypeState.types().spliterator(), false).map(AnalysisType::getName).collect(Collectors.joining(", "));
                                System.out.println();
                                System.out.println("AllSynchronizedTypes");
                                System.out.println("Synchronized types #: " + allSynchronizedTypeState.typesCount());
                                System.out.println("Types: " + typesString);
                                System.out.println();
                            }
                        }
                        throw throwable;
                    }
                }
                CallTreePrinter.print((BigBang)this.bigbang, (String)SubstrateOptions.Path.getValue(), (String)reportName);
            }
            if (((Boolean)AnalysisReportsOptions.PrintImageObjectTree.getValue(options)).booleanValue()) {
                reportName = imageName.substring(imageName.lastIndexOf("/") + 1);
                ObjectTreePrinter.print((BigBang)this.bigbang, (String)SubstrateOptions.Path.getValue(), (String)reportName);
            }
            if (((Boolean)PointstoOptions.ReportAnalysisStatistics.getValue(options)).booleanValue()) {
                PointsToStats.report((BigBang)this.bigbang, (String)imageName.replace("images/", ""));
            }
            if (((Boolean)PointstoOptions.PrintSynchronizedAnalysis.getValue(options)).booleanValue()) {
                TypeState allSynchronizedTypeState = this.bigbang.getAllSynchronizedTypeState();
                String typesString = allSynchronizedTypeState.closeToAllInstantiated((BigBang)this.bigbang) ? "close to all instantiated" : StreamSupport.stream(allSynchronizedTypeState.types().spliterator(), false).map(AnalysisType::getName).collect(Collectors.joining(", "));
                System.out.println();
                System.out.println("AllSynchronizedTypes");
                System.out.println("Synchronized types #: " + allSynchronizedTypeState.typesCount());
                System.out.println("Types: " + typesString);
                System.out.println();
            }
        }
        if (NativeImageOptions.ReturnAfterAnalysis.getValue().booleanValue()) {
            return true;
        }
        if (NativeImageOptions.ExitAfterAnalysis.getValue().booleanValue()) {
            throw new InterruptImageBuilding("interrupted image construction as ExitAfterAnalysis is set");
        }
        return false;
    }

    private void setupNativeImage(String imageName, OptionValues options, Map<Method, CEntryPointData> entryPoints, JavaMainWrapper.JavaMainSupport javaMainSupport, SubstitutionProcessor harnessSubstitutions, ForkJoinPool analysisExecutor, SnippetReflectionProvider originalSnippetReflection, DebugContext debug) {
        try (Indent ignored = debug.logAndIndent("setup native-image builder");
             Timer.StopTimer ignored1 = new Timer(imageName, "setup").start();){
            Platform platform = NativeImageGenerator.defaultPlatform(this.loader.getClassLoader());
            SubstrateTargetDescription target = NativeImageGenerator.createTarget(platform);
            ImageSingletons.add(Platform.class, (Object)platform);
            ImageSingletons.add(SubstrateTargetDescription.class, (Object)((Object)target));
            if (javaMainSupport != null) {
                ImageSingletons.add(JavaMainWrapper.JavaMainSupport.class, (Object)javaMainSupport);
            }
            Providers originalProviders = GraalAccess.getOriginalProviders();
            MetaAccessProvider originalMetaAccess = originalProviders.getMetaAccess();
            this.featureHandler.registerFeatures(this.loader, debug);
            FeatureImpl.AfterRegistrationAccessImpl access = new FeatureImpl.AfterRegistrationAccessImpl(this.featureHandler, this.loader, originalMetaAccess, debug);
            this.featureHandler.forEachFeature(feature -> feature.afterRegistration((Feature.AfterRegistrationAccess)access));
            this.registerEntryPoints(entryPoints);
            HostedConfiguration.setDefaultIfEmpty(access);
            GraalConfiguration.setDefaultIfEmpty();
            ClassInitializationSupport classInitializaitonSupport = HostedConfiguration.instance().getClassInitializationSupport();
            AnnotationSubstitutionProcessor annotationSubstitutions = NativeImageGenerator.createDeclarativeSubstitutionProcessor(originalMetaAccess, this.loader, classInitializaitonSupport);
            CEnumCallWrapperSubstitutionProcessor cEnumProcessor = new CEnumCallWrapperSubstitutionProcessor();
            this.aUniverse = NativeImageGenerator.createAnalysisUniverse(options, platform, target, this.loader, originalMetaAccess, originalSnippetReflection, annotationSubstitutions, cEnumProcessor, classInitializaitonSupport, Collections.singletonList(harnessSubstitutions));
            SVMAnalysisMetaAccess aMetaAccess = new SVMAnalysisMetaAccess(this.aUniverse, originalMetaAccess);
            AnalysisConstantReflectionProvider aConstantReflection = new AnalysisConstantReflectionProvider(this.aUniverse, originalProviders.getConstantReflection(), classInitializaitonSupport);
            SubstrateWordTypes aWordTypes = new SubstrateWordTypes((MetaAccessProvider)aMetaAccess, FrameAccess.getWordKind());
            HostedSnippetReflectionProvider aSnippetReflection = new HostedSnippetReflectionProvider((SVMHost)this.aUniverse.hostVM(), aWordTypes);
            this.nativeLibraries = this.setupNativeLibraries(imageName, aConstantReflection, (MetaAccessProvider)aMetaAccess, aSnippetReflection, cEnumProcessor, classInitializaitonSupport);
            SubstrateForeignCallsProvider aForeignCalls = new SubstrateForeignCallsProvider();
            this.bigbang = NativeImageGenerator.createBigBang(options, target, this.aUniverse, this.nativeLibraries, analysisExecutor, aMetaAccess, aConstantReflection, aWordTypes, aSnippetReflection, annotationSubstitutions, (ForeignCallsProvider)aForeignCalls, classInitializaitonSupport);
            try (Indent ignored2 = debug.logAndIndent("process startup initializers");){
                FeatureImpl.DuringSetupAccessImpl config = new FeatureImpl.DuringSetupAccessImpl(this.featureHandler, this.loader, this.bigbang, debug);
                this.featureHandler.forEachFeature(feature -> feature.duringSetup((Feature.DuringSetupAccess)config));
            }
            NativeImageGenerator.initializeBigBang(this.bigbang, options, this.featureHandler, this.nativeLibraries, debug, aMetaAccess, this.aUniverse.getSubstitutions(), this.loader, true, new SubstrateClassInitializationPlugin((SVMHost)this.aUniverse.hostVM()));
            entryPoints.forEach((method, entryPointData) -> CEntryPointCallStubSupport.singleton().registerStubForMethod((Executable)method, () -> entryPointData));
        }
    }

    public static AnalysisUniverse createAnalysisUniverse(OptionValues options, Platform platform, TargetDescription target, ImageClassLoader loader, MetaAccessProvider originalMetaAccess, SnippetReflectionProvider originalSnippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, SubstitutionProcessor cEnumProcessor, ClassInitializationSupport classInitializationSupport, List<SubstitutionProcessor> additionalSubstitutions) {
        UnsafeAutomaticSubstitutionProcessor automaticSubstitutions = NativeImageGenerator.createAutomaticUnsafeSubstitutions(originalSnippetReflection, originalMetaAccess, annotationSubstitutions, loader);
        SubstitutionProcessor aSubstitutions = NativeImageGenerator.createAnalysisSubstitutionProcessor(originalMetaAccess, originalSnippetReflection, cEnumProcessor, automaticSubstitutions, annotationSubstitutions, additionalSubstitutions);
        SVMHost hostVM = new SVMHost(options, loader.getClassLoader(), classInitializationSupport, automaticSubstitutions);
        SVMAnalysisPolicy analysisPolicy = (Boolean)PointstoOptions.AllocationSiteSensitiveHeap.getValue(options) != false ? new AllocationSiteSensitiveAnalysisPolicy(options) : new ContextInsensitiveAnalysisPolicy(options);
        return new AnalysisUniverse((HostVM)hostVM, target.wordJavaKind, platform, (AnalysisPolicy)analysisPolicy, aSubstitutions, originalMetaAccess, originalSnippetReflection, (SnippetReflectionProvider)new SubstrateSnippetReflectionProvider(new SubstrateWordTypes(originalMetaAccess, FrameAccess.getWordKind())));
    }

    public static AnnotationSubstitutionProcessor createDeclarativeSubstitutionProcessor(MetaAccessProvider originalMetaAccess, ImageClassLoader loader, ClassInitializationSupport classInitializationSupport) {
        DeclarativeSubstitutionProcessor annotationSubstitutions = new DeclarativeSubstitutionProcessor(loader, originalMetaAccess, classInitializationSupport);
        annotationSubstitutions.init();
        return annotationSubstitutions;
    }

    public static UnsafeAutomaticSubstitutionProcessor createAutomaticUnsafeSubstitutions(SnippetReflectionProvider originalSnippetReflection, MetaAccessProvider originalMetaAccess, AnnotationSubstitutionProcessor annotationSubstitutions, ImageClassLoader loader) {
        UnsafeAutomaticSubstitutionProcessor automaticSubstitutions = new UnsafeAutomaticSubstitutionProcessor(annotationSubstitutions, originalSnippetReflection);
        automaticSubstitutions.init(loader, originalMetaAccess);
        return automaticSubstitutions;
    }

    public static SubstitutionProcessor createAnalysisSubstitutionProcessor(MetaAccessProvider originalMetaAccess, SnippetReflectionProvider originalSnippetReflection, SubstitutionProcessor cEnumProcessor, SubstitutionProcessor automaticSubstitutions, SubstitutionProcessor annotationSubstitutions, List<SubstitutionProcessor> additionalSubstitutionProcessors) {
        ArrayList<SubstitutionProcessor> allProcessors = new ArrayList<SubstitutionProcessor>();
        CFunctionSubstitutionProcessor cFunctionSubstitutions = new CFunctionSubstitutionProcessor();
        allProcessors.addAll(Arrays.asList(new SubstitutionProcessor[]{new AnnotationSupport(originalMetaAccess, originalSnippetReflection), annotationSubstitutions, cFunctionSubstitutions, automaticSubstitutions, cEnumProcessor}));
        allProcessors.addAll(additionalSubstitutionProcessors);
        return SubstitutionProcessor.chainUpInOrder((SubstitutionProcessor[])allProcessors.toArray(new SubstitutionProcessor[0]));
    }

    public static void initializeBigBang(Inflation bigbang, OptionValues options, FeatureHandler featureHandler, NativeLibraries nativeLibraries, DebugContext debug, AnalysisMetaAccess aMetaAccess, SubstitutionProcessor substitutions, ImageClassLoader loader, boolean initForeignCalls, ClassInitializationPlugin classInitializationPlugin) {
        SubstrateReplacements aReplacements = bigbang.getReplacements();
        HostedProviders aProviders = bigbang.getProviders();
        AnalysisUniverse aUniverse = bigbang.getUniverse();
        bigbang.getAnnotationSubstitutionProcessor().processComputedValueFields(bigbang);
        NativeImageGenerator.registerGraphBuilderPlugins(featureHandler, null, aProviders, aMetaAccess, aUniverse, null, null, nativeLibraries, loader, true, true, bigbang.getAnnotationSubstitutionProcessor(), classInitializationPlugin, bigbang.getHostVM().getClassInitializationSupport());
        NativeImageGenerator.registerReplacements(debug, featureHandler, null, (Providers)aProviders, aProviders.getSnippetReflection(), true, initForeignCalls);
        SubstitutionProcessor[] featureNativeSubstitutions = aUniverse.getFeatureNativeSubstitutions();
        if (featureNativeSubstitutions.length > 0) {
            SubstitutionProcessor chain = SubstitutionProcessor.chainUpInOrder((SubstitutionProcessor[])featureNativeSubstitutions);
            NativeMethodSubstitutionProcessor nativeSubstitutionProcessor = new NativeMethodSubstitutionProcessor(chain, (Replacements)aReplacements);
            SubstitutionProcessor.extendsTheChain((SubstitutionProcessor)substitutions, (SubstitutionProcessor[])new SubstitutionProcessor[]{nativeSubstitutionProcessor});
        }
        SubstitutionProcessor.extendsTheChain((SubstitutionProcessor)substitutions, (SubstitutionProcessor[])aUniverse.getFeatureSubstitutions());
        try (Indent ignored = debug.logAndIndent("add initial classes/fields/methods");){
            bigbang.addSystemClass(Object.class, false, false).registerAsInHeap();
            bigbang.addSystemField(DynamicHub.class, "vtable");
            bigbang.addSystemClass(String.class, false, false).registerAsInHeap();
            bigbang.addSystemClass(String[].class, false, false).registerAsInHeap();
            bigbang.addSystemField(String.class, "value").registerAsInHeap();
            bigbang.addSystemClass(long[].class, false, false).registerAsInHeap();
            bigbang.addSystemClass(byte[].class, false, false).registerAsInHeap();
            bigbang.addSystemClass(byte[][].class, false, false).registerAsInHeap();
            bigbang.addSystemClass(Object[].class, false, false).registerAsInHeap();
            bigbang.addSystemClass(CFunctionPointer[].class, false, false).registerAsInHeap();
            bigbang.addSystemClass(PointerBase[].class, false, false).registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "firstReadOnlyPrimitiveObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "lastReadOnlyPrimitiveObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "firstReadOnlyReferenceObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "lastReadOnlyReferenceObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "firstWritablePrimitiveObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "lastWritablePrimitiveObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "firstWritableReferenceObject").registerAsInHeap();
            bigbang.addSystemStaticField(NativeImageInfo.class, "lastWritableReferenceObject").registerAsInHeap();
            try {
                bigbang.addRootMethod(ArraycopySnippets.class.getDeclaredMethod("doArraycopy", Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE));
                bigbang.addRootMethod(Object.class.getDeclaredMethod("getClass", new Class[0]));
            }
            catch (NoSuchMethodException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            for (JavaKind kind : JavaKind.values()) {
                if (!kind.isPrimitive() || kind == JavaKind.Void) continue;
                bigbang.addSystemClass(kind.toJavaClass(), false, true);
                bigbang.addSystemField(kind.toBoxedJavaClass(), "value");
                bigbang.addSystemMethod(kind.toBoxedJavaClass(), "valueOf", new Class[]{kind.toJavaClass()});
                bigbang.addSystemMethod(kind.toBoxedJavaClass(), kind.getJavaName() + "Value", new Class[0]);
            }
            for (StructuredGraph graph : aReplacements.getSnippetGraphs((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(options), options)) {
                new SVMMethodTypeFlowBuilder((BigBang)bigbang, graph).registerUsedElements();
            }
        }
    }

    public static Inflation createBigBang(OptionValues options, TargetDescription target, AnalysisUniverse aUniverse, NativeLibraries nativeLibraries, ForkJoinPool analysisExecutor, AnalysisMetaAccess aMetaAccess, AnalysisConstantReflectionProvider aConstantReflection, WordTypes aWordTypes, SnippetReflectionProvider aSnippetReflection, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForeignCallsProvider aForeignCalls, ClassInitializationSupport classInitializationSupport) {
        assert (aUniverse != null) : "Analysis universe must be initialized.";
        assert (nativeLibraries != null) : "Native libraries must be set.";
        AnalysisConstantFieldProvider aConstantFieldProvider = new AnalysisConstantFieldProvider(aUniverse, (MetaAccessProvider)aMetaAccess, aConstantReflection, classInitializationSupport);
        LoweringProvider aLoweringProvider = SubstrateLoweringProvider.create((MetaAccessProvider)aMetaAccess, null);
        SubstrateStampProvider aStampProvider = new SubstrateStampProvider((MetaAccessProvider)aMetaAccess);
        HostedProviders aProviders = new HostedProviders((MetaAccessProvider)aMetaAccess, null, (ConstantReflectionProvider)aConstantReflection, (ConstantFieldProvider)aConstantFieldProvider, aForeignCalls, aLoweringProvider, null, (StampProvider)aStampProvider, aSnippetReflection, aWordTypes);
        ResolvedJavaMethodBytecodeProvider bytecodeProvider = new ResolvedJavaMethodBytecodeProvider();
        SubstrateReplacements aReplacments = new SubstrateReplacements((Providers)aProviders, aSnippetReflection, (BytecodeProvider)bytecodeProvider, target, new SubstrateGraphMakerFactory(aWordTypes));
        aProviders = new HostedProviders((MetaAccessProvider)aMetaAccess, null, (ConstantReflectionProvider)aConstantReflection, (ConstantFieldProvider)aConstantFieldProvider, aForeignCalls, aLoweringProvider, (Replacements)aReplacments, (StampProvider)aStampProvider, aSnippetReflection, aWordTypes);
        return new Inflation(options, aUniverse, aProviders, annotationSubstitutionProcessor, analysisExecutor);
    }

    private NativeLibraries setupNativeLibraries(String imageName, ConstantReflectionProvider aConstantReflection, MetaAccessProvider aMetaAccess, SnippetReflectionProvider aSnippetReflection, CEnumCallWrapperSubstitutionProcessor cEnumProcessor, ClassInitializationSupport classInitializationSupport) {
        try (Timer.StopTimer ignored = new Timer(imageName, "(cap)").start();){
            NativeLibraries nativeLibs = new NativeLibraries(aConstantReflection, aMetaAccess, aSnippetReflection, ConfigurationValues.getTarget());
            cEnumProcessor.setNativeLibraries(nativeLibs);
            this.processNativeLibraryImports(nativeLibs, aMetaAccess, classInitializationSupport);
            ImageSingletons.add(SizeOfSupport.class, (Object)new SizeOfSupportImpl(nativeLibs, aMetaAccess));
            ImageSingletons.add(CConstantValueSupport.class, (Object)new CConstantValueSupportImpl(nativeLibs, aMetaAccess));
            if (CAnnotationProcessorCache.Options.ExitAfterCAPCache.getValue().booleanValue()) {
                throw new InterruptImageBuilding("Exiting image generation because of " + SubstrateOptionsParser.commandArgument(CAnnotationProcessorCache.Options.ExitAfterCAPCache, "+"));
            }
            NativeLibraries nativeLibraries = nativeLibs;
            return nativeLibraries;
        }
    }

    private void registerEntryPoints(Map<Method, CEntryPointData> entryPoints) {
        for (Method m : this.loader.findAnnotatedMethods(CEntryPoint.class)) {
            if (!Modifier.isStatic(m.getModifiers())) {
                throw UserError.abort("entry point method " + m.getDeclaringClass().getName() + "." + m.getName() + " is not static. Add a static modifier to the method.");
            }
            boolean include = true;
            CEntryPointOptions options = m.getAnnotation(CEntryPointOptions.class);
            if (options != null) {
                BooleanSupplier instance;
                try {
                    Constructor<? extends BooleanSupplier> constructor = options.include().getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
                include = instance.getAsBoolean();
            }
            if (!include) continue;
            entryPoints.put(m, CEntryPointData.create(m));
        }
    }

    private void recordMethodsWithStackValues() {
        this.bigbang.getUniverse().getMethods().parallelStream().forEach(analysisMethod -> {
            if (analysisMethod.getTypeFlow() != null && analysisMethod.getTypeFlow().getGraph() != null && analysisMethod.getTypeFlow().getGraph().getNodes(StackValueNode.TYPE).isNotEmpty()) {
                this.hUniverse.recordMethodWithStackValues((AnalysisMethod)analysisMethod);
            }
        });
    }

    private static void recordRestrictHeapAccessCallees(Collection<AnalysisMethod> methods) {
        ((RestrictHeapAccessCalleesImpl)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).aggregateMethods(methods);
    }

    public void interruptBuild() {
        this.shutdownPoolSafe();
    }

    private void shutdownPoolSafe() {
        if (this.imageBuildPool != null) {
            this.imageBuildPool.shutdownNow();
        }
    }

    public static void registerGraphBuilderPlugins(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, HostedProviders providers, AnalysisMetaAccess aMetaAccess, AnalysisUniverse aUniverse, HostedMetaAccess hMetaAccess, HostedUniverse hUniverse, NativeLibraries nativeLibs, ImageClassLoader loader, boolean analysis, boolean hosted, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ClassInitializationPlugin classInitializationPlugin, ClassInitializationSupport classInitializationSupport) {
        AnalysisMetaAccess pluginsMetaAccess;
        assert (!analysis || hosted) : "analysis must always be hosted";
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins((InvocationPlugins)new SubstitutionInvocationPlugins(annotationSubstitutionProcessor));
        WordOperationPlugin wordOperationPlugin = new WordOperationPlugin(providers.getSnippetReflection(), providers.getWordTypes());
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)replacements);
        plugins.appendNodePlugin((NodePlugin)new IntrinsifyMethodHandlesInvocationPlugin((Providers)providers, aUniverse, hUniverse));
        plugins.appendNodePlugin((NodePlugin)new DeletedFieldsPlugin());
        plugins.appendNodePlugin((NodePlugin)new InjectedAccessorsPlugin());
        plugins.appendNodePlugin((NodePlugin)new ConstantFoldLoadFieldPlugin(classInitializationSupport));
        plugins.appendNodePlugin((NodePlugin)new CInterfaceInvocationPlugin(providers.getMetaAccess(), providers.getWordTypes(), nativeLibs));
        plugins.appendNodePlugin((NodePlugin)new LocalizationFeature.CharsetNodePlugin());
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        plugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        plugins.setClassInitializationPlugin(classInitializationPlugin);
        featureHandler.forEachGraalFeature(feature -> feature.registerGraphBuilderPlugins((Providers)providers, plugins, analysis, hosted));
        HostedSnippetReflectionProvider hostedSnippetReflection = new HostedSnippetReflectionProvider((SVMHost)aUniverse.hostVM(), new SubstrateWordTypes((MetaAccessProvider)aMetaAccess, FrameAccess.getWordKind()));
        final HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        NodeIntrinsificationProvider nodeIntrinsificationProvider = !SubstrateUtil.isBuildingLibgraal() ? new NodeIntrinsificationProvider(providers.getMetaAccess(), (SnippetReflectionProvider)hostedSnippetReflection, providers.getForeignCalls(), providers.getWordTypes()) : new NodeIntrinsificationProvider(providers.getMetaAccess(), hostedSnippetReflection, providers.getForeignCalls(), providers.getWordTypes()){

            public <T> T getInjectedArgument(Class<T> type) {
                if (type.isAssignableFrom(GraalHotSpotVMConfig.class)) {
                    return type.cast(compiler.getGraalRuntime().getVMConfig());
                }
                if (type.isAssignableFrom(HotSpotGraalRuntimeProvider.class)) {
                    return type.cast(compiler.getGraalRuntime());
                }
                return (T)super.getInjectedArgument(type);
            }
        };
        for (Class<NodeIntrinsicPluginFactory> factoryClass : loader.findSubclasses(NodeIntrinsicPluginFactory.class)) {
            NodeIntrinsicPluginFactory factory;
            if (Modifier.isAbstract(factoryClass.getModifiers()) || factoryClass.getName().contains("hotspot")) continue;
            try {
                factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            factory.registerPlugins(plugins.getInvocationPlugins(), (NodeIntrinsicPluginFactory.InjectionProvider)nodeIntrinsificationProvider);
        }
        BytecodeProvider replacementBytecodeProvider = replacements.getDefaultReplacementBytecodeProvider();
        boolean explicitUnsafeNullChecks = SubstrateOptions.SpawnIsolates.getValue();
        StandardGraphBuilderPlugins.registerInvocationPlugins((MetaAccessProvider)providers.getMetaAccess(), (SnippetReflectionProvider)providers.getSnippetReflection(), (InvocationPlugins)plugins.getInvocationPlugins(), (BytecodeProvider)replacementBytecodeProvider, (!hosted ? 1 : 0) != 0, (boolean)explicitUnsafeNullChecks);
        Architecture architecture = ConfigurationValues.getTarget().arch;
        if (architecture instanceof AMD64) {
            AMD64GraphBuilderPlugins.register((GraphBuilderConfiguration.Plugins)plugins, (BytecodeProvider)replacementBytecodeProvider, (AMD64)((AMD64)architecture), (boolean)explicitUnsafeNullChecks, (SubstrateOptions.EmitStringEncodingSubstitutions.getValue() != false && JavaVersionUtil.JAVA_SPECIFICATION_VERSION >= 9 ? 1 : 0) != 0);
        } else if (architecture instanceof AArch64) {
            AArch64GraphBuilderPlugins.register((GraphBuilderConfiguration.Plugins)plugins, (BytecodeProvider)replacementBytecodeProvider, (boolean)explicitUnsafeNullChecks, (boolean)false);
        } else {
            throw GraalError.shouldNotReachHere((String)("Unimplemented GraphBuilderPlugin for architecture " + architecture));
        }
        Object object = pluginsMetaAccess = hosted && !analysis ? hMetaAccess : aMetaAccess;
        assert (pluginsMetaAccess != null);
        SubstrateGraphBuilderPlugins.registerInvocationPlugins(annotationSubstitutionProcessor, (MetaAccessProvider)pluginsMetaAccess, providers.getConstantReflection(), hostedSnippetReflection, plugins.getInvocationPlugins(), replacementBytecodeProvider, analysis);
        featureHandler.forEachGraalFeature(feature -> feature.registerInvocationPlugins((Providers)providers, hostedSnippetReflection, plugins.getInvocationPlugins(), analysis, hosted));
        providers.setGraphBuilderPlugins(plugins);
        replacements.setGraphBuilderPlugins(plugins);
        if (runtimeConfig != null && runtimeConfig.getProviders() instanceof HostedProviders) {
            ((HostedProviders)runtimeConfig.getProviders()).setGraphBuilderPlugins(plugins);
            for (SubstrateBackend backend : runtimeConfig.getBackends()) {
                ((HostedProviders)backend.getProviders()).setGraphBuilderPlugins(plugins);
            }
        }
    }

    public static void registerReplacements(DebugContext debug, FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, boolean hosted, boolean initForeignCalls) {
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        Providers runtimeCallProviders = runtimeConfig != null ? runtimeConfig.getBackendForNormalMethod().getProviders() : providers;
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)providers.getForeignCalls();
        if (initForeignCalls) {
            for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : SnippetRuntime.getRuntimeCalls()) {
                foreignCallsProvider.getForeignCalls().put(descriptor, new SubstrateForeignCallLinkage(runtimeCallProviders, descriptor));
            }
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerForeignCalls(runtimeConfig, runtimeCallProviders, snippetReflection, foreignCallsProvider.getForeignCalls(), hosted));
        try (DebugContext.Scope s = debug.scope((Object)"RegisterLowerings", (Object)new DebugDumpScope("RegisterLowerings"));){
            SubstrateLoweringProvider lowerer = (SubstrateLoweringProvider)providers.getLowerer();
            Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = lowerer.getLowerings();
            Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
            if (hosted) {
                mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
            }
            Iterable<DebugHandlersFactory> factories = runtimeConfig != null ? runtimeConfig.getDebugHandlersFactories() : Collections.singletonList(new GraalDebugHandlersFactory(snippetReflection));
            lowerer.setConfiguration(runtimeConfig, (OptionValues)options, factories, providers, snippetReflection);
            NonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, factories, providers, snippetReflection, lowerings);
            ArithmeticSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            MonitorSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            TypeSnippets.registerLowerings(runtimeConfig, options, factories, providers, snippetReflection, lowerings);
            ExceptionSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            if (hosted) {
                AssertSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
                DeoptHostedSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            } else {
                DeoptRuntimeSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            }
            featureHandler.forEachGraalFeature(arg_0 -> NativeImageGenerator.lambda$registerReplacements$20(runtimeConfig, (OptionValues)options, factories, providers, snippetReflection, lowerings, hosted, arg_0));
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        assert (NativeImageGenerator.checkInvocationPluginMethods(replacements));
        replacements.encodeSnippets();
    }

    private static boolean checkInvocationPluginMethods(SubstrateReplacements replacements) {
        Iterator<ResolvedJavaMethod> iterator = replacements.getDelayedInvocationPluginMethods().iterator();
        while (iterator.hasNext()) {
            String hostedDescriptor;
            String runtimeDescriptor;
            ResolvedJavaMethod method;
            ResolvedJavaMethod unwrapped = method = iterator.next();
            while (unwrapped instanceof WrappedJavaMethod) {
                unwrapped = ((WrappedJavaMethod)unwrapped).getWrapped();
            }
            if (method != unwrapped && !(runtimeDescriptor = method.getSignature().toMethodDescriptor()).equals(hostedDescriptor = unwrapped.getSignature().toMethodDescriptor())) {
                String name = method.format("%H.%n");
                throw new AssertionError((Object)String.format("Cannot have invocation plugin for a method whose runtime signature is different from its hosted signature:%n            method: %s%n  hosted signature: %s%n runtime signature: %s", name, runtimeDescriptor, hostedDescriptor));
            }
            assert (method == unwrapped || method.getSignature().toMethodDescriptor().equals(unwrapped.getSignature().toMethodDescriptor()));
        }
        return true;
    }

    public static Suites createSuites(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted, boolean requiresPostParseCanonicalization) {
        SubstrateBackend backend = runtimeConfig.getBackendForNormalMethod();
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        Suites suites = GraalConfiguration.instance().createSuites((OptionValues)options, hosted);
        return NativeImageGenerator.modifySuites(backend, suites, featureHandler, runtimeConfig, snippetReflection, hosted, false, requiresPostParseCanonicalization);
    }

    public static Suites createFirstTierSuites(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted, boolean requiresPostParseCanonicalization) {
        SubstrateBackend backend = runtimeConfig.getBackendForNormalMethod();
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        Suites suites = GraalConfiguration.instance().createFirstTierSuites((OptionValues)options, hosted);
        return NativeImageGenerator.modifySuites(backend, suites, featureHandler, runtimeConfig, snippetReflection, hosted, true, requiresPostParseCanonicalization);
    }

    private static Suites modifySuites(SubstrateBackend backend, Suites suites, FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted, boolean firstTier, boolean requiresPostParseCanonicalization) {
        ListIterator it;
        Providers runtimeCallProviders = backend.getProviders();
        PhaseSuite highTier = suites.getHighTier();
        PhaseSuite midTier = suites.getMidTier();
        PhaseSuite lowTier = suites.getLowTier();
        ListIterator<BasePhase<? super HighTierContext>> position = hosted ? GraalConfiguration.instance().createHostedInliners((PhaseSuite<HighTierContext>)highTier, requiresPostParseCanonicalization) : highTier.findPhase(InliningPhase.class);
        if (position != null) {
            position.add((BasePhase<? super HighTierContext>)new DeadStoreRemovalPhase());
            position.add((BasePhase<? super HighTierContext>)new RemoveUnwindPhase());
        } else {
            highTier.prependPhase((BasePhase)new RemoveUnwindPhase());
            highTier.prependPhase((BasePhase)new DeadStoreRemovalPhase());
        }
        highTier.appendPhase((BasePhase)new StackValuePhase());
        lowTier.addBeforeLast((BasePhase)new OptimizeExceptionCallsPhase());
        Phase addressLoweringPhase = backend.newAddressLoweringPhase(runtimeCallProviders.getCodeCache());
        if (firstTier) {
            lowTier.findPhase(ExpandLogicPhase.class).add(addressLoweringPhase);
        } else {
            lowTier.findPhase(FixReadsPhase.class).add(addressLoweringPhase);
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            midTier.findPhase(LoopSafepointInsertionPhase.class).add(new MethodSafepointInsertionPhase());
        } else {
            VMError.guarantee(midTier.removePhase(LoopSafepointInsertionPhase.class));
        }
        if (hosted) {
            lowTier.appendPhase((BasePhase)new VerifyNoGuardsPhase());
            highTier.removePhase(InliningPhase.class);
            highTier.findPhase(ConvertDeoptimizeToGuardPhase.class, true).remove();
            midTier.findPhase(DeoptimizationGroupingPhase.class).remove();
        } else if (firstTier) {
            it = midTier.findPhase(FrameStateAssignmentPhase.class);
            it.add(new CollectDeoptimizationSourcePositionsPhase());
            it = midTier.findLastPhase();
            it.add(new CanonicalizerPhase());
        } else {
            it = midTier.findPhase(DeoptimizationGroupingPhase.class);
            it.previous();
            it.add(new CollectDeoptimizationSourcePositionsPhase());
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerGraalPhases(runtimeCallProviders, snippetReflection, suites, hosted));
        if (hosted && requiresPostParseCanonicalization) {
            ArrayList reverseAfterParsePhases = new ArrayList(CompileQueue.afterParseCanonicalization().getPhases());
            Collections.reverse(reverseAfterParsePhases);
            for (BasePhase phase : reverseAfterParsePhases) {
                highTier.prependPhase(phase);
            }
        }
        return suites;
    }

    public static LIRSuites createLIRSuites(FeatureHandler featureHandler, Providers providers, boolean hosted) {
        LIRSuites lirSuites = Suites.createLIRSuites((CompilerConfiguration)new CommunityCompilerConfiguration(), (OptionValues)(hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton()));
        if (hosted) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase((LIRPhase)new VerifyCFunctionReferenceMapsLIRPhase());
        }
        assert (NativeImageGenerator.addAssertionLIRPhases(lirSuites, hosted));
        return lirSuites;
    }

    public static LIRSuites createFirstTierLIRSuites(FeatureHandler featureHandler, Providers providers, boolean hosted) {
        LIRSuites lirSuites = Suites.createLIRSuites((CompilerConfiguration)new EconomyCompilerConfiguration(), (OptionValues)(hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton()));
        if (hosted) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase((LIRPhase)new VerifyCFunctionReferenceMapsLIRPhase());
        }
        assert (NativeImageGenerator.addAssertionLIRPhases(lirSuites, hosted));
        return lirSuites;
    }

    private static boolean addAssertionLIRPhases(LIRSuites lirSuites, boolean hosted) {
        if (hosted) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase((LIRPhase)new VerifyDeoptFrameStatesLIRPhase());
        }
        return true;
    }

    private void checkUniverse() {
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            for (int i = 0; i < method.getTypeFlow().getOriginalMethodFlows().getParameters().length; ++i) {
                AnalysisType declaredType;
                TypeState state = method.getTypeFlow().getParameterTypeState((BigBang)this.bigbang, i);
                if (state == null || !(declaredType = method.getTypeFlow().getOriginalMethodFlows().getParameter(i).getDeclaredType()).isInterface() || (state = TypeState.forSubtraction((BigBang)this.bigbang, (TypeState)state, (TypeState)declaredType.getTypeFlow((BigBang)this.bigbang, true).getState())).isEmpty()) continue;
                String methodKey = method.format("%H.%n(%p)");
                this.bigbang.getUnsupportedFeatures().addMessage(methodKey, method, "Parameter " + i + " of " + methodKey + " has declared type " + declaredType.toJavaName(true) + " which is incompatible with types in state: " + state);
            }
        }
        for (AnalysisField field : this.aUniverse.getFields()) {
            AnalysisType declaredType;
            TypeState state = field.getTypeState();
            if (state == null || !(declaredType = field.getType()).isInterface() || (state = TypeState.forSubtraction((BigBang)this.bigbang, (TypeState)state, (TypeState)declaredType.getTypeFlow((BigBang)this.bigbang, true).getState())).isEmpty()) continue;
            String fieldKey = field.format("%H.%n");
            this.bigbang.getUnsupportedFeatures().addMessage(fieldKey, null, "Field " + fieldKey + " has declared type " + declaredType.toJavaName(true) + " which is incompatible with types in state: " + state);
        }
        if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue()) {
            for (AnalysisMethod method : this.aUniverse.getMethods()) {
                if (!method.isInvoked() && !method.isImplementationInvoked() || method.getAnnotation(Fold.class) != null) continue;
                this.checkName(method.format("%H.%n(%p)"), method);
            }
            for (AnalysisField field : this.aUniverse.getFields()) {
                if (!field.isAccessed()) continue;
                this.checkName(field.format("%H.%n"), null);
            }
            for (AnalysisType type : this.aUniverse.getTypes()) {
                if (!type.isInstantiated() && !type.isInTypeCheck()) continue;
                this.checkName(type.toJavaName(true), null);
            }
        }
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            List invocations;
            if (!method.isEntryPoint() || (invocations = method.getJavaInvocations()).size() <= 0) continue;
            String name = method.format("%H.%n(%p)");
            StringBuilder msg = new StringBuilder("Native entry point is also called from within Java. Invocations: ");
            String sep = "";
            for (AnalysisMethod invocation : invocations) {
                msg.append(sep).append(invocation.format("%H.%n(%p)"));
                sep = ", ";
            }
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, msg.toString());
        }
    }

    private void checkName(String name, AnalysisMethod method) {
        String lname = name.toLowerCase();
        if (lname.contains("hosted")) {
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, "Hosted element used at run time: " + name);
        } else if (SubstrateUtil.isBuildingLibgraal() && !name.startsWith("jdk.internal") && lname.contains("hotspot")) {
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, "HotSpot element used at run time: " + name);
        }
    }

    private void processNativeLibraryImports(NativeLibraries nativeLibs, MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        for (Method method : this.loader.findAnnotatedMethods(CConstant.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{method.getDeclaringClass()});
            nativeLibs.loadJavaMethod(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Method method : this.loader.findAnnotatedMethods(CFunction.class)) {
            nativeLibs.loadJavaMethod(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CStruct.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{clazz});
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(RawStructure.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{clazz});
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CPointerTo.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{clazz});
            nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CEnum.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{clazz});
            ResolvedJavaType type = metaAccess.lookupJavaType(clazz);
            classInitializationSupport.forceInitializeHosted(type);
            nativeLibs.loadJavaType(type);
        }
        for (Class clazz : this.loader.findAnnotatedClasses(CContext.class)) {
            RuntimeClassInitialization.eagerClassInitialization((Class[])new Class[]{clazz});
        }
        for (CLibrary cLibrary : this.loader.findAnnotations(CLibrary.class)) {
            nativeLibs.addLibrary(cLibrary.value());
        }
        nativeLibs.finish(this.tempDirectory());
        nativeLibs.reportErrors();
    }

    public AbstractBootImage getBuiltImage() {
        return this.image;
    }

    public BigBang getBigbang() {
        return this.bigbang;
    }

    private void printTypes() {
        for (HostedType type : this.hUniverse.getTypes()) {
            System.out.format("%8d %s  ", type.getTypeID(), type.toJavaName(true));
            if (type.getSuperclass() != null) {
                System.out.format("extends %d %s  ", type.getSuperclass().getTypeID(), type.getSuperclass().toJavaName(false));
            }
            if (type.getInterfaces().length > 0) {
                System.out.print("implements ");
                String sep = "";
                for (HostedInterface interf : type.getInterfaces()) {
                    System.out.format("%s%d %s", sep, interf.getTypeID(), interf.toJavaName(false));
                    sep = ", ";
                }
                System.out.print("  ");
            }
            if (type.getWrapped().isInstantiated()) {
                System.out.print("instantiated  ");
            }
            if (type.getWrapped().isInTypeCheck()) {
                System.out.print("inTypeCheck  ");
            }
            System.out.format("assignableFrom %s  ", NativeImageGenerator.matchesToString(type.getAssignableFromMatches()));
            System.out.format("instanceOf typeID %d, # %d  ", type.getInstanceOfFromTypeID(), type.getInstanceOfNumTypeIDs());
            int le = type.getHub().getLayoutEncoding();
            if (LayoutEncoding.isPrimitive(le)) {
                System.out.print("primitive  ");
            } else if (LayoutEncoding.isInterface(le)) {
                System.out.print("interface  ");
            } else if (LayoutEncoding.isAbstract(le)) {
                System.out.print("abstract  ");
            } else if (LayoutEncoding.isInstance(le)) {
                System.out.format("instance size %d  ", LayoutEncoding.getInstanceSize(le).rawValue());
            } else if (LayoutEncoding.isObjectArray(le)) {
                System.out.format("object array base %d shift %d scale %d  ", LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else if (LayoutEncoding.isPrimitiveArray(le)) {
                System.out.format("primitive array base %d shift %d scale %d  ", LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else {
                throw VMError.shouldNotReachHere();
            }
            System.out.println();
            for (HostedType sub : type.getSubTypes()) {
                System.out.format("               s %d %s\n", sub.getTypeID(), sub.toJavaName(false));
            }
            if (type.isInterface()) {
                for (HostedMethod method : this.hUniverse.getMethods()) {
                    if (method.getDeclaringClass() != type) continue;
                    NativeImageGenerator.printMethod(method, -1);
                }
                continue;
            }
            if (!type.isInstanceClass()) continue;
            HostedField[] fields = type.getInstanceFields(false);
            fields = Arrays.copyOf(fields, fields.length);
            Arrays.sort(fields, Comparator.comparing(HostedField::toString));
            for (HostedField field : fields) {
                System.out.println("               f " + field.getLocation() + ": " + field.format("%T %n"));
            }
            HostedMethod[] vtable = type.getVTable();
            for (int i = 0; i < vtable.length; ++i) {
                if (vtable[i] == null) continue;
                NativeImageGenerator.printMethod(vtable[i], i);
            }
            for (HostedMethod method : this.hUniverse.getMethods()) {
                if (method.getDeclaringClass() != type || method.hasVTableIndex()) continue;
                NativeImageGenerator.printMethod(method, -1);
            }
        }
    }

    private static void printMethod(HostedMethod method, int vtableIndex) {
        if (vtableIndex != -1) {
            System.out.print("               v " + vtableIndex + " ");
        } else {
            System.out.print("               m ");
        }
        if (method.hasVTableIndex()) {
            System.out.print(method.getVTableIndex() + " ");
        }
        System.out.print(method.format("%r %n(%p)") + ": " + method.getImplementations().length + " [");
        String sep = "";
        for (HostedMethod impl : method.getImplementations()) {
            System.out.print(sep + impl.getDeclaringClass().toJavaName(false));
            sep = ", ";
        }
        System.out.println("]");
    }

    private static String matchesToString(int[] matches) {
        if (matches == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < matches.length; i += 2) {
            result.append("[").append(matches[i]).append(", ").append(matches[i] + matches[i + 1] - 1).append("] ");
        }
        return result.toString();
    }

    public static Path generatedFiles(OptionValues optionValues) {
        String pathName = (String)SubstrateOptions.Path.getValue(optionValues);
        Path path = FileSystems.getDefault().getPath(pathName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw VMError.shouldNotReachHere("Output path is not a directory: " + pathName);
        }
        return path.toAbsolutePath();
    }

    public synchronized Path tempDirectory() {
        if (this.tempDirectory == null) {
            try {
                String tempName = NativeImageOptions.TempDirectory.getValue();
                if (tempName == null || tempName.isEmpty()) {
                    this.tempDirectory = Files.createTempDirectory("SVM-", new FileAttribute[0]);
                    this.deleteTempDirectory = true;
                } else {
                    this.tempDirectory = FileSystems.getDefault().getPath(tempName, new String[0]).resolve("SVM-" + System.currentTimeMillis());
                    assert (!Files.exists(this.tempDirectory, new LinkOption[0]));
                    Files.createDirectories(this.tempDirectory, new FileAttribute[0]);
                }
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        return this.tempDirectory.toAbsolutePath();
    }

    private static void deleteAll(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static <T extends Enum<T>> Set<T> parseCSVtoEnum(Class<T> enumType, String[] csvEnumValues) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (String enumValue : OptionUtils.flatten(",", csvEnumValues)) {
            try {
                result.add(Enum.valueOf(enumType, enumValue));
            }
            catch (IllegalArgumentException iae) {
                throw VMError.shouldNotReachHere("Value '" + enumValue + "' does not exist. Available values are:\n" + Arrays.toString(AMD64.CPUFeature.values()));
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$registerReplacements$20(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable factories, Providers providers, SnippetReflectionProvider snippetReflection, Map lowerings, boolean hosted, GraalFeature feature) {
        feature.registerLowerings(runtimeConfig, options, factories, providers, snippetReflection, lowerings, hosted);
    }

    private static /* synthetic */ void lambda$doRun$3(FeatureImpl.AfterCompilationAccessImpl config, Feature feature) {
        feature.afterCompilation((Feature.AfterCompilationAccess)config);
    }

    static class SubstitutionInvocationPlugins
    extends InvocationPlugins {
        private AnnotationSubstitutionProcessor annotationSubstitutionProcessor;

        SubstitutionInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutionProcessor) {
            this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        }

        protected void register(InvocationPlugin plugin, boolean isOptional, boolean allowOverwrite, Type declaringClass, String name, Type ... argumentTypes) {
            Class<?> targetClass = declaringClass instanceof Class ? this.annotationSubstitutionProcessor.getTargetClass(declaringClass) : declaringClass;
            super.register(plugin, isOptional, allowOverwrite, targetClass, name, argumentTypes);
        }
    }
}

