/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Modifier;
import java.util.function.Consumer;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
public class ClassInitializationFeature
implements Feature {
    private ClassInitializationSupport classInitializationSupport;

    public static void processClassInitializationOptions(FeatureImpl.AfterRegistrationAccessImpl access, ClassInitializationSupport initializationSupport) {
        ClassInitializationFeature.processOption(access, Options.DelayClassInitialization, arg_0 -> ((ClassInitializationSupport)initializationSupport).delayClassInitialization(arg_0));
        ClassInitializationFeature.processOption(access, Options.RerunClassInitialization, arg_0 -> ((ClassInitializationSupport)initializationSupport).rerunClassInitialization(arg_0));
        ClassInitializationFeature.processOption(access, Options.EagerClassInitialization, arg_0 -> ((ClassInitializationSupport)initializationSupport).eagerClassInitialization(arg_0));
    }

    private static void processOption(FeatureImpl.AfterRegistrationAccessImpl access, HostedOptionKey<String[]> option, Consumer<Class<?>[]> handler) {
        for (String className : OptionUtils.flatten(",", option.getValue())) {
            if (className.length() <= 0) continue;
            Class<?> clazz = access.findClassByName(className);
            if (clazz == null) {
                throw UserError.abort("Could not find class " + className + " that is provided by the option " + SubstrateOptionsParser.commandArgument(option, className));
            }
            handler.accept(new Class[]{clazz});
        }
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.classInitializationSupport = access.getHostVM().getClassInitializationSupport();
        this.classInitializationSupport.setUnsupportedFeatures(access.getBigBang().getUnsupportedFeatures());
        access.registerObjectReplacer(this::checkImageHeapInstance);
    }

    private Object checkImageHeapInstance(Object obj) {
        if (obj != null && this.classInitializationSupport.shouldInitializeAtRuntime(obj.getClass())) {
            throw new UnsupportedFeatureException("No instances are allowed in the image heap for a class that is initialized or reinitialized at image runtime: " + obj.getClass().getTypeName());
        }
        return obj;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.classInitializationSupport.checkDelayedInitialization();
        for (AnalysisType type : access.getUniverse().getTypes()) {
            DynamicHub hub;
            if (!type.isInTypeCheck() && !type.isInstantiated() || (hub = access.getHostVM().dynamicHub((ResolvedJavaType)type)).getClassInitializationInfo() != null) continue;
            this.buildClassInitializationInfo(access, type, hub);
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.classInitializationSupport.setUnsupportedFeatures(null);
        if (Options.PrintClassInitialization.getValue().booleanValue()) {
            for (ClassInitializationSupport.InitKind kind : ClassInitializationSupport.InitKind.values()) {
                ReportUtils.report((String)("Classes of type " + (Object)((Object)kind)), (String)"./reports", (String)(kind.toString().toLowerCase() + "_classes"), (String)"txt", writer -> this.classInitializationSupport.classesWithKind(kind).stream().map(Class::getTypeName).sorted().forEach(writer::println));
            }
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        this.classInitializationSupport.checkDelayedInitialization();
    }

    private void buildClassInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type, DynamicHub hub) {
        ClassInitializationInfo info;
        if (this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type)) {
            AnalysisMethod classInitializer = type.getClassInitializer();
            if (classInitializer != null && classInitializer.getCode() != null) {
                access.registerAsCompiled(classInitializer);
            }
            info = new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)classInitializer));
        } else {
            info = ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
        }
        hub.setClassInitializationInfo(info, ClassInitializationFeature.hasDefaultMethods((ResolvedJavaType)type), ClassInitializationFeature.declaresDefaultMethods((ResolvedJavaType)type));
    }

    private static boolean hasDefaultMethods(ResolvedJavaType type) {
        if (!type.isInterface() && type.getSuperclass() != null && ClassInitializationFeature.hasDefaultMethods(type.getSuperclass())) {
            return true;
        }
        for (ResolvedJavaType iface : type.getInterfaces()) {
            if (!ClassInitializationFeature.hasDefaultMethods(iface)) continue;
            return true;
        }
        return ClassInitializationFeature.declaresDefaultMethods(type);
    }

    static boolean declaresDefaultMethods(ResolvedJavaType type) {
        if (!type.isInterface()) {
            return false;
        }
        for (ResolvedJavaMethod method : ClassInitializationFeature.toWrappedType(type).getDeclaredMethods()) {
            if (!method.isDefault()) continue;
            assert (!Modifier.isStatic(method.getModifiers())) : "Default method that is static?";
            return true;
        }
        return false;
    }

    private static ResolvedJavaType toWrappedType(ResolvedJavaType type) {
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrappedWithoutResolve();
        }
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrappedWithoutResolve();
        }
        return type;
    }

    public static class Options {
        @APIOption(name="delay-class-initialization-to-runtime")
        @Option(help={"A comma-separated list of classes (and implicitly all of their subclasses) that are initialized at runtime and not during image building"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DelayClassInitialization = new HostedOptionKey<Object>(null);
        @APIOption(name="rerun-class-initialization-at-runtime")
        @Option(help={"A comma-separated list of classes (and implicitly all of their subclasses) that are initialized both at runtime and during image building"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> RerunClassInitialization = new HostedOptionKey<Object>(null);
        @Option(help={"A comma-separated list of classes (and implicitly all of their superclasses) that are initialized during image building"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> EagerClassInitialization = new HostedOptionKey<Object>(null);
        @Option(help={"Prints class initialization info for all classes detected by analysis."}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> PrintClassInitialization = new HostedOptionKey<Boolean>(false);
    }
}

