/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.CommonClassInitializationSupport;
import jdk.vm.ci.meta.MetaAccessProvider;

public class EagerClassInitialization
extends CommonClassInitializationSupport {
    public EagerClassInitialization(MetaAccessProvider metaAccess) {
        super(metaAccess);
    }

    @Override
    ClassInitializationSupport.InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoizeEager) {
        ClassInitializationSupport.InitKind result = (ClassInitializationSupport.InitKind)((Object)this.classInitKinds.get(clazz));
        if (result != null) {
            return result;
        }
        result = ClassInitializationSupport.InitKind.EAGER;
        if (clazz.getSuperclass() != null) {
            result = result.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoizeEager));
        }
        if ((result = result.max(this.processInterfaces(clazz, memoizeEager))) != ClassInitializationSupport.InitKind.EAGER || memoizeEager) {
            if (result != ClassInitializationSupport.InitKind.DELAY) {
                result = result.max(this.ensureClassInitialized(clazz));
            }
            ClassInitializationSupport.InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value";
        }
        return result;
    }

    private ClassInitializationSupport.InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        ClassInitializationSupport.InitKind result = ClassInitializationSupport.InitKind.EAGER;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface)) ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    @Override
    public void forceInitializeHierarchy(Class<?> clazz) {
        this.ensureClassInitialized(clazz);
        this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz) {
        ClassInitializationSupport.InitKind initKind = this.computeInitKindAndMaybeInitializeClass(clazz);
        if (initKind == ClassInitializationSupport.InitKind.DELAY) {
            throw UserError.abort("Cannot delay running the class initializer because class must be initialized for internal purposes: " + clazz.getTypeName());
        }
    }
}

