/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.config.ConfigurationParser;
import com.oracle.svm.hosted.config.ProxyConfigurationParser;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.DynamicProxySupport;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
public final class DynamicProxyFeature
implements Feature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        DynamicProxySupport dynamicProxySupport = new DynamicProxySupport(access.getImageClassLoader().getClassLoader());
        ImageSingletons.add(DynamicProxyRegistry.class, (Object)dynamicProxySupport);
        ProxyConfigurationParser parser = new ProxyConfigurationParser(access.getImageClassLoader(), dynamicProxySupport);
        ConfigurationParser.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "dynamic proxy", Options.DynamicProxyConfigurationFiles, Options.DynamicProxyConfigurationResources, "proxy-config.json");
    }

    public static class Options {
        @Option(help={"file:doc-files/ProxyConfigurationFilesHelp.txt"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DynamicProxyConfigurationFiles = new HostedOptionKey<Object>(null);
        @Option(help={"Resources describing program elements to be made available for reflection (see ProxyConfigurationFiles)."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DynamicProxyConfigurationResources = new HostedOptionKey<Object>(null);
    }
}

