/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.impl.IsolateSupport;

public final class IsolateSupportImpl
implements IsolateSupport {
    static void initialize() {
        ImageSingletons.add(IsolateSupport.class, (Object)new IsolateSupportImpl());
    }

    private IsolateSupportImpl() {
    }

    public IsolateThread createIsolate(Isolates.CreateIsolateParameters parameters) throws Isolates.IsolateException {
        CEntryPointCreateIsolateParameters params = (CEntryPointCreateIsolateParameters)StackValue.get(CEntryPointCreateIsolateParameters.class);
        params.setReservedSpaceSize(parameters.getReservedAddressSpaceSize());
        params.setVersion(1);
        CEntryPointNativeFunctions.IsolatePointer isolatePtr = (CEntryPointNativeFunctions.IsolatePointer)StackValue.get(CEntryPointNativeFunctions.IsolatePointer.class);
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.createIsolate(params, isolatePtr));
        Isolate isolate = isolatePtr.read();
        return this.getCurrentThread(isolate);
    }

    public IsolateThread attachCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        CEntryPointNativeFunctions.IsolateThreadPointer isolateThread = (CEntryPointNativeFunctions.IsolateThreadPointer)StackValue.get(CEntryPointNativeFunctions.IsolateThreadPointer.class);
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.attachThread(isolate, isolateThread));
        return isolateThread.read();
    }

    public IsolateThread getCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getCurrentThread(isolate);
    }

    public Isolate getIsolate(IsolateThread thread) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getCurrentThreadIsolate(thread);
    }

    public void detachThread(IsolateThread thread) throws Isolates.IsolateException {
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.detachThread(thread));
    }

    public void tearDownIsolate(IsolateThread thread) throws Isolates.IsolateException {
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.tearDownIsolate(this.getIsolate(thread)));
    }

    private static void throwOnError(int code) {
        if (code != 0) {
            String message = CEntryPointErrors.getDescription(code);
            throw new Isolates.IsolateException(message);
        }
    }
}

