/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class HeapPolicyOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AlignedHeapChunkSize": {
                return OptionDescriptor.create((String)"AlignedHeapChunkSize", (OptionType)OptionType.Debug, Long.class, (String)"The size of an aligned chunk.", HeapPolicyOptions.class, (String)"AlignedHeapChunkSize", HeapPolicyOptions.AlignedHeapChunkSize);
            }
            case "LargeArrayThreshold": {
                return OptionDescriptor.create((String)"LargeArrayThreshold", (OptionType)OptionType.Debug, Long.class, (String)"How many bytes is enough to allocate an unaligned chunk for an array?  0 implies (AlignedHeapChunkSize / 8).", HeapPolicyOptions.class, (String)"LargeArrayThreshold", HeapPolicyOptions.LargeArrayThreshold);
            }
            case "MaximumHeapSizePercent": {
                return OptionDescriptor.create((String)"MaximumHeapSizePercent", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum heap size as percent of physical memory", HeapPolicyOptions.class, (String)"MaximumHeapSizePercent", HeapPolicyOptions.MaximumHeapSizePercent);
            }
            case "TraceHeapChunks": {
                return OptionDescriptor.create((String)"TraceHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.", HeapPolicyOptions.class, (String)"TraceHeapChunks", HeapPolicyOptions.TraceHeapChunks);
            }
            case "UserRequestedGCPolicy": {
                return OptionDescriptor.create((String)"UserRequestedGCPolicy", (OptionType)OptionType.Debug, String.class, (String)"Policy used when users request garbage collection.", HeapPolicyOptions.class, (String)"UserRequestedGCPolicy", HeapPolicyOptions.UserRequestedGCPolicy);
            }
            case "UserRequestedGCThreshold": {
                return OptionDescriptor.create((String)"UserRequestedGCThreshold", (OptionType)OptionType.Debug, Long.class, (String)"Defines the upper bound for the number of remaining bytes in the young generation that cause a collection when `System.gc` is called.", HeapPolicyOptions.class, (String)"UserRequestedGCThreshold", HeapPolicyOptions.UserRequestedGCThreshold);
            }
            case "ZapChunks": {
                return OptionDescriptor.create((String)"ZapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Zap memory chunks", HeapPolicyOptions.class, (String)"ZapChunks", HeapPolicyOptions.ZapChunks);
            }
            case "ZapConsumedHeapChunks": {
                return OptionDescriptor.create((String)"ZapConsumedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Zap consumed memory chunks", HeapPolicyOptions.class, (String)"ZapConsumedHeapChunks", HeapPolicyOptions.ZapConsumedHeapChunks);
            }
            case "ZapProducedHeapChunks": {
                return OptionDescriptor.create((String)"ZapProducedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Zap produced memory chunks", HeapPolicyOptions.class, (String)"ZapProducedHeapChunks", HeapPolicyOptions.ZapProducedHeapChunks);
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 9;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("AlignedHeapChunkSize");
                    }
                    case 1: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("LargeArrayThreshold");
                    }
                    case 2: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("MaximumHeapSizePercent");
                    }
                    case 3: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("TraceHeapChunks");
                    }
                    case 4: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("UserRequestedGCPolicy");
                    }
                    case 5: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("UserRequestedGCThreshold");
                    }
                    case 6: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapChunks");
                    }
                    case 7: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapConsumedHeapChunks");
                    }
                    case 8: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapProducedHeapChunks");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

