/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class MemoryWalkerImpl
extends MemoryWalker {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public MemoryWalkerImpl() {
    }

    @Override
    public boolean visitMemory(MemoryWalker.Visitor memoryWalkerVisitor) {
        MemoryWalkerVMOperation vmOperation = new MemoryWalkerVMOperation(memoryWalkerVisitor);
        vmOperation.enqueue();
        return vmOperation.getResult();
    }

    protected static final class MemoryWalkerVMOperation
    extends VMOperation {
        private MemoryWalker.Visitor memoryWalkerVisitor;
        private boolean result;

        protected MemoryWalkerVMOperation(MemoryWalker.Visitor memoryVisitor) {
            super("MemoryWalkerImpl.visitMemory", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT);
            this.memoryWalkerVisitor = memoryVisitor;
            this.result = false;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocation would change the memory being visited.")
        public void operate() {
            ThreadLocalAllocation.disableThreadLocalAllocation();
            boolean continueVisiting = true;
            if (continueVisiting) {
                continueVisiting = HeapImpl.getHeapImpl().walkHeap(this.memoryWalkerVisitor);
            }
            if (continueVisiting) {
                ImageCodeInfo imageCodeInfo = (ImageCodeInfo)ImageSingletons.lookup(ImageCodeInfo.class);
                continueVisiting = imageCodeInfo.walkImageCode(this.memoryWalkerVisitor);
            }
            if (continueVisiting) {
                continueVisiting = CodeInfoTable.getRuntimeCodeCache().walkRuntimeMethods(this.memoryWalkerVisitor);
            }
            this.result = continueVisiting;
        }

        protected boolean getResult() {
            return this.result;
        }
    }
}

