/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class PinnedAllocatorImpl
extends PinnedAllocator {
    private static final PinnedAllocator.PinnedAllocationLifecycleError NOT_OPEN_ERROR = new PinnedAllocator.PinnedAllocationLifecycleError("PinnedAllocator not open in this thread");
    static final FastThreadLocalObject<PinnedAllocatorImpl> openPinnedAllocator = FastThreadLocalFactory.createObject(PinnedAllocatorImpl.class);
    public static final LocationIdentity OPEN_PINNED_ALLOCATOR_IDENTITY = openPinnedAllocator.getLocationIdentity();
    private PinnedAllocatorImpl next;
    private LifeCyclePhase phase = LifeCyclePhase.INITIALIZED;
    private ListNode<AlignedHeapChunk.AlignedHeader> pinnedAlignedChunks;
    private AlignedHeapChunk.AlignedHeader reusedAlignedChunk;
    private ListNode<UnalignedHeapChunk.UnalignedHeader> pinnedUnalignedChunks;

    @Fold
    static Log log() {
        return Log.noopLog();
    }

    PinnedAllocatorImpl() {
    }

    @Override
    public PinnedAllocator open() {
        if (this.phase != LifeCyclePhase.INITIALIZED) {
            throw new PinnedAllocator.PinnedAllocationLifecycleError("PinnedAllocatorImpl.open: Already opened.");
        }
        if (openPinnedAllocator.get() != null) {
            throw new PinnedAllocator.PinnedAllocationLifecycleError("PinnedAllocatorImpl.open: Only one PinnedAllocator can be open per thread");
        }
        new VMOperation("PinnedAllocatorImpl.open", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT){

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while opening a PinnedAllocator. A GC can corrupt the TLAB.")
            protected void operate() {
                UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch();
                openPinnedAllocator.set(this.getQueuingVMThread(), PinnedAllocatorImpl.this);
                PinnedAllocatorImpl.this.phase = LifeCyclePhase.OPENED;
                PinnedAllocatorImpl.this.pushPinnedAllocatorImpl();
                PinnedAllocatorImpl.this.tryReuseExistingChunk(ThreadLocalAllocation.pinnedTLAB.getAddress(this.getQueuingVMThread()));
                VMError.guarantee(gcEpoch.equal(HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch()), "GC occured while opening a PinnedAllocator. This can corrupt the TLAB.");
            }
        }.enqueue();
        assert (this.phase == LifeCyclePhase.OPENED) : "PinnedAllocatorImpl.open: VMOperation failed to open.";
        return this;
    }

    private void pushPinnedAllocatorImpl() {
        VMOperation.guaranteeInProgress("PinnedAllocatorImpl.pushPinnedAllocatorImpl but not in VMOperation.");
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.pushPinnedAllocatorImpl: ").object(this);
        assert (this.next == null) : "PinnedAllocatorImpl.pushPinnedAllocatorImpl but not .next == null.";
        this.next = HeapImpl.getHeapImpl().pinnedAllocatorListHead;
        HeapImpl.getHeapImpl().pinnedAllocatorListHead = this;
        PinnedAllocatorImpl.log().string("]");
    }

    private void tryReuseExistingChunk(ThreadLocalAllocation.Descriptor tlab) {
        VMOperation.guaranteeInProgress("PinnedAllocatorImpl.pushPinnedAllocatorImpl.tryReuseExistingChunk but not in VMOperation.");
        Space pSpace = HeapImpl.getHeapImpl().getOldGeneration().getPinnedFromSpace();
        AlignedHeapChunk.AlignedHeader largestChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        UnsignedWord largestAvailable = (UnsignedWord)WordFactory.zero();
        AlignedHeapChunk.AlignedHeader aChunk = pSpace.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            UnsignedWord chunkAvailable = AlignedHeapChunk.availableObjectMemoryOfAlignedHeapChunk(aChunk);
            if (chunkAvailable.aboveThan(largestAvailable) && chunkAvailable.aboveThan(10240)) {
                largestChunk = aChunk;
                largestAvailable = chunkAvailable;
            }
            aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext();
        }
        assert (ThreadLocalAllocation.verifyUninitialized(tlab));
        if (largestChunk.isNonNull()) {
            PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.tryReuseExistingChunk:").string("  tlab: ").hex((WordBase)tlab);
            PinnedAllocatorImpl.log().string("  available bytes: ").unsigned((WordBase)largestAvailable);
            PinnedAllocatorImpl.log().string("  re-using largestChunk: ").hex((WordBase)largestChunk);
            PinnedAllocatorImpl.log().string("  chunk space: ").string(largestChunk.getSpace().getName());
            PinnedAllocatorImpl.log().string("]").newline();
            pSpace.extractAlignedHeapChunk(largestChunk);
            this.reuseExistingChunkUninterruptibly(largestChunk, tlab);
        } else {
            PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.tryReuseExistingChunk:").string("  tlab: ").hex((WordBase)tlab).string(" available bytes: ").unsigned((WordBase)largestAvailable).string(" not reusing a chunk]").newline();
        }
    }

    @Uninterruptible(reason="Holds uninterruptible memory and modifies TLAB.")
    private void reuseExistingChunkUninterruptibly(AlignedHeapChunk.AlignedHeader largestChunk, ThreadLocalAllocation.Descriptor tlab) {
        tlab.setAlignedChunk(largestChunk);
        ThreadLocalAllocation.resumeAllocationChunk(tlab);
        this.reusedAlignedChunk = largestChunk;
    }

    public void ensureOpen() {
        if (openPinnedAllocator.get() != this) {
            throw NOT_OPEN_ERROR;
        }
        assert (this.phase == LifeCyclePhase.OPENED) : "PinnedAllocatorImpl.ensureOpen: phase != OPENED";
    }

    @SubstrateForeignCallTarget
    private static Object slowPathNewInstance(PinnedAllocatorImpl pinnedAllocator, DynamicHub hub) {
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.slowPathNewInstance: ").object(pinnedAllocator).string("  hub: ").string(hub.getName()).newline();
        pinnedAllocator.ensureOpen();
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.pinnedTLAB.getAddress();
        Object result = ThreadLocalAllocation.allocateNewInstance(hub, tlab, true);
        pinnedAllocator.pushPinnedChunks(tlab);
        PinnedAllocatorImpl.log().string("  ]").newline();
        return result;
    }

    @SubstrateForeignCallTarget
    private static Object slowPathNewArray(PinnedAllocatorImpl pinnedAllocator, DynamicHub hub, int length) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.slowPathNewArray: ").object(pinnedAllocator).string("  hub: ").string(hub.getName()).string("  length: ").signed(length).newline();
        pinnedAllocator.ensureOpen();
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.pinnedTLAB.getAddress();
        Object result = ThreadLocalAllocation.allocateNewArray(hub, length, tlab, true);
        pinnedAllocator.pushPinnedChunks(tlab);
        PinnedAllocatorImpl.log().string("  ]").newline();
        return result;
    }

    @Override
    public void close() {
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.close: ").object(this).newline();
        this.ensureOpen();
        new VMOperation("PinnedAllocatorImpl.open", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT){

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while closing a PinnedAllocator. A GC can corrupt the TLAB.")
            protected void operate() {
                UnsignedWord gcEpoch = HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch();
                ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.pinnedTLAB.getAddress(this.getQueuingVMThread());
                ThreadLocalAllocation.retireToSpace(tlab, HeapImpl.getHeapImpl().getOldGeneration().getPinnedFromSpace());
                assert (ThreadLocalAllocation.verifyUninitialized(tlab));
                openPinnedAllocator.set(this.getQueuingVMThread(), null);
                PinnedAllocatorImpl.this.phase = LifeCyclePhase.CLOSED;
                VMError.guarantee(gcEpoch.equal(HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch()), "GC occured while closing a PinnedAllocator. This can corrupt the TLAB.");
            }
        }.enqueue();
        assert (this.phase == LifeCyclePhase.CLOSED) : "PinnedAllocatorImpl.close: VMOperation failed to close.";
        PinnedAllocatorImpl.log().string("  ]").newline();
    }

    @Override
    public void release() {
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.release: ").object(this).string(" ]").newline();
        if (this.phase != LifeCyclePhase.CLOSED) {
            throw new PinnedAllocator.PinnedAllocationLifecycleError("PinnedAllocatorImpl.release, but not closed");
        }
        this.phase = LifeCyclePhase.RELEASED;
    }

    private void pushPinnedChunks(ThreadLocalAllocation.Descriptor tlab) {
        UnalignedHeapChunk.UnalignedHeader uChunk;
        AlignedHeapChunk.AlignedHeader aChunk = tlab.getAlignedChunk();
        if (aChunk.isNonNull() && this.reusedAlignedChunk.notEqual((ComparableWord)aChunk) && (this.pinnedAlignedChunks == null || ((AlignedHeapChunk.AlignedHeader)this.pinnedAlignedChunks.value).notEqual((ComparableWord)aChunk))) {
            PinnedAllocatorImpl.log().string("  pinning aligned chunk ").hex((WordBase)aChunk).newline();
            this.pinnedAlignedChunks = new ListNode<AlignedHeapChunk.AlignedHeader>(aChunk, this.pinnedAlignedChunks);
        }
        if ((uChunk = tlab.getUnalignedChunk()).isNonNull() && (this.pinnedUnalignedChunks == null || ((UnalignedHeapChunk.UnalignedHeader)this.pinnedUnalignedChunks.value).notEqual((ComparableWord)uChunk))) {
            PinnedAllocatorImpl.log().string("  pinning unaligned chunk ").hex((WordBase)uChunk).newline();
            this.pinnedUnalignedChunks = new ListNode<UnalignedHeapChunk.UnalignedHeader>(uChunk, this.pinnedUnalignedChunks);
        }
    }

    static void markPinnedChunks() {
        PinnedAllocatorImpl.log().string("[PinnedAllocatorImpl.markPinnedChunks:").newline();
        PinnedAllocatorImpl newListHead = null;
        PinnedAllocatorImpl cur = HeapImpl.getHeapImpl().pinnedAllocatorListHead;
        while (cur != null) {
            PinnedAllocatorImpl next = cur.next;
            switch (cur.phase) {
                case OPENED: 
                case CLOSED: {
                    PinnedAllocatorImpl.log().string("  [marking chunks of allocator: ").object(cur).newline();
                    PinnedAllocatorImpl.log().string("    aligned chunks: ");
                    if (cur.reusedAlignedChunk.isNonNull()) {
                        PinnedAllocatorImpl.markPinnedChunk(cur.reusedAlignedChunk);
                    }
                    PinnedAllocatorImpl.markPinnedChunks(cur.pinnedAlignedChunks);
                    PinnedAllocatorImpl.log().string("    unaligned chunks: ");
                    PinnedAllocatorImpl.markPinnedChunks(cur.pinnedUnalignedChunks);
                    cur.next = newListHead;
                    newListHead = cur;
                    PinnedAllocatorImpl.log().string("]").newline();
                    break;
                }
                case RELEASED: {
                    PinnedAllocatorImpl.log().string("  [removing released allocator from list: ").object(cur).string(" ]").newline();
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            cur = next;
        }
        HeapImpl.getHeapImpl().pinnedAllocatorListHead = newListHead;
        PinnedAllocatorImpl.log().string("]").newline();
    }

    private static void markPinnedChunks(ListNode<? extends HeapChunk.Header<?>> head) {
        ListNode<HeapChunk.Header<Object>> node = head;
        while (node != null) {
            PinnedAllocatorImpl.markPinnedChunk((HeapChunk.Header)node.value);
            node = node.next;
        }
        PinnedAllocatorImpl.log().newline();
    }

    private static void markPinnedChunk(HeapChunk.Header<?> chunk) {
        PinnedAllocatorImpl.log().hex((WordBase)chunk).string("  ");
        chunk.setPinned(true);
    }

    private static class ListNode<T extends WordBase> {
        final T value;
        final ListNode<T> next;

        ListNode(T value, ListNode<T> next) {
            this.value = value;
            this.next = next;
        }
    }

    private static enum LifeCyclePhase {
        INITIALIZED,
        OPENED,
        CLOSED,
        RELEASED;

    }
}

