/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.meta.SubstrateBasicLoweringProvider;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.MatchRuleRegistry;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.core.phases.CommunityCompilerConfiguration;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

public class GraalConfiguration {
    private static final String COMPILER_CONFIGURATION_NAME = "community";

    public static GraalConfiguration instance() {
        return (GraalConfiguration)ImageSingletons.lookup(GraalConfiguration.class);
    }

    public static void setDefaultIfEmpty() {
        if (!ImageSingletons.contains(GraalConfiguration.class)) {
            ImageSingletons.add(GraalConfiguration.class, (Object)new GraalConfiguration());
        }
    }

    public LoweringProvider createLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls) {
        return new SubstrateBasicLoweringProvider(metaAccess, foreignCalls, ConfigurationValues.getTarget());
    }

    public Suites createSuites(OptionValues options, boolean hosted) {
        return Suites.createSuites((CompilerConfiguration)new CommunityCompilerConfiguration(), (OptionValues)options);
    }

    public String getCompilerConfigurationName() {
        return COMPILER_CONFIGURATION_NAME;
    }

    public void populateMatchRuleRegistry(HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>> matchRuleRegistry) {
        matchRuleRegistry.put(AMD64NodeMatchRules.class, (EconomicMap<Class<? extends Node>, List<MatchStatement>>)MatchRuleRegistry.createRules(AMD64NodeMatchRules.class));
    }

    public Backend createBackend(Providers newProviders) {
        return SubstrateBackendFactory.get().newBackend(newProviders);
    }

    public void runAdditionalCompilerPhases(StructuredGraph graph, Feature graalFeature) {
    }

    public void removeDeoptTargetOptimizations(Suites suites) {
    }

    public ListIterator<BasePhase<? super HighTierContext>> createHostedInliners(PhaseSuite<HighTierContext> highTier) {
        return null;
    }
}

