/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.util.ByteArrayReader;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class ReferenceMapDecoder {
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    public static boolean walkOffsetsFromPointer(PointerBase baseAddress, byte[] referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor) {
        assert (referenceMapIndex != -1L);
        assert (referenceMapEncoding != null);
        UnsignedWord uncompressedSize = WordFactory.unsigned((int)FrameAccess.uncompressedReferenceSize());
        UnsignedWord compressedSize = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getReferenceSize());
        Pointer objRef = (Pointer)baseAddress;
        long idx = referenceMapIndex;
        block0: while (true) {
            long b;
            long gap = 0L;
            int shift = 0;
            do {
                b = ByteArrayReader.getU1(referenceMapEncoding, idx);
                gap |= (b & 0x7FL) << shift;
                shift += 7;
                ++idx;
            } while ((b & 0x80L) != 0L);
            long count = 0L;
            shift = 0;
            do {
                b = ByteArrayReader.getU1(referenceMapEncoding, idx);
                count |= (b & 0x7FL) << shift;
                shift += 7;
                ++idx;
            } while ((b & 0x80L) != 0L);
            if ((b & 0x40L) != 0L && shift < 64) {
                count |= -1L << shift;
            }
            if (gap == 0L && count == 0L) break;
            objRef = objRef.add(WordFactory.unsigned((long)gap));
            boolean compressed = count < 0L;
            UnsignedWord refSize = compressed ? compressedSize : uncompressedSize;
            count = count < 0L ? -count : count;
            long c = 0L;
            while (true) {
                if (c >= count) continue block0;
                boolean visitResult = visitor.visitObjectReferenceInline(objRef, compressed);
                if (!visitResult) {
                    return false;
                }
                objRef = objRef.add(refSize);
                ++c;
            }
            break;
        }
        return true;
    }
}

