/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Hybrid;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.hub.AnnotatedSuperInfo;
import com.oracle.svm.core.hub.AnnotationsEncoding;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.ClassInitializationInfo;
import com.oracle.svm.core.hub.GenericInfo;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.hub.Target_java_lang_Class_ReflectionData;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import sun.reflect.ReflectionFactory;
import sun.security.util.SecurityConstants;

@Hybrid
@Substitute
@TargetClass(value=Class.class)
@SuppressFBWarnings(value={"Se"}, justification="DynamicHub must implement Serializable for compatibility with java.lang.Class, not because of actual serialization")
public final class DynamicHub
implements JavaKind.FormatWithToString,
AnnotatedElement,
Type,
GenericDeclaration,
Serializable {
    private static final int SYNTHETIC = 4096;
    private String name;
    private int layoutEncoding;
    private int typeID;
    private int monitorOffset;
    private int hashCodeOffset;
    private boolean isLocalClass;
    private boolean isInstantiated;
    private final boolean isStatic;
    private final boolean isSynthetic;
    private final DynamicHub superHub;
    private final DynamicHub componentHub;
    private DynamicHub arrayHub;
    private DynamicHub enclosingClass;
    private Object interfacesEncoding;
    private int[] assignableFromMatches;
    private Enum<?>[] enumConstants;
    private int referenceMapIndex;
    private SharedType metaType;
    private String sourceFileName;
    private Object annotationsEncoding;
    private boolean hasDefaultMethods;
    private boolean declaresDefaultMethods;
    private ClassInitializationInfo classInitializationInfo;
    private final Target_java_lang_ClassLoader classloader;
    @Hybrid.Bitset
    private BitSet instanceOfBits;
    @Hybrid.Array
    private CFunctionPointer[] vtable;
    private GenericInfo genericInfo;
    private AnnotatedSuperInfo annotatedSuperInfo;
    private static ProtectionDomain allPermDomain;
    private static final ReflectionData NO_REFLECTION_DATA;
    private ReflectionData rd = NO_REFLECTION_DATA;
    private static final ReflectionFactory reflectionFactory;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DynamicHub(String name, boolean isLocalClass, DynamicHub superType, DynamicHub componentHub, String sourceFileName, boolean isStatic, boolean isSynthetic, Target_java_lang_ClassLoader classLoader) {
        this.name = name;
        this.isLocalClass = isLocalClass;
        this.superHub = superType;
        this.componentHub = componentHub;
        this.sourceFileName = sourceFileName;
        this.isStatic = isStatic;
        this.isSynthetic = isSynthetic;
        this.classloader = classLoader;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setClassInitializationInfo(ClassInitializationInfo classInitializationInfo, boolean hasDefaultMethods, boolean declaresDefaultMethods) {
        this.classInitializationInfo = classInitializationInfo;
        this.hasDefaultMethods = hasDefaultMethods;
        this.declaresDefaultMethods = declaresDefaultMethods;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setData(int layoutEncoding, int typeID, int monitorOffset, int hashCodeOffset, int[] assignableFromMatches, BitSet instanceOfBits, CFunctionPointer[] vtable, long referenceMapIndex, boolean isInstantiated) {
        this.layoutEncoding = layoutEncoding;
        this.typeID = typeID;
        this.monitorOffset = monitorOffset;
        this.hashCodeOffset = hashCodeOffset;
        this.assignableFromMatches = assignableFromMatches;
        this.instanceOfBits = instanceOfBits;
        this.vtable = vtable;
        if ((long)((int)referenceMapIndex) != referenceMapIndex) {
            throw VMError.shouldNotReachHere("Reference map index not within integer range, need to switch field from int to long");
        }
        this.referenceMapIndex = (int)referenceMapIndex;
        this.isInstantiated = isInstantiated;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setArrayHub(DynamicHub arrayHub) {
        assert ((this.arrayHub == null || this.arrayHub == arrayHub) && arrayHub != null);
        assert (arrayHub.getComponentHub() == this);
        this.arrayHub = arrayHub;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setEnclosingClass(DynamicHub enclosingClass) {
        assert ((this.enclosingClass == null || this.enclosingClass == enclosingClass) && enclosingClass != null);
        this.enclosingClass = enclosingClass;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setGenericInfo(GenericInfo genericInfo) {
        this.genericInfo = genericInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public GenericInfo getGenericInfo() {
        return this.genericInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setAnnotatedSuperInfo(AnnotatedSuperInfo annotatedSuperInfo) {
        this.annotatedSuperInfo = annotatedSuperInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public AnnotatedSuperInfo getAnnotatedSuperInfo() {
        return this.annotatedSuperInfo;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setInterfacesEncoding(Object interfacesEncoding) {
        this.interfacesEncoding = interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getInterfacesEncoding() {
        return this.interfacesEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setAnnotationsEncoding(Object annotationsEncoding) {
        this.annotationsEncoding = annotationsEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getAnnotationsEncoding() {
        return this.annotationsEncoding;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setEnumConstants(Enum<?>[] enumConstants) {
        this.enumConstants = enumConstants;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setMetaType(SharedType metaType) {
        this.metaType = metaType;
    }

    public boolean hasDefaultMethods() {
        return this.hasDefaultMethods;
    }

    public boolean declaresDefaultMethods() {
        return this.declaresDefaultMethods;
    }

    public ClassInitializationInfo getClassInitializationInfo() {
        return this.classInitializationInfo;
    }

    public boolean isInitialized() {
        return this.classInitializationInfo.isInitialized();
    }

    public void ensureInitialized() {
        if (!this.classInitializationInfo.isInitialized()) {
            this.classInitializationInfo.initialize(this);
        }
    }

    public SharedType getMetaType() {
        return this.metaType;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getLayoutEncoding() {
        return this.layoutEncoding;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public int getMonitorOffset() {
        return this.monitorOffset;
    }

    public int getHashCodeOffset() {
        return this.hashCodeOffset;
    }

    public DynamicHub getSuperHub() {
        return this.superHub;
    }

    public DynamicHub getComponentHub() {
        return this.componentHub;
    }

    public DynamicHub getArrayHub() {
        return this.arrayHub;
    }

    public int[] getAssignableFromMatches() {
        return this.assignableFromMatches;
    }

    public int getReferenceMapIndex() {
        return this.referenceMapIndex;
    }

    public boolean isInstantiated() {
        return this.isInstantiated;
    }

    public static DynamicHub fromClass(Class<?> clazz) {
        return KnownIntrinsics.unsafeCast(clazz, DynamicHub.class);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Class<?> toClass(DynamicHub hub) {
        return KnownIntrinsics.unsafeCast(hub, Class.class);
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    public boolean isInstanceClass() {
        return LayoutEncoding.isInstance(this.getLayoutEncoding()) || LayoutEncoding.isArray(this.getLayoutEncoding()) && this.name.charAt(0) != '[';
    }

    @Substitute
    public boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    @Substitute
    public boolean isInterface() {
        return LayoutEncoding.isInterface(this.getLayoutEncoding());
    }

    @Substitute
    public boolean isPrimitive() {
        return LayoutEncoding.isPrimitive(this.getLayoutEncoding());
    }

    @Substitute
    public int getModifiers() {
        return 1 | (LayoutEncoding.isAbstract(this.getLayoutEncoding()) ? 1024 : 0) | (this.isStatic ? 8 : 0) | (this.isSynthetic ? 4096 : 0) | (this.isInterface() ? 512 : 0);
    }

    @Substitute
    private Object getComponentType() {
        return this.componentHub;
    }

    @Substitute
    private Object getSuperclass() {
        return this.superHub;
    }

    @Substitute
    private boolean isInstance(Object obj) {
        throw VMError.shouldNotReachHere("Substituted in SubstrateGraphBuilderPlugins.");
    }

    @Substitute
    private Object cast(Object obj) {
        throw VMError.shouldNotReachHere("Substituted in SubstrateGraphBuilderPlugins.");
    }

    @Substitute
    @TargetElement(name="isAssignableFrom")
    private boolean isAssignableFromClass(Class<?> cls) {
        return this.isAssignableFromHub(KnownIntrinsics.unsafeCast(cls, DynamicHub.class));
    }

    public boolean isAssignableFromHub(DynamicHub hub) {
        int checkTypeID = hub.getTypeID();
        for (int i = 0; i < this.assignableFromMatches.length; i += 2) {
            if (!UnsignedMath.belowThan((int)(checkTypeID - this.assignableFromMatches[i]), (int)this.assignableFromMatches[i + 1])) continue;
            return true;
        }
        return false;
    }

    @Substitute
    private boolean isAnnotation() {
        return this.isInterface() && this.getInterfaces().length == 1 && DynamicHub.toClass(this.getInterfaces()[0]) == Annotation.class;
    }

    @Substitute
    private boolean isEnum() {
        return this.getSuperclass() == Enum.class;
    }

    @Substitute
    private Enum<?>[] getEnumConstants() {
        return this.enumConstants != null ? (Enum[])this.enumConstants.clone() : null;
    }

    @Substitute
    public Enum<?>[] getEnumConstantsShared() {
        return this.enumConstants;
    }

    @Substitute
    private InputStream getResourceAsStream(String resourceName) {
        String path = this.resolveName(this.getName(), resourceName);
        List<byte[]> arr = Resources.get(path);
        return arr == null ? null : new ByteArrayInputStream(arr.get(0));
    }

    @Substitute
    private URL getResource(String resourceName) {
        String path = this.resolveName(this.getName(), resourceName);
        List<byte[]> arr = Resources.get(path);
        return arr == null ? null : Resources.createURL(path, arr.get(0));
    }

    private String resolveName(String baseName, String resourceName) {
        if (resourceName == null) {
            return resourceName;
        }
        if (resourceName.startsWith("/")) {
            return resourceName.substring(1);
        }
        int index = baseName.lastIndexOf(46);
        if (index != -1) {
            return baseName.substring(0, index).replace('.', '/') + "/" + resourceName;
        }
        return resourceName;
    }

    @KeepOriginal
    private native ClassLoader getClassLoader();

    @Substitute
    private ClassLoader getClassLoader0() {
        return KnownIntrinsics.unsafeCast(this.classloader, ClassLoader.class);
    }

    @KeepOriginal
    private native String getSimpleName();

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private String getSimpleName0() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getSimpleName0()");
    }

    @KeepOriginal
    private native String getCanonicalName();

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private String getCanonicalName0() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getCanonicalName0()");
    }

    @Override
    @KeepOriginal
    public native String getTypeName();

    @KeepOriginal
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native boolean isAsciiDigit(char var0);

    @KeepOriginal
    private native String getSimpleBinaryName();

    @KeepOriginal
    private native <U> Class<? extends U> asSubclass(Class<U> var1);

    @KeepOriginal
    private native boolean isAnonymousClass();

    @Substitute
    private boolean isLocalClass() {
        return this.isLocalClass;
    }

    @KeepOriginal
    private native boolean isMemberClass();

    @Substitute
    private boolean isLocalOrAnonymousClass() {
        return this.isLocalClass() || this.isAnonymousClass();
    }

    @Substitute
    private Object getEnclosingClass() {
        return this.enclosingClass;
    }

    @Substitute
    private Object getDeclaringClass() {
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        return this.enclosingClass;
    }

    @Substitute
    public DynamicHub[] getInterfaces() {
        if (this.interfacesEncoding == null) {
            return new DynamicHub[0];
        }
        if (this.interfacesEncoding instanceof DynamicHub) {
            return new DynamicHub[]{(DynamicHub)this.interfacesEncoding};
        }
        return (DynamicHub[])((DynamicHub[])this.interfacesEncoding).clone();
    }

    @Substitute
    public Object newInstance() throws Throwable {
        Constructor<?> nullaryConstructor = this.rd.nullaryConstructor;
        if (nullaryConstructor == null) {
            throw new InstantiationException("Type `" + this.getCanonicalName() + "` can not be instantiated reflectively as it does not have a no-parameter constructor or the no-parameter constructor has not been added explicitly to the native image.");
        }
        try {
            return nullaryConstructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static Object newInstanceInstantiationError(Object instance) throws InstantiationException {
        if (instance == null) {
            throw VMError.shouldNotReachHere("This case should be handled by the `DynamicNewInstance` lowering.");
        }
        throw new InstantiationException("Type `" + instance.getClass().getCanonicalName() + "` can not be instantiated reflectively as it does not have a no-parameter constructor.");
    }

    private static Object newInstanceReachableError(Object instance) {
        throw new RuntimeException("Constructor of `" + instance.getClass().getCanonicalName() + "` was removed by reachability analysis. Use `Feature.BeforeAnalysisAccess.registerForReflectiveInstantiation` to register the type for reflective instantiation.");
    }

    @Override
    @Substitute
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return AnnotationsEncoding.getAnnotation(this.annotationsEncoding, annotationClass);
    }

    @Override
    @Substitute
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    @Substitute
    public Annotation[] getAnnotations() {
        return AnnotationsEncoding.getAnnotations(this.annotationsEncoding);
    }

    @Override
    @Substitute
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        DynamicHub superClass;
        Annotation[] result = this.getDeclaredAnnotationsByType(annotationClass);
        if (result.length == 0 && annotationClass.getAnnotation(Inherited.class) != null && (superClass = (DynamicHub)this.getSuperclass()) != null) {
            result = superClass.getAnnotationsByType(annotationClass);
        }
        return result;
    }

    @Override
    @Substitute
    public Annotation[] getDeclaredAnnotations() {
        IdentityHashMap superAnnotations = new IdentityHashMap();
        if (this.getSuperHub() != null) {
            for (Annotation annotation : this.getSuperHub().getAnnotations()) {
                superAnnotations.put(annotation, null);
            }
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : this.getAnnotations()) {
            if (superAnnotations.containsKey(annotation)) continue;
            annotations.add(annotation);
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    @Substitute
    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        return GenericDeclaration.super.getDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    @Substitute
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        T annotation = AnnotationsEncoding.getAnnotation(this.annotationsEncoding, annotationClass);
        if (annotation != null && this.getSuperHub() != null && this.getSuperHub().getAnnotation(annotationClass) == annotation) {
            return null;
        }
        return annotation;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setReflectionData(ReflectionData rd) {
        this.rd = rd;
    }

    @KeepOriginal
    private native Field[] getFields();

    @KeepOriginal
    private native Method[] getMethods();

    @KeepOriginal
    private native Constructor<?>[] getConstructors();

    @KeepOriginal
    private native Field getField(String var1);

    @KeepOriginal
    private native Method getMethod(String var1, Class<?> ... var2);

    @KeepOriginal
    private native Constructor<?> getConstructor(Class<?> ... var1);

    @KeepOriginal
    private native Class<?>[] getDeclaredClasses();

    @KeepOriginal
    public native Class<?>[] getClasses();

    @KeepOriginal
    private native Field[] getDeclaredFields();

    @KeepOriginal
    private native Method[] getDeclaredMethods();

    @KeepOriginal
    private native Constructor<?>[] getDeclaredConstructors();

    @KeepOriginal
    private native Field getDeclaredField(String var1);

    @KeepOriginal
    private native Method getDeclaredMethod(String var1, Class<?> ... var2);

    @KeepOriginal
    private native Constructor<?> getDeclaredConstructor(Class<?> ... var1);

    @Substitute
    private Constructor<?>[] privateGetDeclaredConstructors(boolean publicOnly) {
        return publicOnly ? this.rd.publicConstructors : this.rd.declaredConstructors;
    }

    @Substitute
    private Field[] privateGetDeclaredFields(boolean publicOnly) {
        return publicOnly ? this.rd.declaredPublicFields : this.rd.declaredFields;
    }

    @Substitute
    private Method[] privateGetDeclaredMethods(boolean publicOnly) {
        return publicOnly ? this.rd.declaredPublicMethods : this.rd.declaredMethods;
    }

    @Substitute
    @TargetElement(name="privateGetPublicFields", onlyWith={JDK8OrEarlier.class})
    private Field[] privateGetPublicFieldsJDK8OrEarlier(Set<Class<?>> traversedInterfaces) {
        return this.rd.publicFields;
    }

    @Substitute
    @TargetElement(name="privateGetPublicFields", onlyWith={JDK9OrLater.class})
    private Field[] privateGetPublicFieldsJDK9Orlater() {
        return this.rd.publicFields;
    }

    @Substitute
    private Method[] privateGetPublicMethods() {
        return this.rd.publicMethods;
    }

    @Substitute
    @TargetElement(name="checkMemberAccess", onlyWith={JDK8OrEarlier.class})
    private void checkMemberAccessJDK8OrEarlier(int which, Class<?> caller, boolean checkProxyInterfaces) {
    }

    @Substitute
    @TargetElement(name="checkMemberAccess", onlyWith={JDK9OrLater.class})
    private void checkMemberAccessJDK9OrLater(SecurityManager sm, int which, Class<?> caller, boolean checkProxyInterfaces) {
    }

    @Substitute
    private static ReflectionFactory getReflectionFactory() {
        return reflectionFactory;
    }

    @KeepOriginal
    private static native Field searchFields(Field[] var0, String var1);

    @KeepOriginal
    private native Field getField0(String var1);

    @KeepOriginal
    private static native Method searchMethods(Method[] var0, String var1, Class<?>[] var2);

    @KeepOriginal
    @TargetElement(name="getMethod0", onlyWith={JDK8OrEarlier.class})
    private native Method getMethod0JDK8OrEarlier(String var1, Class<?>[] var2, boolean var3);

    @KeepOriginal
    @TargetElement(name="getMethod0", onlyWith={JDK9OrLater.class})
    private native Method getMethod0JDK9OrLater(String var1, Class<?>[] var2);

    @KeepOriginal
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private native Method privateGetMethodRecursive(String var1, Class<?>[] var2, boolean var3, Target_java_lang_Class_MethodArray var4);

    @KeepOriginal
    private native Constructor<?> getConstructor0(Class<?>[] var1, int var2);

    @KeepOriginal
    private static native boolean arrayContentsEq(Object[] var0, Object[] var1);

    @KeepOriginal
    private static native Field[] copyFields(Field[] var0);

    @KeepOriginal
    private static native Method[] copyMethods(Method[] var0);

    @KeepOriginal
    private static native <U> Constructor<U>[] copyConstructors(Constructor<U>[] var0);

    @KeepOriginal
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static native String argumentTypesToString(Class<?>[] var0);

    @Override
    @Substitute
    public TypeVariable<?>[] getTypeParameters() {
        return this.genericInfo.getTypeParameters();
    }

    @Substitute
    public Type[] getGenericInterfaces() {
        return this.genericInfo.hasGenericInterfaces() ? this.genericInfo.getGenericInterfaces() : this.getInterfaces();
    }

    @Substitute
    public Type getGenericSuperclass() {
        return this.genericInfo.hasGenericSuperClass() ? this.genericInfo.getGenericSuperClass() : this.getSuperHub();
    }

    @Substitute
    public AnnotatedType getAnnotatedSuperclass() {
        return this.annotatedSuperInfo.getAnnotatedSuperclass();
    }

    @Substitute
    public AnnotatedType[] getAnnotatedInterfaces() {
        return this.annotatedSuperInfo.getAnnotatedInterfaces();
    }

    @Substitute
    private Method getEnclosingMethod() {
        if (this.rd.enclosingMethodOrConstructor instanceof Method) {
            return (Method)this.rd.enclosingMethodOrConstructor;
        }
        return null;
    }

    @Substitute
    private Constructor<?> getEnclosingConstructor() {
        if (this.rd.enclosingMethodOrConstructor instanceof Constructor) {
            return (Constructor)this.rd.enclosingMethodOrConstructor;
        }
        return null;
    }

    @Substitute
    private static Class<?> forName(String className) throws ClassNotFoundException {
        return ClassForNameSupport.forName(className);
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public static Class<?> forName(Target_java_lang_Module module, String name) {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.forName(Target_java_lang_Module module, String name)");
    }

    @Substitute
    private static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return ClassForNameSupport.forName(name);
    }

    @KeepOriginal
    @TargetElement(name="getPackage", onlyWith={JDK8OrEarlier.class})
    public native Package getPackageJDK8OrEarlier();

    @Substitute
    @TargetElement(name="getPackage", onlyWith={JDK9OrLater.class})
    public Package getPackageJDK9OrLater() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getPackage()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public String getPackageName() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getPackageName()");
    }

    @Substitute
    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    @KeepOriginal
    public native String toGenericString();

    @Substitute
    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    @Substitute
    public Object[] getSigners() {
        return null;
    }

    @Substitute
    public Object getProtectionDomain() {
        if (allPermDomain == null) {
            Permissions perms = new Permissions();
            perms.add(SecurityConstants.ALL_PERMISSION);
            allPermDomain = new ProtectionDomain(null, perms);
        }
        return allPermDomain;
    }

    @Substitute
    public boolean desiredAssertionStatus() {
        return SubstrateOptions.RuntimeAssertions.getValue() != false && SubstrateOptions.getRuntimeAssertionsFilter().test(this.getName());
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public Target_java_lang_Module getModule() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getModule()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private String methodToString(String nameArg, Class<?>[] argTypes) {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.methodToString(String nameArg, Class<?>[] argTypes)");
    }

    @Substitute
    private <T> Target_java_lang_Class_ReflectionData<T> reflectionData() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.reflectionData()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private boolean isTopLevelClass() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.isTopLevelClass()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private String getSimpleBinaryName0() {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getSimpleBinaryName0()");
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    List<Method> getDeclaredPublicMethods(String nameArg, Class<?> ... parameterTypes) {
        throw VMError.unsupportedFeature("JDK9OrLater: DynamicHub.getDeclaredPublicMethods(String nameArg, Class<?>... parameterTypes)");
    }

    @Substitute
    private Class<?> getDeclaringClass0() {
        throw VMError.unsupportedFeature("DynamicHub.getDeclaringClass0()");
    }

    static {
        NO_REFLECTION_DATA = new ReflectionData(new Field[0], new Field[0], new Method[0], new Method[0], new Constructor[0], new Constructor[0], null, new Field[0], new Method[0], null);
        reflectionFactory = ReflectionFactory.getReflectionFactory();
    }

    @TargetClass(value=Class.class, innerClass="MethodArray", onlyWith={JDK8OrEarlier.class})
    static final class Target_java_lang_Class_MethodArray {
        Target_java_lang_Class_MethodArray() {
        }
    }

    public static final class ReflectionData {
        final Field[] declaredFields;
        final Field[] publicFields;
        final Method[] declaredMethods;
        final Method[] publicMethods;
        final Constructor<?>[] declaredConstructors;
        final Constructor<?>[] publicConstructors;
        final Constructor<?> nullaryConstructor;
        final Field[] declaredPublicFields;
        final Method[] declaredPublicMethods;
        final Executable enclosingMethodOrConstructor;

        public ReflectionData(Field[] declaredFields, Field[] publicFields, Method[] declaredMethods, Method[] publicMethods, Constructor<?>[] declaredConstructors, Constructor<?>[] publicConstructors, Constructor<?> nullaryConstructor, Field[] declaredPublicFields, Method[] declaredPublicMethods, Executable enclosingMethodOrConstructor) {
            this.declaredFields = declaredFields;
            this.publicFields = publicFields;
            this.declaredMethods = declaredMethods;
            this.publicMethods = publicMethods;
            this.declaredConstructors = declaredConstructors;
            this.publicConstructors = publicConstructors;
            this.nullaryConstructor = nullaryConstructor;
            this.declaredPublicFields = declaredPublicFields;
            this.declaredPublicMethods = declaredPublicMethods;
            this.enclosingMethodOrConstructor = enclosingMethodOrConstructor;
        }
    }
}

