/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.LibC;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class PosixLogHandler
implements LogHandler {
    public void log(CCharPointer bytes, UnsignedWord length) {
        if (!PosixUtils.writeBytes(PosixLogHandler.getOutputFile(), bytes, length)) {
            this.fatalError();
        }
    }

    public void flush() {
        PosixUtils.flush(PosixLogHandler.getOutputFile());
    }

    public void fatalError() {
        LibC.abort();
    }

    private static FileDescriptor getOutputFile() {
        return FileDescriptor.err;
    }
}

