/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_jvm;
import com.oracle.svm.core.posix.VmPrimsJNI;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;
import sun.net.ConnectionResetException;

@TargetClass(className="java.net.SocketInputStream")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_net_SocketInputStream {
    Target_java_net_SocketInputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private int socketRead0(FileDescriptor fdObj, byte[] data, int off, int lenArg, int timeout) throws IOException {
        int nread;
        int len = lenArg;
        CCharPointer BUF = (CCharPointer)StackValue.get((int)JavaNetNetUtilMD.MAX_BUFFER_LEN(), CCharPointer.class);
        CCharPointer bufP = (CCharPointer)WordFactory.nullPointer();
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (fd == -1) {
            throw new SocketException("Socket closed");
        }
        if (len > JavaNetNetUtilMD.MAX_BUFFER_LEN()) {
            if (len > JavaNetNetUtilMD.MAX_HEAP_BUFFER_LEN()) {
                len = JavaNetNetUtilMD.MAX_HEAP_BUFFER_LEN();
            }
            if ((bufP = (CCharPointer)LibC.malloc(WordFactory.unsigned((int)len))).isNull()) {
                bufP = BUF;
                len = JavaNetNetUtilMD.MAX_BUFFER_LEN();
            }
        } else {
            bufP = BUF;
        }
        if (CTypeConversion.toBoolean((int)timeout) && (nread = JavaNetNetUtilMD.NET_Timeout(fd, timeout)) <= 0) {
            try {
                if (nread == 0) {
                    throw new SocketTimeoutException("Read timed out");
                }
                if (nread == Target_jvm.JVM_IO_ERR()) {
                    if (Errno.errno() == Errno.EBADF()) {
                        throw new SocketException("Socket closed");
                    }
                    if (Errno.errno() == Errno.ENOMEM()) {
                        throw new OutOfMemoryError("NET_Timeout native heap allocation failed");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("select/poll failed"));
                }
                if (nread == Target_jvm.JVM_IO_INTR()) {
                    throw new InterruptedIOException("Operation interrupted");
                }
            }
            finally {
                if (bufP.notEqual((ComparableWord)BUF) && bufP.isNonNull()) {
                    LibC.free((PointerBase)bufP);
                    bufP = (CCharPointer)WordFactory.nullPointer();
                }
            }
            return -1;
        }
        try {
            nread = JavaNetNetUtilMD.NET_Read(fd, bufP, len);
            if (nread <= 0) {
                if (nread < 0) {
                    if (Errno.errno() == Errno.ECONNRESET() || Errno.errno() == Errno.EPIPE()) {
                        throw new ConnectionResetException("Connection reset");
                    }
                    if (Errno.errno() == Errno.EBADF()) {
                        throw new SocketException("Socket closed");
                    }
                    if (Errno.errno() == Errno.EINTR()) {
                        throw new InterruptedIOException("Operation interrupted");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("Read failed"));
                }
            } else {
                VmPrimsJNI.SetByteArrayRegion(data, off, nread, bufP);
            }
        }
        finally {
            if (bufP.notEqual((ComparableWord)BUF) && bufP.isNonNull()) {
                LibC.free((PointerBase)bufP);
                bufP = (CCharPointer)WordFactory.nullPointer();
            }
        }
        return nread;
    }
}

