/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.DarwinEvent;
import java.io.IOException;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.DARWIN.class})
public final class DarwinNIOSubstitutions {
    private DarwinNIOSubstitutions() {
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.nio.ch.KQueuePort")
    static final class Target_sun_nio_ch_KQueuePort {
        Target_sun_nio_ch_KQueuePort() {
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void socketpair(int[] sv) throws IOException {
            CIntPointer sp = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
            if (Socket.socketpair(Socket.PF_UNIX(), Socket.SOCK_STREAM(), 0, sp) == -1) {
                throw new IOException("socketpair failed");
            }
            sv[0] = sp.read(0);
            sv[1] = sp.read(1);
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void interrupt(int fd) throws IOException {
            int res;
            CIntPointer buf = (CIntPointer)StackValue.get((int)1, CIntPointer.class);
            buf.write(0, 1);
            while ((res = (int)Unistd.write(fd, (PointerBase)buf, WordFactory.unsigned((int)1)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("write failed");
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void drain1(int fd) throws IOException {
            int res;
            CIntPointer buf = (CIntPointer)StackValue.get((int)1, CIntPointer.class);
            while ((res = (int)Unistd.read(fd, (PointerBase)buf, WordFactory.unsigned((int)1)).rawValue()) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("drain1 failed");
            }
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static void close0(int fd) {
            int res;
            while ((res = Unistd.close(fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.nio.ch.KQueueArrayWrapper", onlyWith={JDK8OrEarlier.class})
    static final class Target_sun_nio_ch_KQueueArrayWrapper {
        Target_sun_nio_ch_KQueueArrayWrapper() {
        }

        @Substitute
        int init() throws IOException {
            int kq = DarwinEvent.kqueue();
            if (kq < 0) {
                throw new IOException("KQueueArrayWrapper: kqueue() failed");
            }
            return kq;
        }

        @Substitute
        void register0(int kq, int fd, int r, int w) {
            DarwinEvent.kevent changes = (DarwinEvent.kevent)StackValue.get((int)2, DarwinEvent.kevent.class);
            DarwinEvent.kevent errors = (DarwinEvent.kevent)StackValue.get((int)2, DarwinEvent.kevent.class);
            Time.timespec dontBlock = (Time.timespec)StackValue.get(Time.timespec.class);
            dontBlock.set_tv_sec(0L);
            dontBlock.set_tv_nsec(0L);
            DarwinEvent.EV_SET(changes.addressOf(0), (Word)WordFactory.unsigned((int)fd), (short)DarwinEvent.EVFILT_READ(), (short)(CTypeConversion.toBoolean((int)r) ? DarwinEvent.EV_ADD() : DarwinEvent.EV_DELETE()), 0, (Word)WordFactory.zero(), (WordPointer)WordFactory.nullPointer());
            DarwinEvent.EV_SET(changes.addressOf(1), (Word)WordFactory.unsigned((int)fd), (short)DarwinEvent.EVFILT_WRITE(), (short)(CTypeConversion.toBoolean((int)w) ? DarwinEvent.EV_ADD() : DarwinEvent.EV_DELETE()), 0, (Word)WordFactory.zero(), (WordPointer)WordFactory.nullPointer());
            DarwinEvent.kevent(kq, changes, 2, errors, 2, dontBlock);
        }

        @Substitute
        int kevent0(int kq, long kevAddr, int kevCount, long timeout) throws IOException {
            Time.timespec tsp;
            DarwinEvent.kevent keys = (DarwinEvent.kevent)WordFactory.pointer((long)kevAddr);
            Time.timespec ts = (Time.timespec)StackValue.get(Time.timespec.class);
            if (timeout >= 0L) {
                ts.set_tv_sec(timeout / 1000L);
                ts.set_tv_nsec(timeout % 1000L * 1000000L);
                tsp = ts;
            } else {
                tsp = (Time.timespec)WordFactory.nullPointer();
            }
            int result = DarwinEvent.kevent(kq, (DarwinEvent.kevent)WordFactory.nullPointer(), 0, keys, kevCount, tsp);
            if (result < 0) {
                if (Errno.errno() == Errno.EINTR()) {
                    result = 0;
                } else {
                    throw new IOException("KQueueArrayWrapper: kqueue failed");
                }
            }
            return result;
        }

        @Substitute
        static void interrupt(int fd) throws IOException {
            CCharPointer cPointer = (CCharPointer)StackValue.get(CCharPointer.class);
            cPointer.write((byte)1);
            if (1 != (int)Unistd.write(fd, (PointerBase)cPointer, WordFactory.unsigned((int)1)).rawValue()) {
                throw new IOException("KQueueArrayWrapper: interrupt failed");
            }
        }
    }

    static class Util_sun_nio_ch_KQueue {
        Util_sun_nio_ch_KQueue() {
        }

        static int create() throws IOException {
            int kqfd = DarwinEvent.kqueue();
            if (kqfd < 0) {
                throw new IOException("kqueue failed");
            }
            return kqfd;
        }

        @Substitute
        static int register(int kqfd, int fd, int filter, int flags) {
            int res;
            DarwinEvent.kevent changes = (DarwinEvent.kevent)StackValue.get((int)1, DarwinEvent.kevent.class);
            Time.timespec timeout = (Time.timespec)StackValue.get(Time.timespec.class);
            timeout.set_tv_sec(0L);
            timeout.set_tv_nsec(0L);
            DarwinEvent.EV_SET(changes.addressOf(0), (Word)WordFactory.unsigned((int)fd), (short)filter, (short)flags, 0, (Word)WordFactory.signed((int)0), (WordPointer)WordFactory.nullPointer());
            while ((res = DarwinEvent.kevent(kqfd, changes, 1, (DarwinEvent.kevent)WordFactory.nullPointer(), 0, timeout)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            return res == -1 ? Errno.errno() : 0;
        }

        @Substitute
        static int poll(int kqfd, long address, int nevents) throws IOException {
            int res;
            DarwinEvent.kevent events = (DarwinEvent.kevent)WordFactory.pointer((long)address);
            while ((res = DarwinEvent.kevent(kqfd, (DarwinEvent.kevent)WordFactory.nullPointer(), 0, events, nevents, (Time.timespec)WordFactory.nullPointer())) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw new IOException("kqueue failed");
            }
            return res;
        }
    }

    @Platforms(value={Platform.DARWIN.class})
    @TargetClass(className="sun.nio.ch.KQueue")
    static final class Target_sun_nio_ch_KQueue {
        Target_sun_nio_ch_KQueue() {
        }

        @Substitute
        static int keventSize() {
            return SizeOf.get(DarwinEvent.kevent.class);
        }

        @Substitute
        static int identOffset() {
            return DarwinEvent.kevent.offsetOf_ident();
        }

        @Substitute
        static int filterOffset() {
            return DarwinEvent.kevent.offsetOf_filter();
        }

        @Substitute
        static int flagsOffset() {
            return DarwinEvent.kevent.offsetOf_flags();
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int kqueue() throws IOException {
            return Util_sun_nio_ch_KQueue.create();
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int create() throws IOException {
            return Util_sun_nio_ch_KQueue.create();
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int keventRegister(int kqfd, int fd, int filter, int flags) {
            return Util_sun_nio_ch_KQueue.register(kqfd, fd, filter, flags);
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int register(int kqfd, int fd, int filter, int flags) {
            return Util_sun_nio_ch_KQueue.register(kqfd, fd, filter, flags);
        }

        @Substitute
        @TargetElement(onlyWith={JDK8OrEarlier.class})
        static int keventPoll(int kqfd, long address, int nevents) throws IOException {
            return Util_sun_nio_ch_KQueue.poll(kqfd, address, nevents);
        }

        @Substitute
        @TargetElement(onlyWith={JDK9OrLater.class})
        static int poll(int kqfd, long pollAddress, int nevents, long timeout) throws IOException {
            return Util_sun_nio_ch_KQueue.poll(kqfd, pollAddress, nevents);
        }
    }
}

