/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
class WindowsPhysicalMemory
extends PhysicalMemory {
    WindowsPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new WindowsPhysicalMemorySupportImpl());
        }
    }

    static class WindowsPhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        WindowsPhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            WinBase.MEMORYSTATUSEX memStatusEx = (WinBase.MEMORYSTATUSEX)StackValue.get(WinBase.MEMORYSTATUSEX.class);
            memStatusEx.set_dwLength(SizeOf.get(WinBase.MEMORYSTATUSEX.class));
            if (WinBase.GlobalMemoryStatusEx(memStatusEx)) {
                return WordFactory.unsigned((long)memStatusEx.ullTotalPhys());
            }
            return (UnsignedWord)WordFactory.nullPointer();
        }
    }
}

