/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.UnsafePartitionKind;
import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.GraalEdgeUnsafePartition;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.FieldIntrospection;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.CompositeValue;
import org.graalvm.compiler.lir.CompositeValueClass;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

public class FieldsOffsetsFeature
implements Feature {
    protected static Map<long[], FieldsOffsetsReplacement> getReplacements() {
        return ((FieldsOffsetsReplacements)ImageSingletons.lookup(FieldsOffsetsReplacements.class)).replacements;
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        ImageSingletons.add(FieldsOffsetsReplacements.class, (Object)new FieldsOffsetsReplacements());
        config.registerObjectReplacer(FieldsOffsetsFeature::replaceFieldsOffsets);
    }

    private static Object replaceFieldsOffsets(Object source) {
        FieldsOffsetsReplacement replacement;
        if (source instanceof Fields) {
            assert (FieldsOffsetsFeature.getReplacements().containsKey(((Fields)source).getOffsets()));
        } else if (source instanceof long[] && (replacement = FieldsOffsetsFeature.getReplacements().get(source)) != null) {
            assert (source == replacement.fields.getOffsets());
            if (replacement.newValuesAvailable) {
                return replacement.newOffsets;
            }
        }
        return source;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        GraalSupport.get().nodeClasses = FieldsOffsetsFeature.registerClasses(Node.class, NodeClass::get, false, config);
        GraalSupport.get().instructionClasses = FieldsOffsetsFeature.registerClasses(LIRInstruction.class, LIRInstructionClass::get, true, config);
        GraalSupport.get().compositeValueClasses = FieldsOffsetsFeature.registerClasses(CompositeValue.class, CompositeValueClass::get, true, config);
    }

    private static <R extends FieldIntrospection<?>> HashMap<Class<?>, R> registerClasses(Class<?> baseClass, Function<Class<?>, R> lookup, boolean excludeAbstract, FeatureImpl.BeforeAnalysisAccessImpl config) {
        HashMap result = new HashMap();
        for (Class<?> clazz : config.findSubclasses(baseClass)) {
            if (clazz == baseClass || ImageClassLoader.isHostedClass(clazz) || excludeAbstract && Modifier.isAbstract(clazz.getModifiers())) continue;
            FieldIntrospection nodeClass = (FieldIntrospection)lookup.apply(clazz);
            result.put(clazz, nodeClass);
            config.registerAsUsed(config.getMetaAccess().lookupJavaType(clazz));
            FieldsOffsetsFeature.registerFields(nodeClass, config);
        }
        return result;
    }

    private static void registerFields(FieldIntrospection<?> introspection, FeatureImpl.BeforeAnalysisAccessImpl config) {
        if (introspection instanceof NodeClass) {
            NodeClass nodeClass = (NodeClass)introspection;
            Fields dataFields = nodeClass.getData();
            FieldsOffsetsFeature.registerFields(dataFields, DefaultUnsafePartition.get(), config);
            Edges inputEdges = nodeClass.getInputEdges();
            FieldsOffsetsFeature.registerFields((Fields)inputEdges, GraalEdgeUnsafePartition.get(), config);
            Edges successorEdges = nodeClass.getSuccessorEdges();
            FieldsOffsetsFeature.registerFields((Fields)successorEdges, GraalEdgeUnsafePartition.get(), config);
            nodeClass.shortName();
        } else {
            for (Fields fields : introspection.getAllFields()) {
                FieldsOffsetsFeature.registerFields(fields, DefaultUnsafePartition.get(), config);
            }
        }
    }

    private static void registerFields(Fields fields, UnsafePartitionKind partitionKind, FeatureImpl.BeforeAnalysisAccessImpl config) {
        FieldsOffsetsFeature.getReplacements().put(fields.getOffsets(), new FieldsOffsetsReplacement(fields));
        for (int i = 0; i < fields.getCount(); ++i) {
            config.registerAsUnsafeAccessed(config.getMetaAccess().lookupJavaField(FieldsOffsetsFeature.findField(fields, i)), partitionKind);
        }
    }

    private static Field findField(Fields fields, int index) {
        try {
            return fields.getDeclaringClass(index).getDeclaredField(fields.getName(index));
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        for (FieldsOffsetsReplacement replacement : FieldsOffsetsFeature.getReplacements().values()) {
            Fields fields = replacement.fields;
            long[] newOffsets = new long[fields.getCount()];
            for (int i = 0; i < newOffsets.length; ++i) {
                Field field = FieldsOffsetsFeature.findField(fields, i);
                assert (UnsafeAccess.UNSAFE.objectFieldOffset(field) == fields.getOffsets()[i]);
                newOffsets[i] = hMetaAccess.lookupJavaField(field).getLocation();
            }
            replacement.newOffsets = newOffsets;
            if (fields instanceof Edges) {
                Edges edges = (Edges)fields;
                replacement.newIterationInitMask = NodeClass.computeIterationMask((Edges.Type)edges.type(), (int)edges.getDirectCount(), (long[])newOffsets);
            }
            replacement.newValuesAvailable = true;
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        access.registerAsImmutable(GraalSupport.get().nodeClasses.values(), o -> true);
        access.registerAsImmutable(GraalSupport.get().instructionClasses.values(), o -> true);
    }

    static class FieldsOffsetsReplacements {
        protected final Map<long[], FieldsOffsetsReplacement> replacements = new IdentityHashMap<long[], FieldsOffsetsReplacement>();

        FieldsOffsetsReplacements() {
        }
    }

    static class FieldsOffsetsReplacement {
        protected final Fields fields;
        protected boolean newValuesAvailable;
        protected long[] newOffsets;
        protected long newIterationInitMask;

        protected FieldsOffsetsReplacement(Fields fields) {
            this.fields = fields;
        }
    }

    public static class SuccessorsIterationMaskRecomputation
    extends IterationMaskRecomputation {
        @Override
        protected Edges getEdges(NodeClass<?> nodeClass) {
            return nodeClass.getSuccessorEdges();
        }
    }

    public static class InputsIterationMaskRecomputation
    extends IterationMaskRecomputation {
        @Override
        protected Edges getEdges(NodeClass<?> nodeClass) {
            return nodeClass.getInputEdges();
        }
    }

    static abstract class IterationMaskRecomputation
    implements RecomputeFieldValue.CustomFieldValueComputer {
        IterationMaskRecomputation() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Edges edges = this.getEdges((NodeClass)receiver);
            FieldsOffsetsReplacement replacement = FieldsOffsetsFeature.getReplacements().get(edges.getOffsets());
            assert (replacement.fields == edges);
            assert (replacement.newValuesAvailable) : "Cannot access iteration mask before field offsets are assigned";
            return replacement.newIterationInitMask;
        }

        protected abstract Edges getEdges(NodeClass<?> var1);
    }
}

