/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.amd64.SubstrateAMD64AddressLowering;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.meta.SubstrateTargetDescription;
import com.oracle.svm.core.graal.phases.CollectDeoptimizationSourcePositionsPhase;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.phases.MethodSafepointInsertionPhase;
import com.oracle.svm.core.graal.phases.OptimizeExceptionCallsPhase;
import com.oracle.svm.core.graal.phases.RemoveUnwindPhase;
import com.oracle.svm.core.graal.phases.TrustedInterfaceTypePlugin;
import com.oracle.svm.core.graal.snippets.ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.DeoptRuntimeSnippets;
import com.oracle.svm.core.graal.snippets.DeoptTestSnippets;
import com.oracle.svm.core.graal.snippets.ExceptionSnippets;
import com.oracle.svm.core.graal.snippets.MonitorSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.NonSnippetLowerings;
import com.oracle.svm.core.graal.snippets.TypeSnippets;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValuePhase;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.LocalizationFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.RestrictHeapAccessCallees;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInterface;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedSnippetReflectionProvider;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.option.HostedOptionProvider;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.ConstantFoldLoadFieldPlugin;
import com.oracle.svm.hosted.phases.ImplicitExceptionsPlugin;
import com.oracle.svm.hosted.phases.InjectedAccessorsPlugin;
import com.oracle.svm.hosted.phases.IntrinsifyMethodHandlesInvocationPlugin;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.phases.VerifyDeoptFrameStatesLIRPhase;
import com.oracle.svm.hosted.phases.VerifyNoGuardsPhase;
import com.oracle.svm.hosted.snippets.AssertSnippets;
import com.oracle.svm.hosted.snippets.DeoptHostedSnippets;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedFieldsPlugin;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.CommunityCompilerConfiguration;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.NodeIntrinsicPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.TypePlugin;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.common.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.phases.common.DeoptimizationGroupingPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.amd64.AMD64GraphBuilderPlugins;
import org.graalvm.compiler.word.WordOperationPlugin;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawStructure;

public class NativeImageGenerator {
    private final FeatureHandler featureHandler;
    private final ImageClassLoader loader;
    private final HostedOptionProvider optionProvider;
    private ForkJoinPool imageBuildPool;
    private AnalysisUniverse aUniverse;
    private HostedUniverse hUniverse;
    private BigBang bigbang;
    private AbstractBootImage image;
    private AtomicBoolean buildStarted = new AtomicBoolean();
    private Path tempDirectory;
    private boolean deleteTempDirectory;

    public NativeImageGenerator(ImageClassLoader loader, HostedOptionProvider optionProvider) {
        this.loader = loader;
        this.featureHandler = new FeatureHandler();
        this.optionProvider = optionProvider;
        optionProvider.getHostedValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
        optionProvider.getRuntimeValues().put((Object)GraalOptions.EagerSnippets, (Object)true);
    }

    public static Platform defaultPlatform(ClassLoader classLoader) {
        String platformClassName = System.getProperty("svm.platform");
        if (platformClassName != null) {
            Object result;
            Class<?> platformClass;
            try {
                platformClass = classLoader.loadClass(platformClassName);
            }
            catch (ClassNotFoundException ex) {
                throw UserError.abort("Could not find platform class " + platformClassName + " that was specified explicitly on the command line using the system property " + "svm.platform");
            }
            try {
                Constructor<?> constructor = platformClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                result = constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw UserError.abort("Could not instantiated platform class " + platformClassName + ". Ensure the class is not abstract and has a no-argument constructor.");
            }
            if (!(result instanceof Platform)) {
                throw UserError.abort("Platform class " + platformClassName + " does not implement " + Platform.class.getTypeName());
            }
            return (Platform)result;
        }
        Architecture hostedArchitecture = GraalAccess.getOriginalTarget().arch;
        if (hostedArchitecture instanceof AMD64) {
            String osName = System.getProperty("os.name");
            if (OS.getCurrent() == OS.LINUX) {
                return new Platform.LINUX_AMD64();
            }
            if (OS.getCurrent() == OS.DARWIN) {
                return new Platform.DARWIN_AMD64();
            }
            if (OS.getCurrent() == OS.WINDOWS) {
                return new Platform.WINDOWS_AMD64();
            }
            throw VMError.shouldNotReachHere("Unsupported operating system: " + osName);
        }
        throw VMError.shouldNotReachHere("Unsupported architecture: " + hostedArchitecture.getClass().getSimpleName());
    }

    public static boolean includedIn(Platform platform, Class<? extends Platform> platformGroup) {
        return platformGroup.isInstance(platform);
    }

    public static boolean includedIn(Platform platform, Platforms platformsAnnotation) {
        if (platformsAnnotation == null) {
            return true;
        }
        for (Class platformGroup : platformsAnnotation.value()) {
            if (!NativeImageGenerator.includedIn(platform, platformGroup)) continue;
            return true;
        }
        return false;
    }

    public static TargetDescription createTarget(Platform platform) {
        if (NativeImageGenerator.includedIn(platform, Platform.AMD64.class)) {
            Architecture architecture;
            if (NativeImageOptions.NativeArchitecture.getValue().booleanValue()) {
                architecture = GraalAccess.getOriginalTarget().arch;
            } else {
                EnumSet<AMD64.CPUFeature> features = EnumSet.noneOf(AMD64.CPUFeature.class);
                features.add(AMD64.CPUFeature.SSE);
                features.add(AMD64.CPUFeature.SSE2);
                features.addAll(NativeImageGenerator.parseCSVtoEnum(AMD64.CPUFeature.class, NativeImageOptions.CPUFeatures.getValue()));
                architecture = new AMD64(features, SubstrateTargetDescription.allFlags());
            }
            assert (architecture instanceof AMD64) : "SVM supports only AMD64 architectures.";
            boolean inlineObjects = SubstrateOptions.SpawnIsolates.getValue();
            return new SubstrateTargetDescription(architecture, true, 16, 0, inlineObjects);
        }
        throw UserError.abort("Architecture specified by platform is not supported: " + platform.getClass().getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<Method, CEntryPointData> entryPoints, Method mainEntryPoint, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractBootImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor, EconomicSet<String> allOptionNames) {
        try {
            if (!this.buildStarted.compareAndSet(false, true)) {
                throw UserError.abort("An image build has already been performed with this generator.");
            }
            NativeImageGenerator.setSystemPropertiesForImage(k);
            int maxConcurrentThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads(new OptionValues(this.optionProvider.getHostedValues()));
            this.imageBuildPool = this.createForkJoinPool(maxConcurrentThreads);
            ((ForkJoinTask)this.imageBuildPool.submit(() -> {
                try {
                    ImageSingletons.add(HostedOptionValues.class, (Object)((Object)new HostedOptionValues(this.optionProvider.getHostedValues())));
                    ImageSingletons.add(RuntimeOptionValues.class, (Object)((Object)new RuntimeOptionValues((UnmodifiableEconomicMap<OptionKey<?>, Object>)this.optionProvider.getRuntimeValues(), allOptionNames)));
                    this.doRun(entryPoints, mainEntryPoint, javaMainSupport, imageName, k, harnessSubstitutions, compilationExecutor, analysisExecutor);
                }
                finally {
                    try {
                        if (this.deleteTempDirectory) {
                            NativeImageGenerator.deleteAll(this.tempDirectory());
                        }
                        this.featureHandler.forEachFeature(Feature::cleanup);
                    }
                    catch (Throwable throwable) {}
                }
            })).get();
        }
        catch (InterruptedException | CancellationException e) {
            System.out.println("Interrupted!");
            throw new InterruptImageBuilding();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
        }
        finally {
            this.shutdownPoolSafe();
            NativeImageGenerator.clearSystemPropertiesForImage();
        }
    }

    private static void setSystemPropertiesForImage(AbstractBootImage.NativeImageKind imageKind) {
        System.setProperty("org.graalvm.nativeimage.imagecode", "buildtime");
        if (imageKind.executable) {
            System.setProperty("org.graalvm.nativeimage.kind", "executable");
        } else {
            System.setProperty("org.graalvm.nativeimage.kind", "shared");
        }
    }

    private static void clearSystemPropertiesForImage() {
        System.clearProperty("org.graalvm.nativeimage.imagecode");
        System.clearProperty("org.graalvm.nativeimage.kind");
    }

    private ForkJoinPool createForkJoinPool(int maxConcurrentThreads) {
        final ImageSingletonsSupportImpl.HostedManagement vmConfig = new ImageSingletonsSupportImpl.HostedManagement();
        return new ForkJoinPool(maxConcurrentThreads, pool -> new ForkJoinWorkerThread(pool){

            @Override
            protected void onStart() {
                super.onStart();
                ImageSingletonsSupportImpl.HostedManagement.installInThread(vmConfig);
                assert (NativeImageGenerator.this.loader.getClassLoader().equals(this.getContextClassLoader()));
            }

            @Override
            protected void onTermination(Throwable exception) {
                ImageSingletonsSupportImpl.HostedManagement.clearInThread();
                super.onTermination(exception);
            }
        }, Thread.getDefaultUncaughtExceptionHandler(), false);
    }

    /*
     * Exception decompiling
     */
    private void doRun(Map<Method, CEntryPointData> entryPoints, Method mainEntryPoint, JavaMainWrapper.JavaMainSupport javaMainSupport, String imageName, AbstractBootImage.NativeImageKind k, SubstitutionProcessor harnessSubstitutions, ForkJoinPool compilationExecutor, ForkJoinPool analysisExecutor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void registerEntryPoints(Map<Method, CEntryPointData> entryPoints) {
        for (Method m : this.loader.findAnnotatedMethods(CEntryPoint.class)) {
            if (!Modifier.isStatic(m.getModifiers())) {
                throw UserError.abort("entry point method " + m.getDeclaringClass().getName() + "." + m.getName() + " is not static. Add a static modifier to the method.");
            }
            boolean include = true;
            CEntryPointOptions options = m.getAnnotation(CEntryPointOptions.class);
            if (options != null) {
                BooleanSupplier instance;
                try {
                    Constructor<? extends BooleanSupplier> constructor = options.include().getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    instance = constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
                include = instance.getAsBoolean();
            }
            if (!include) continue;
            entryPoints.put(m, CEntryPointData.create(m));
        }
    }

    private void recordMethodsWithStackValues() {
        this.bigbang.getUniverse().getMethods().parallelStream().forEach(analysisMethod -> {
            if (analysisMethod.getTypeFlow() != null && analysisMethod.getTypeFlow().getGraph() != null && analysisMethod.getTypeFlow().getGraph().getNodes(StackValueNode.TYPE).isNotEmpty()) {
                this.hUniverse.recordMethodWithStackValues((AnalysisMethod)analysisMethod);
            }
        });
    }

    private static void recordRestrictHeapAccessCallees(Collection<AnalysisMethod> methods) {
        ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).aggregateMethods(methods);
    }

    public void interruptBuild() {
        this.shutdownPoolSafe();
    }

    private void shutdownPoolSafe() {
        if (this.imageBuildPool != null) {
            this.imageBuildPool.shutdownNow();
        }
    }

    public static void registerGraphBuilderPlugins(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, HostedProviders providers, AnalysisMetaAccess aMetaAccess, AnalysisUniverse aUniverse, HostedMetaAccess hMetaAccess, HostedUniverse hUniverse, NativeLibraries nativeLibs, ImageClassLoader loader, boolean analysis, boolean hosted) {
        AnalysisMetaAccess pluginsMetaAccess;
        assert (!analysis || hosted) : "analysis must always be hosted";
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins((InvocationPlugins)new SubstitutionInvocationPlugins());
        WordOperationPlugin wordOperationPlugin = new WordOperationPlugin(providers.getSnippetReflection(), providers.getWordTypes());
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)replacements);
        plugins.appendNodePlugin((NodePlugin)new IntrinsifyMethodHandlesInvocationPlugin((Providers)providers, aUniverse, hUniverse));
        plugins.appendNodePlugin((NodePlugin)new DeletedFieldsPlugin());
        plugins.appendNodePlugin((NodePlugin)new InjectedAccessorsPlugin());
        plugins.appendNodePlugin((NodePlugin)new ConstantFoldLoadFieldPlugin());
        plugins.appendNodePlugin((NodePlugin)new CInterfaceInvocationPlugin(providers.getMetaAccess(), providers.getWordTypes(), nativeLibs));
        plugins.appendNodePlugin((NodePlugin)new LocalizationFeature.CharsetNodePlugin());
        plugins.appendInlineInvokePlugin((InlineInvokePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)wordOperationPlugin);
        plugins.appendTypePlugin((TypePlugin)new TrustedInterfaceTypePlugin());
        plugins.appendNodePlugin((NodePlugin)wordOperationPlugin);
        plugins.appendNodePlugin((NodePlugin)new ImplicitExceptionsPlugin(providers.getMetaAccess(), providers.getForeignCalls()));
        plugins.setClassInitializationPlugin((ClassInitializationPlugin)new SubstrateClassInitializationPlugin((SVMHost)aUniverse.hostVM()));
        featureHandler.forEachGraalFeature(feature -> feature.registerNodePlugins((MetaAccessProvider)(analysis ? aMetaAccess : hMetaAccess), plugins, analysis, hosted));
        HostedSnippetReflectionProvider hostedSnippetReflection = new HostedSnippetReflectionProvider((SVMHost)aUniverse.getHostVM());
        NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(providers.getMetaAccess(), (SnippetReflectionProvider)hostedSnippetReflection, providers.getForeignCalls(), providers.getWordTypes());
        for (Class<NodeIntrinsicPluginFactory> factoryClass : loader.findSubclasses(NodeIntrinsicPluginFactory.class)) {
            NodeIntrinsicPluginFactory factory;
            if (Modifier.isAbstract(factoryClass.getModifiers()) || factoryClass.getName().contains("hotspot")) continue;
            try {
                factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            factory.registerPlugins(plugins.getInvocationPlugins(), (NodeIntrinsicPluginFactory.InjectionProvider)nodeIntrinsificationProvider);
        }
        BytecodeProvider replacementBytecodeProvider = replacements.getDefaultReplacementBytecodeProvider();
        boolean explicitUnsafeNullChecks = SubstrateOptions.SpawnIsolates.getValue();
        StandardGraphBuilderPlugins.registerInvocationPlugins((MetaAccessProvider)providers.getMetaAccess(), (SnippetReflectionProvider)providers.getSnippetReflection(), (InvocationPlugins)plugins.getInvocationPlugins(), (BytecodeProvider)replacementBytecodeProvider, (!hosted ? 1 : 0) != 0, (boolean)explicitUnsafeNullChecks);
        AMD64GraphBuilderPlugins.register((GraphBuilderConfiguration.Plugins)plugins, (BytecodeProvider)replacementBytecodeProvider, (AMD64)((AMD64)ConfigurationValues.getTarget().arch), (boolean)true, (boolean)explicitUnsafeNullChecks);
        Object object = pluginsMetaAccess = hosted && !analysis ? hMetaAccess : aMetaAccess;
        assert (pluginsMetaAccess != null);
        SubstrateGraphBuilderPlugins.registerInvocationPlugins((MetaAccessProvider)pluginsMetaAccess, providers.getConstantReflection(), hostedSnippetReflection, plugins.getInvocationPlugins(), replacementBytecodeProvider, analysis);
        featureHandler.forEachGraalFeature(feature -> feature.registerInvocationPlugins((Providers)providers, hostedSnippetReflection, plugins.getInvocationPlugins(), analysis, hosted));
        providers.setGraphBuilderPlugins(plugins);
        replacements.setGraphBuilderPlugins(plugins);
        if (runtimeConfig != null && runtimeConfig.getProviders() instanceof HostedProviders) {
            ((HostedProviders)runtimeConfig.getProviders()).setGraphBuilderPlugins(plugins);
            for (Backend backend : runtimeConfig.getBackends()) {
                ((HostedProviders)backend.getProviders()).setGraphBuilderPlugins(plugins);
            }
        }
    }

    public static void registerReplacements(DebugContext debug, FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, boolean hosted) {
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        Providers runtimeCallProviders = runtimeConfig != null ? runtimeConfig.getBackendForNormalMethod().getProviders() : providers;
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)providers.getForeignCalls();
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : SnippetRuntime.getRuntimeCalls()) {
            foreignCallsProvider.getForeignCalls().put(descriptor, new SubstrateForeignCallLinkage(runtimeCallProviders, descriptor));
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerForeignCalls(runtimeConfig, runtimeCallProviders, snippetReflection, foreignCallsProvider.getForeignCalls(), hosted));
        try (DebugContext.Scope s = debug.scope((Object)"RegisterLowerings", (Object)new DebugDumpScope("RegisterLowerings"));){
            SubstrateLoweringProvider lowerer = (SubstrateLoweringProvider)providers.getLowerer();
            Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = lowerer.getLowerings();
            Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
            if (hosted) {
                mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
            }
            Iterable<DebugHandlersFactory> factories = runtimeConfig != null ? runtimeConfig.getDebugHandlersFactories() : Collections.singletonList(new GraalDebugHandlersFactory(snippetReflection));
            lowerer.setConfiguration(runtimeConfig, (OptionValues)options, factories, providers, snippetReflection);
            NonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, factories, providers, snippetReflection, lowerings);
            ArithmeticSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            MonitorSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            TypeSnippets.registerLowerings(runtimeConfig, options, factories, providers, snippetReflection, lowerings);
            ExceptionSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            if (hosted) {
                AssertSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
                DeoptHostedSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            } else {
                DeoptRuntimeSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            }
            if (NativeImageOptions.DeoptimizeAll.getValue().booleanValue()) {
                DeoptTestSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
            }
            featureHandler.forEachGraalFeature(arg_0 -> NativeImageGenerator.lambda$registerReplacements$20(runtimeConfig, (OptionValues)options, factories, providers, snippetReflection, lowerings, hosted, arg_0));
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        SubstrateReplacements replacements = (SubstrateReplacements)providers.getReplacements();
        assert (NativeImageGenerator.checkInvocationPluginMethods(replacements));
        replacements.encodeSnippets();
    }

    private static boolean checkInvocationPluginMethods(SubstrateReplacements replacements) {
        Iterator<ResolvedJavaMethod> iterator = replacements.getDelayedInvocationPluginMethods().iterator();
        while (iterator.hasNext()) {
            String hostedDescriptor;
            String runtimeDescriptor;
            ResolvedJavaMethod method;
            ResolvedJavaMethod unwrapped = method = iterator.next();
            while (unwrapped instanceof WrappedJavaMethod) {
                unwrapped = ((WrappedJavaMethod)unwrapped).getWrapped();
            }
            if (method != unwrapped && !(runtimeDescriptor = method.getSignature().toMethodDescriptor()).equals(hostedDescriptor = unwrapped.getSignature().toMethodDescriptor())) {
                String name = method.format("%H.%n");
                throw new AssertionError((Object)String.format("Cannot have invocation plugin for a method whose runtime signature is different from its hosted signature:%n            method: %s%n  hosted signature: %s%n runtime signature: %s", name, runtimeDescriptor, hostedDescriptor));
            }
            assert (method == unwrapped || method.getSignature().toMethodDescriptor().equals(unwrapped.getSignature().toMethodDescriptor()));
        }
        return true;
    }

    public static Suites createSuites(FeatureHandler featureHandler, RuntimeConfiguration runtimeConfig, SnippetReflectionProvider snippetReflection, boolean hosted) {
        Providers runtimeCallProviders = runtimeConfig.getBackendForNormalMethod().getProviders();
        Object options = hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton();
        Suites suites = GraalConfiguration.instance().createSuites((OptionValues)options, hosted);
        PhaseSuite highTier = suites.getHighTier();
        PhaseSuite midTier = suites.getMidTier();
        PhaseSuite lowTier = suites.getLowTier();
        ListIterator position = hosted ? GraalConfiguration.instance().createHostedInliners((PhaseSuite<HighTierContext>)highTier) : highTier.findPhase(InliningPhase.class);
        if (position != null) {
            position.add(new DeadStoreRemovalPhase());
            position.add(new RemoveUnwindPhase());
        } else {
            highTier.prependPhase((BasePhase)new RemoveUnwindPhase());
            highTier.prependPhase((BasePhase)new DeadStoreRemovalPhase());
        }
        highTier.appendPhase((BasePhase)new StackValuePhase());
        lowTier.addBeforeLast((BasePhase)new OptimizeExceptionCallsPhase());
        CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
        SubstrateRegisterConfig registerConfig = (SubstrateRegisterConfig)runtimeCallProviders.getCodeCache().getRegisterConfig();
        SubstrateAMD64AddressLowering addressLowering = new SubstrateAMD64AddressLowering(compressEncoding, registerConfig);
        lowTier.findPhase(FixReadsPhase.class).add(new AddressLoweringPhase((AddressLoweringPhase.AddressLowering)addressLowering));
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            midTier.findPhase(LoopSafepointInsertionPhase.class).add(new MethodSafepointInsertionPhase());
        } else {
            VMError.guarantee(midTier.removePhase(LoopSafepointInsertionPhase.class));
        }
        if (hosted) {
            lowTier.appendPhase((BasePhase)new VerifyNoGuardsPhase());
            highTier.removePhase(InliningPhase.class);
            highTier.findPhase(ConvertDeoptimizeToGuardPhase.class, true).remove();
            midTier.findPhase(DeoptimizationGroupingPhase.class).remove();
        } else {
            ListIterator it = midTier.findPhase(DeoptimizationGroupingPhase.class);
            it.previous();
            it.add(new CollectDeoptimizationSourcePositionsPhase());
        }
        featureHandler.forEachGraalFeature(feature -> feature.registerGraalPhases(runtimeCallProviders, snippetReflection, suites, hosted));
        return suites;
    }

    public static LIRSuites createLIRSuites(FeatureHandler featureHandler, Providers providers, boolean hosted) {
        LIRSuites lirSuites = Suites.createLIRSuites((CompilerConfiguration)new CommunityCompilerConfiguration(), (OptionValues)(hosted ? HostedOptionValues.singleton() : RuntimeOptionValues.singleton()));
        assert (NativeImageGenerator.addAssertionLIRPhases(lirSuites, hosted));
        return lirSuites;
    }

    private static boolean addAssertionLIRPhases(LIRSuites lirSuites, boolean hosted) {
        if (hosted) {
            lirSuites.getPostAllocationOptimizationStage().appendPhase((LIRPhase)new VerifyDeoptFrameStatesLIRPhase());
        }
        return true;
    }

    private void checkUniverse() {
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            for (int i = 0; i < method.getTypeFlow().getOriginalMethodFlows().getParameters().length; ++i) {
                AnalysisType declaredType;
                TypeState state = method.getTypeFlow().getParameterTypeState(this.bigbang, i);
                if (state == null || !(declaredType = method.getTypeFlow().getOriginalMethodFlows().getParameter(i).getDeclaredType()).isInterface() || (state = TypeState.forSubtraction((BigBang)this.bigbang, (TypeState)state, (TypeState)declaredType.getTypeFlow(this.bigbang, true).getState())).isEmpty()) continue;
                String methodKey = method.format("%H.%n(%p)");
                this.bigbang.getUnsupportedFeatures().addMessage(methodKey, method, "Parameter " + i + " of " + methodKey + " has declared type " + declaredType.toJavaName(true) + " which is incompatible with types in state: " + state);
            }
        }
        for (AnalysisField field : this.aUniverse.getFields()) {
            AnalysisType declaredType;
            TypeState state = field.getTypeState();
            if (state == null || !(declaredType = field.getType()).isInterface() || (state = TypeState.forSubtraction((BigBang)this.bigbang, (TypeState)state, (TypeState)declaredType.getTypeFlow(this.bigbang, true).getState())).isEmpty()) continue;
            String fieldKey = field.format("%H.%n");
            this.bigbang.getUnsupportedFeatures().addMessage(fieldKey, null, "Field " + fieldKey + " has declared type " + declaredType.toJavaName(true) + " which is incompatible with types in state: " + state);
        }
        if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue()) {
            for (AnalysisMethod method : this.aUniverse.getMethods()) {
                if (!method.isInvoked() && !method.isImplementationInvoked() || method.getAnnotation(Fold.class) != null) continue;
                this.checkName(method.format("%H.%n(%p)"), method);
            }
            for (AnalysisField field : this.aUniverse.getFields()) {
                if (!field.isAccessed()) continue;
                this.checkName(field.format("%H.%n"), null);
            }
            for (AnalysisType type : this.aUniverse.getTypes()) {
                if (!type.isInstantiated() && !type.isInTypeCheck()) continue;
                this.checkName(type.toJavaName(true), null);
            }
        }
        for (AnalysisMethod method : this.aUniverse.getMethods()) {
            List invocations;
            if (!method.isEntryPoint() || (invocations = method.getJavaInvocations()).size() <= 0) continue;
            String name = method.format("%H.%n(%p)");
            StringBuilder msg = new StringBuilder("Native entry point is also called from within Java. Invocations: ");
            String sep = "";
            for (AnalysisMethod invocation : invocations) {
                msg.append(sep).append(invocation.format("%H.%n(%p)"));
                sep = ", ";
            }
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, msg.toString());
        }
    }

    private void checkName(String name, AnalysisMethod method) {
        String lname = name.toLowerCase();
        if (lname.contains("hosted")) {
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, "Hosted element used at run time: " + name);
        } else if (!name.startsWith("jdk.internal") && lname.contains("hotspot")) {
            this.bigbang.getUnsupportedFeatures().addMessage(name, method, "HotSpot element used at run time: " + name);
        }
    }

    private NativeLibraries processNativeLibraryImports(OptionValues options, MetaAccessProvider metaAccess, AnalysisConstantReflectionProvider aConstantReflection, SnippetReflectionProvider snippetReflection) {
        String imageName = (String)NativeImageOptions.Name.getValue(options);
        try (Timer.StopTimer t = new Timer(imageName, "(cap)").start();){
            NativeLibraries nativeLibs = new NativeLibraries(aConstantReflection, metaAccess, snippetReflection, ConfigurationValues.getTarget());
            for (Method method : this.loader.findAnnotatedMethods(CConstant.class)) {
                nativeLibs.loadJavaMethod(metaAccess.lookupJavaMethod((Executable)method));
            }
            for (Class clazz : this.loader.findAnnotatedClasses(CStruct.class)) {
                nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
            }
            for (Class clazz : this.loader.findAnnotatedClasses(RawStructure.class)) {
                nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
            }
            for (Class clazz : this.loader.findAnnotatedClasses(CPointerTo.class)) {
                nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
            }
            for (Class clazz : this.loader.findAnnotatedClasses(CEnum.class)) {
                nativeLibs.loadJavaType(metaAccess.lookupJavaType(clazz));
            }
            for (CLibrary cLibrary : this.loader.findAnnotations(CLibrary.class)) {
                nativeLibs.addLibrary(cLibrary.value());
            }
            nativeLibs.finish(this.tempDirectory());
            nativeLibs.reportErrors();
            NativeLibraries nativeLibraries = nativeLibs;
            return nativeLibraries;
        }
    }

    public AbstractBootImage getBuiltImage() {
        return this.image;
    }

    public BigBang getBigbang() {
        return this.bigbang;
    }

    private void printTypes() {
        for (HostedType type : this.hUniverse.getTypes()) {
            System.out.format("%8d %s  ", type.getTypeID(), type.toJavaName(true));
            if (type.getSuperclass() != null) {
                System.out.format("extends %d %s  ", type.getSuperclass().getTypeID(), type.getSuperclass().toJavaName(false));
            }
            if (type.getInterfaces().length > 0) {
                System.out.print("implements ");
                String sep = "";
                for (HostedInterface interf : type.getInterfaces()) {
                    System.out.format("%s%d %s", sep, interf.getTypeID(), interf.toJavaName(false));
                    sep = ", ";
                }
                System.out.print("  ");
            }
            if (type.getWrapped().isInstantiated()) {
                System.out.print("instantiated  ");
            }
            if (type.getWrapped().isInTypeCheck()) {
                System.out.print("inTypeCheck  ");
            }
            System.out.format("assignableFrom %s  ", NativeImageGenerator.matchesToString(type.getAssignableFromMatches()));
            System.out.format("instanceOf typeID %d, # %d  ", type.getInstanceOfFromTypeID(), type.getInstanceOfNumTypeIDs());
            int le = type.getHub().getLayoutEncoding();
            if (LayoutEncoding.isPrimitive(le)) {
                System.out.print("primitive  ");
            } else if (LayoutEncoding.isInterface(le)) {
                System.out.print("interface  ");
            } else if (LayoutEncoding.isAbstract(le)) {
                System.out.print("abstract  ");
            } else if (LayoutEncoding.isInstance(le)) {
                System.out.format("instance size %d  ", LayoutEncoding.getInstanceSize(le).rawValue());
            } else if (LayoutEncoding.isObjectArray(le)) {
                System.out.format("object array base %d shift %d scale %d  ", LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else if (LayoutEncoding.isPrimitiveArray(le)) {
                System.out.format("primitive array base %d shift %d scale %d  ", LayoutEncoding.getArrayBaseOffset(le).rawValue(), LayoutEncoding.getArrayIndexShift(le), LayoutEncoding.getArrayIndexScale(le));
            } else {
                throw VMError.shouldNotReachHere();
            }
            System.out.println();
            for (HostedType sub : type.getSubTypes()) {
                System.out.format("               s %d %s\n", sub.getTypeID(), sub.toJavaName(false));
            }
            if (type.isInterface()) {
                for (HostedMethod method : this.hUniverse.getMethods()) {
                    if (method.getDeclaringClass() != type) continue;
                    NativeImageGenerator.printMethod(method, -1);
                }
                continue;
            }
            if (!type.isInstanceClass()) continue;
            HostedField[] fields = type.getInstanceFields(false);
            fields = Arrays.copyOf(fields, fields.length);
            Arrays.sort(fields, Comparator.comparing(HostedField::toString));
            for (HostedField field : fields) {
                System.out.println("               f " + field.getLocation() + ": " + field.format("%T %n"));
            }
            HostedMethod[] vtable = type.getVTable();
            for (int i = 0; i < vtable.length; ++i) {
                if (vtable[i] == null) continue;
                NativeImageGenerator.printMethod(vtable[i], i);
            }
            for (HostedMethod method : this.hUniverse.getMethods()) {
                if (method.getDeclaringClass() != type || method.hasVTableIndex()) continue;
                NativeImageGenerator.printMethod(method, -1);
            }
        }
    }

    private static void printMethod(HostedMethod method, int vtableIndex) {
        if (vtableIndex != -1) {
            System.out.print("               v " + vtableIndex + " ");
        } else {
            System.out.print("               m ");
        }
        if (method.hasVTableIndex()) {
            System.out.print(method.getVTableIndex() + " ");
        }
        System.out.print(method.format("%r %n(%p)") + ": " + method.getImplementations().length + " [");
        String sep = "";
        for (HostedMethod impl : method.getImplementations()) {
            System.out.print(sep + impl.getDeclaringClass().toJavaName(false));
            sep = ", ";
        }
        System.out.println("]");
    }

    private static String matchesToString(int[] matches) {
        if (matches == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < matches.length; i += 2) {
            result.append("[").append(matches[i]).append(", ").append(matches[i] + matches[i + 1] - 1).append("] ");
        }
        return result.toString();
    }

    public static Path generatedFiles(OptionValues optionValues) {
        String pathName = (String)SubstrateOptions.Path.getValue(optionValues);
        Path path = FileSystems.getDefault().getPath(pathName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw VMError.shouldNotReachHere("Output path is not a directory: " + pathName);
        }
        return path.toAbsolutePath();
    }

    public synchronized Path tempDirectory() {
        if (this.tempDirectory == null) {
            try {
                String tempName = NativeImageOptions.TempDirectory.getValue();
                if (tempName == null || tempName.isEmpty()) {
                    this.tempDirectory = Files.createTempDirectory("SVM-", new FileAttribute[0]);
                    this.deleteTempDirectory = true;
                } else {
                    this.tempDirectory = FileSystems.getDefault().getPath(tempName, new String[0]).resolve("SVM-" + System.currentTimeMillis());
                    assert (!Files.exists(this.tempDirectory, new LinkOption[0]));
                    Files.createDirectories(this.tempDirectory, new FileAttribute[0]);
                }
            }
            catch (IOException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        return this.tempDirectory.toAbsolutePath();
    }

    private static void deleteAll(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private static <T extends Enum<T>> Set<T> parseCSVtoEnum(Class<T> enumType, String[] csvEnumValues) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (String enumValue : OptionUtils.flatten(",", csvEnumValues)) {
            try {
                result.add(Enum.valueOf(enumType, enumValue));
            }
            catch (IllegalArgumentException iae) {
                throw VMError.shouldNotReachHere("Value '" + enumValue + "' does not exist. Available values are:\n" + Arrays.toString(AMD64.CPUFeature.values()));
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$registerReplacements$20(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable factories, Providers providers, SnippetReflectionProvider snippetReflection, Map lowerings, boolean hosted, GraalFeature feature) {
        feature.registerLowerings(runtimeConfig, options, factories, providers, snippetReflection, lowerings, hosted);
    }

    private static /* synthetic */ void lambda$doRun$14(FeatureImpl.AfterImageWriteAccessImpl afterConfig, Feature feature) {
        feature.afterImageWrite((Feature.AfterImageWriteAccess)afterConfig);
    }

    private static /* synthetic */ void lambda$doRun$13(FeatureImpl.BeforeImageWriteAccessImpl beforeConfig, Feature feature) {
        feature.beforeImageWrite((Feature.BeforeImageWriteAccess)beforeConfig);
    }

    private static /* synthetic */ void lambda$doRun$12(FeatureImpl.AfterHeapLayoutAccessImpl config, Feature feature) {
        feature.afterHeapLayout((Feature.AfterHeapLayoutAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$11(FeatureImpl.AfterCompilationAccessImpl config, Feature feature) {
        feature.afterCompilation((Feature.AfterCompilationAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$10(FeatureImpl.BeforeCompilationAccessImpl config, Feature feature) {
        feature.beforeCompilation((Feature.BeforeCompilationAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$9(Feature.OnAnalysisExitAccess onExitConfig, Feature feature) {
        try {
            feature.onAnalysisExit(onExitConfig);
        }
        catch (Exception ex) {
            System.err.println("Exception during " + feature.getClass().getName() + ".onAnalysisExit()");
        }
    }

    private static /* synthetic */ void lambda$doRun$8(FeatureImpl.AfterAnalysisAccessImpl postConfig, Feature feature) {
        feature.afterAnalysis((Feature.AfterAnalysisAccess)postConfig);
    }

    private static /* synthetic */ void lambda$doRun$7(FeatureImpl.DuringAnalysisAccessImpl config, Feature feature) {
        feature.duringAnalysis((Feature.DuringAnalysisAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$6(FeatureImpl.BeforeAnalysisAccessImpl config, Feature feature) {
        feature.beforeAnalysis((Feature.BeforeAnalysisAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$5(Method method, CEntryPointData entryPointData) {
        CEntryPointCallStubSupport.singleton().registerStubForMethod(method, () -> entryPointData);
    }

    private static /* synthetic */ void lambda$doRun$3(FeatureImpl.DuringSetupAccessImpl config, Feature feature) {
        feature.duringSetup((Feature.DuringSetupAccess)config);
    }

    private static /* synthetic */ void lambda$doRun$2(FeatureImpl.AfterRegistrationAccessImpl access, Feature feature) {
        feature.afterRegistration((Feature.AfterRegistrationAccess)access);
    }

    static class SubstitutionInvocationPlugins
    extends InvocationPlugins {
        SubstitutionInvocationPlugins() {
        }

        protected void register(InvocationPlugin plugin, boolean isOptional, boolean allowOverwrite, Type declaringClass, String name, Type ... argumentTypes) {
            Class<?> targetClass = declaringClass instanceof Class ? ((AnnotationSubstitutionProcessor)((Object)ImageSingletons.lookup(AnnotationSubstitutionProcessor.class))).getTargetClass(declaringClass) : declaringClass;
            super.register(plugin, isOptional, allowOverwrite, targetClass, name, argumentTypes);
        }
    }
}

